/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports;

import java.util.Iterator;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.EngineFactory;

public class ImportUtils {
    private ImportUtils() {
    }

    public static Account getRootExpenseAccount() {
        return ImportUtils.searchForRootType(EngineFactory.getEngine("default").getRootAccount(), AccountType.EXPENSE);
    }

    public static Account getRootIncomeAccount() {
        return ImportUtils.searchForRootType(EngineFactory.getEngine("default").getRootAccount(), AccountType.INCOME);
    }

    public static Account getRootBankAccount() {
        return ImportUtils.searchForRootType(EngineFactory.getEngine("default").getRootAccount(), AccountType.BANK);
    }

    private static Account searchForRootType(Account account, AccountType type) {
        Account a2;
        Account result = null;
        for (Account a2 : account.getChildren()) {
            if (!a2.instanceOf(type)) continue;
            return a2;
        }
        Iterator<Account> i$ = account.getChildren().iterator();
        while (i$.hasNext() && (result = ImportUtils.searchForRootType(a2 = i$.next(), type)) == null) {
        }
        return result;
    }
}

