/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.account.AccountTreeModel;

public abstract class AbstractAccountListPane
extends JScrollPane
implements MessageListener {
    AccountTreeModel model = new AccountTreeModel();
    Account selectedAccount;
    boolean rootVisible;
    Preferences p;
    private static final String HIDDEN_VISIBLE = "HiddenVisible";
    private static final String EXPENSE_VISIBLE = "ExpenseVisible";
    private static final String INCOME_VISIBLE = "IncomeVisible";
    private static final String ACCOUNT_VISIBLE = "AccountVisible";

    AbstractAccountListPane(String identifier, boolean rootVisible) {
        this.rootVisible = rootVisible;
        this.p = Preferences.userRoot().node("/jgnash/ui/AccountListPane/" + identifier);
        this.buildUI();
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
    }

    static Engine getEngine() {
        return EngineFactory.getEngine("default");
    }

    private void buildUI() {
        this.setMinimumSize(new Dimension(100, 100));
        this.setViewportView(this.createModelAndView());
        this.model.setAccountVisible(this.p.getBoolean(ACCOUNT_VISIBLE, true));
        this.model.setExpenseVisible(this.p.getBoolean(EXPENSE_VISIBLE, true));
        this.model.setHiddenVisible(this.p.getBoolean(HIDDEN_VISIBLE, true));
        this.model.setIncomeVisible(this.p.getBoolean(INCOME_VISIBLE, true));
        this.refresh();
        this._expand();
    }

    protected abstract JComponent createModelAndView();

    public boolean getAccountVisible() {
        return this.model.getAccountVisible();
    }

    public void setAccountVisible(boolean visible) {
        this.p.putBoolean(ACCOUNT_VISIBLE, visible);
        this.model.setAccountVisible(visible);
        this.expand();
    }

    public boolean getIncomeVisible() {
        return this.model.getIncomeVisible();
    }

    public void setIncomeVisible(boolean visible) {
        this.p.putBoolean(INCOME_VISIBLE, visible);
        this.model.setIncomeVisible(visible);
        this.expand();
    }

    public boolean getExpenseVisible() {
        return this.model.getExpenseVisible();
    }

    public void setExpenseVisible(boolean visible) {
        this.p.putBoolean(EXPENSE_VISIBLE, visible);
        this.model.setExpenseVisible(visible);
        this.expand();
    }

    public boolean getHiddenVisible() {
        return this.model.getHiddenVisible();
    }

    public void setHiddenVisible(boolean visible) {
        this.p.putBoolean(HIDDEN_VISIBLE, visible);
        this.model.setHiddenVisible(visible);
        this.expand();
    }

    private synchronized void refresh() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AbstractAccountListPane.getEngine() != null) {
                    AbstractAccountListPane.this.model.reload();
                    AbstractAccountListPane.this.scrollToTop();
                }
            }
        });
    }

    protected abstract void scrollToTop();

    public synchronized void expand() {
        if (EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractAccountListPane.this._expand();
                }
            });
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AbstractAccountListPane.this._expand();
                    }
                });
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }

    protected abstract void _expand();

    public Account getSelectedAccount() {
        return this.selectedAccount;
    }

    public abstract void setSelectedAccount(Account var1);

    private void close() {
        this.selectedAccount = null;
        this.model.setRoot(null);
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractAccountListPane.this.close();
                }
            });
            return;
        }
        if (EngineFactory.getEngine("default") == null) {
            return;
        }
        final Account a = (Account)event.getObject(MessageProperty.ACCOUNT);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case ACCOUNT_ADD: {
                        AbstractAccountListPane.this.model.reload();
                        AbstractAccountListPane.this.expand();
                        break;
                    }
                    case ACCOUNT_MODIFY: {
                        AbstractAccountListPane.this.model.reload();
                        AbstractAccountListPane.this.expand();
                        break;
                    }
                    case ACCOUNT_REMOVE: {
                        if (a != null && AbstractAccountListPane.this.selectedAccount != null) {
                            if (AbstractAccountListPane.this.selectedAccount.equals(a)) {
                                AbstractAccountListPane.this.selectedAccount = null;
                            }
                            AbstractAccountListPane.this.model.removeAccount(a);
                            break;
                        }
                        AbstractAccountListPane.this.model.reload();
                        AbstractAccountListPane.this.expand();
                        break;
                    }
                    case ACCOUNT_VISABILITY_CHANGE: {
                        AbstractAccountListPane.this.model.reload();
                        AbstractAccountListPane.this.expand();
                        break;
                    }
                    case FILE_LOAD_SUCCESS: 
                    case FILE_NEW_SUCCESS: {
                        AbstractAccountListPane.this.refresh();
                        AbstractAccountListPane.this.expand();
                        break;
                    }
                }
            }
        });
    }
}

