/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import jgnash.ui.UIApplication;
import jgnash.ui.account.AbstractAccountListPane;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class AccountListFilterDialog
extends JDialog
implements ActionListener {
    private Resource rb = Resource.get();
    private AbstractAccountListPane list;
    private JCheckBox incomeCheck;
    private JCheckBox hiddenCheck;
    private JCheckBox expenseCheck;
    private JCheckBox accountCheck;
    private JButton closeButton;

    public AccountListFilterDialog(AbstractAccountListPane list) {
        super((Frame)((Object)UIApplication.getFrame()), false);
        this.setTitle(this.rb.getString("Title.AccountFilter"));
        this.setDefaultCloseOperation(2);
        this.list = list;
        this.layoutMainPanel();
        this.resetForm();
        DialogUtils.addBoundsListener(this);
    }

    private void initComponents() {
        this.closeButton = new JButton(this.rb.getString("Button.Close"));
        this.accountCheck = new JCheckBox(this.rb.getString("Button.BankAccounts"));
        this.expenseCheck = new JCheckBox(this.rb.getString("Button.ExpenseAccounts"));
        this.incomeCheck = new JCheckBox(this.rb.getString("Button.IncomeAccounts"));
        this.hiddenCheck = new JCheckBox(this.rb.getString("Button.Hidden"));
        this.closeButton.addActionListener(this);
        this.accountCheck.addActionListener(this);
        this.expenseCheck.addActionListener(this);
        this.hiddenCheck.addActionListener(this);
        this.incomeCheck.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("max(100dlu;pref):g(1.0)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.AccountFilter"));
        builder.append((Component)this.accountCheck);
        builder.nextLine();
        builder.append((Component)this.expenseCheck);
        builder.nextLine();
        builder.append((Component)this.incomeCheck);
        builder.nextLine();
        builder.append((Component)this.hiddenCheck);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildCloseBar((JButton)this.closeButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void resetForm() {
        this.hiddenCheck.setSelected(this.list.getHiddenVisible());
        this.accountCheck.setSelected(this.list.getAccountVisible());
        this.incomeCheck.setSelected(this.list.getIncomeVisible());
        this.expenseCheck.setSelected(this.list.getExpenseVisible());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.hiddenCheck) {
            this.list.setHiddenVisible(this.hiddenCheck.isSelected());
        } else if (e.getSource() == this.accountCheck) {
            this.list.setAccountVisible(this.accountCheck.isSelected());
        } else if (e.getSource() == this.incomeCheck) {
            this.list.setIncomeVisible(this.incomeCheck.isSelected());
        } else if (e.getSource() == this.expenseCheck) {
            this.list.setExpenseVisible(this.expenseCheck.isSelected());
        }
    }
}

