/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.imports.qif.NoAccountException;
import jgnash.imports.qif.QifImport;
import jgnash.imports.qif.QifUtils;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.components.MultiLineLabel;
import jgnash.ui.components.YesNoDialog;
import jgnash.ui.util.TextResource;
import jgnash.ui.wizards.imports.qif.PartialDialog;
import jgnash.util.Resource;

public class ImportQifAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = 1L;
    private static final String QIFDIR = "QifDirectory";
    private static final boolean debug = true;

    private void importQif() {
        final Resource rb = Resource.get();
        Preferences pref = Preferences.userNodeForPackage(ImportQifAction.class);
        final Logger logger = Logger.getLogger("qifimport");
        try {
            FileHandler fh = new FileHandler("%h/jgnash%g.log");
            fh.setFormatter(new SimpleFormatter());
            logger.addHandler(fh);
            logger.setLevel(Level.FINEST);
        }
        catch (IOException ioe) {
            logger.severe("Could not install file handler");
        }
        Engine engine = EngineFactory.getEngine("default");
        if (engine.getRootAccount() == null) {
            StaticUIMethods.displayError(rb.getString("Message.ErrorCreateBasicAccounts"));
            return;
        }
        final JFileChooser chooser = new JFileChooser(pref.get(QIFDIR, null));
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Qif Files (*.qif)", "qif"));
        if (chooser.showOpenDialog(null) == 0) {
            pref.put(QIFDIR, chooser.getCurrentDirectory().getAbsolutePath());
            boolean fullFile = QifUtils.isFullFile(chooser.getSelectedFile());
            if (fullFile) {
                final String dateFormat = ImportQifAction.getQIFDateFormat();
                if (dateFormat == null) {
                    return;
                }
                class ImportFile
                extends SwingWorker<Void, Void> {
                    ImportFile() {
                    }

                    @Override
                    protected Void doInBackground() throws Exception {
                        UIApplication.getFrame().displayWaitMessage(rb.getString("Message.ImportWait"));
                        QifImport imp = new QifImport();
                        try {
                            imp.doFullParse(chooser.getSelectedFile(), dateFormat);
                        }
                        catch (NoAccountException e) {
                            logger.severe("Mistook partial qif file as a full qif file");
                            e.printStackTrace();
                        }
                        imp.dumpStats();
                        imp.doFullImport();
                        if (imp.getDuplicateCount() > 0) {
                            String message = imp.getDuplicateCount() + " duplicate transactions were found";
                            logger.info(message);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        UIApplication.getFrame().stopWaitMessage();
                    }
                }
                new ImportFile().execute();
            } else {
                QifImport imp = new QifImport();
                imp.doPartialParse(chooser.getSelectedFile());
                imp.dumpStats();
                if (imp.getParser().accountList.isEmpty()) {
                    StaticUIMethods.displayError(rb.getString("Message.ErrorParseTransactions"));
                    return;
                }
                PartialDialog dlg = new PartialDialog(imp.getParser());
                dlg.setLocationRelativeTo(null);
                dlg.setVisible(true);
                if (dlg.isWizardValid()) {
                    imp.doPartialImport(dlg.getAccount());
                    if (imp.getDuplicateCount() > 0 && YesNoDialog.showYesNoDialog((Frame)((Object)UIApplication.getFrame()), new MultiLineLabel(TextResource.getString("DupeTransImport.txt")), rb.getString("Title.DuplicateTransactionsFound"), 2)) {
                        Transaction[] t;
                        for (Transaction element : t = imp.getDuplicates()) {
                            engine.addTransaction(element);
                        }
                    }
                }
            }
        }
    }

    private static String getQIFDateFormat() {
        String DATE_FORMAT = "dateFormat";
        String dateFormat = null;
        Resource rb = Resource.get();
        Preferences pref = Preferences.userNodeForPackage(ImportQifAction.class);
        String[] formats = new String[]{"mm/dd/yyyy", "dd/mm/yyyy"};
        JComboBox<String> combo = new JComboBox<String>(formats);
        combo.setSelectedIndex(pref.getInt(DATE_FORMAT, 0));
        Object[] options = new Object[]{rb.getString("Button.Ok"), rb.getString("Button.Cancel")};
        int result = JOptionPane.showOptionDialog((Component)((Object)UIApplication.getFrame()), combo, rb.getString("Title.SelQifDateFormat"), 0, -1, null, options, options[1]);
        if (result == 0) {
            dateFormat = (String)combo.getSelectedItem();
        }
        pref.putInt(DATE_FORMAT, combo.getSelectedIndex());
        return dateFormat;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.importQif();
    }
}

