/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.commodity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import jgnash.engine.EngineFactory;
import jgnash.engine.QuoteSource;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.net.security.SecurityUpdateFactory;
import jgnash.ui.components.CheckListCellRenderer;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.SortedListModel;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.ToggleSelectionModel;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class YahooSecurityHistoryImportDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private final DatePanel startField = new DatePanel();
    private final DatePanel endField = new DatePanel();
    private final JButton okButton = new JButton(this.rb.getString("Button.Ok"));
    private final JButton cancelButton = new JButton(this.rb.getString("Button.Cancel"));
    private final JProgressBar bar = new JProgressBar();
    private final JList securityList = new JList();
    private final Calendar cal = Calendar.getInstance();
    private ImportRun run;

    public YahooSecurityHistoryImportDialog() {
        this.setTitle(this.rb.getString("Title.HistoryImport"));
        this.setDefaultCloseOperation(2);
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.cal.setTime(new Date());
        this.cal.add(2, -1);
        this.startField.setDate(this.cal.getTime());
        List<SecurityNode> list = EngineFactory.getEngine("default").getSecurities();
        Iterator<SecurityNode> i = list.iterator();
        while (i.hasNext()) {
            if (i.next().getQuoteSource() != QuoteSource.NONE) continue;
            i.remove();
        }
        this.securityList.setModel(new SortedListModel<SecurityNode>(list));
        this.securityList.setSelectionModel(new ToggleSelectionModel());
        this.securityList.setCellRenderer(new CheckListCellRenderer(this.securityList.getCellRenderer()));
        this.layoutMainPanel();
        this.setMinimumSize(this.getSize());
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        DialogUtils.addBoundsListener(this);
    }

    void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("r:p, $lcgap, 48dlu:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        JScrollPane scrollPane = new JScrollPane(this.securityList);
        scrollPane.setAutoscrolls(true);
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startField);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endField);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow("f:p:g");
        builder.append(this.rb.getString("Label.Security"), (Component)scrollPane);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.bar, 3);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add(builder.getPanel());
        this.pack();
    }

    private void doImport() {
        this.bar.setIndeterminate(true);
        this.okButton.setEnabled(false);
        Date start = this.startField.getDate();
        Date end = this.endField.getDate();
        int[] list = this.securityList.getSelectedIndices();
        SecurityNode[] nodes = new SecurityNode[list.length];
        for (int i = 0; i < list.length; ++i) {
            nodes[i] = (SecurityNode)this.securityList.getModel().getElementAt(list[i]);
        }
        this.run = new ImportRun(start, end, nodes);
        new Thread(this.run).start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.doImport();
        } else if (e.getSource() == this.cancelButton) {
            if (this.run != null) {
                this.run.stop();
            }
            this.closeDialog();
        }
    }

    private class ImportRun
    implements Runnable {
        private volatile Object lock = new Object();
        private Date start;
        private Date end;
        private final SecurityNode[] sNodes;
        private String a;
        private String b;
        private String c;
        private String d;
        private String e;
        private String f;

        protected ImportRun(Date start, Date end, SecurityNode[] sNodes) {
            this.start = start;
            this.end = end;
            this.sNodes = sNodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parse(SecurityNode sNode) {
            String s = sNode.getSymbol().toLowerCase();
            StringBuilder r = new StringBuilder("http://ichart.finance.yahoo.com/table.csv?a=");
            r.append(this.a).append("&b=").append(this.b).append("&c=").append(this.c);
            r.append("&d=").append(this.d).append("&e=").append(this.e);
            r.append("&f=").append(this.f).append("&s=").append(s);
            r.append("&y=0&g=d&ignore=.csv");
            URLConnection connection = null;
            BufferedReader in = null;
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                connection = new URL(r.toString()).openConnection();
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                String l = in.readLine();
                if (!l.equals("Date,Open,High,Low,Close,Volume,Adj Close")) {
                    in.close();
                    YahooSecurityHistoryImportDialog.this.closeDialog();
                    return;
                }
                l = in.readLine();
                while (l != null && this.lock != null) {
                    if (!l.startsWith("<")) {
                        String[] fields = l.split(",");
                        Date date = df.parse(fields[0]);
                        BigDecimal high = new BigDecimal(fields[2]);
                        BigDecimal low = new BigDecimal(fields[3]);
                        BigDecimal close = new BigDecimal(fields[4]);
                        long volume = Long.parseLong(fields[5]);
                        SecurityHistoryNode node = new SecurityHistoryNode();
                        node.setDate(date);
                        node.setPrice(close);
                        node.setVolume(volume);
                        node.setHigh(high);
                        node.setLow(low);
                        EngineFactory.getEngine("default").addSecurityHistory(sNode, node);
                    }
                    l = in.readLine();
                }
                if (connection instanceof HttpURLConnection) {
                    ((HttpURLConnection)connection).disconnect();
                }
                String message = MessageFormat.format(YahooSecurityHistoryImportDialog.this.rb.getString("Message.UpdatedPrice"), sNode.getSymbol());
                Logger.getLogger(SecurityUpdateFactory.class.getName()).info(message);
            }
            catch (Exception ex) {
                Logger.getLogger(YahooSecurityHistoryImportDialog.class.getName()).severe(ex.getLocalizedMessage());
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                        if (connection != null && connection instanceof HttpURLConnection) {
                            ((HttpURLConnection)connection).disconnect();
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(YahooSecurityHistoryImportDialog.class.getName()).severe(ex.getLocalizedMessage());
                        ex.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void run() {
            if (!DateUtils.before(this.start, this.end)) {
                Date t = this.start;
                this.start = this.end;
                this.end = t;
            }
            YahooSecurityHistoryImportDialog.this.cal.setTime(this.start);
            this.a = Integer.toString(YahooSecurityHistoryImportDialog.this.cal.get(2));
            this.b = Integer.toString(YahooSecurityHistoryImportDialog.this.cal.get(5));
            this.c = Integer.toString(YahooSecurityHistoryImportDialog.this.cal.get(1));
            YahooSecurityHistoryImportDialog.this.cal.setTime(this.end);
            this.d = Integer.toString(YahooSecurityHistoryImportDialog.this.cal.get(2));
            this.e = Integer.toString(YahooSecurityHistoryImportDialog.this.cal.get(5));
            this.f = Integer.toString(YahooSecurityHistoryImportDialog.this.cal.get(1));
            for (SecurityNode node : this.sNodes) {
                if (this.lock == null) continue;
                this.parse(node);
            }
            YahooSecurityHistoryImportDialog.this.closeDialog();
        }

        protected void stop() {
            this.lock = null;
        }
    }
}

