/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jgnash.ui.ThemeManager;
import jgnash.ui.components.DateSelectDialog;
import jgnash.ui.components.JDateField;
import jgnash.util.Resource;

public class DatePanel
extends JPanel
implements ActionListener {
    private JDateField dateField = new JDateField();
    private JButton button = new JButton(Resource.getIcon("/jgnash/resource/office-calendar.png"));

    public DatePanel() {
        this.button.setMargin(new Insets(1, 1, 1, 1));
        this.button.addActionListener(this);
        if (ThemeManager.isLookAndFeelNimbus()) {
            ThemeManager.reduceNimbusButtonMargin(this.button);
        }
        FormLayout layout = new FormLayout("max(40dlu;pref):g, 1px, min", "f:d:g");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.append((Component)this.dateField, (Component)this.button);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button) {
            Window parent = SwingUtilities.windowForComponent(this);
            this.setDate(DateSelectDialog.showDialog(parent, this.getDate()));
        }
    }

    public Date getDate() {
        return (Date)this.dateField.getValue();
    }

    public void setDate(Date date) {
        this.dateField.setValue(date);
    }

    public JDateField getDateField() {
        return this.dateField;
    }

    public JButton getButton() {
        return this.button;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.dateField.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    public void setEditable(boolean editable) {
        this.dateField.setEditable(editable);
        this.button.setEnabled(editable);
    }
}

