/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

public class SortedComboBoxModel<E extends Comparable<? super E>>
extends AbstractListModel
implements MutableComboBoxModel {
    private static final long serialVersionUID = 4137642143757238233L;
    private Object selectedObject;
    private List<E> list = new ArrayList();

    public SortedComboBoxModel() {
    }

    public SortedComboBoxModel(Collection<E> items) {
        this.list = new ArrayList<E>(items);
        Collections.sort(this.list);
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public void clear() {
        int size = this.list.size();
        this.list.clear();
        this.fireIntervalRemoved(this, 0, size - 1);
    }

    public void addAll(Collection<E> items) {
        this.list.addAll(items);
        Collections.sort(this.list);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public Object getElementAt(int index) {
        if (index >= 0 && index < this.list.size()) {
            return this.list.get(index);
        }
        return null;
    }

    int getIndexOf(Object anObject) {
        return this.list.indexOf(anObject);
    }

    public void updateElement(Object anObject) {
        int index = this.getIndexOf(anObject);
        if (index >= 0) {
            this.fireContentsChanged(this, index, index);
        }
    }

    private int add(E anObject) {
        if (anObject != null) {
            this.list.add(anObject);
            Collections.sort(this.list);
            return this.list.indexOf(anObject);
        }
        return -1;
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.list.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.list.indexOf(anObject);
        if (index >= 0) {
            this.list.remove(anObject);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public void removeAllElements() {
        if (!this.list.isEmpty()) {
            int firstIndex = 0;
            int lastIndex = this.list.size() - 1;
            this.list.clear();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        }
    }

    public void addElement(Object obj) {
        int index = this.add((Comparable)obj);
        this.fireIntervalAdded(this, index, index);
        if (this.list.size() == 1 && this.selectedObject == null && obj != null) {
            this.setSelectedItem(obj);
        }
    }

    public void insertElementAt(Object obj, int index) {
        this.list.add((Comparable)obj);
        Collections.sort(this.list);
        this.fireContentsChanged(this, 0, this.list.size() - 1);
    }
}

