/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.ui.UIApplication;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.register.TransactionPanel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class TransactionDialog
extends JDialog
implements RegisterListener {
    private final Resource rb = Resource.get();
    private Account account;
    private JTabbedPane tabbedPane;
    private TransactionPanelEx debitPanel;
    private TransactionPanelEx creditPanel;
    private Transaction transaction = null;

    public static Transaction showDialog(Account account, Transaction t) {
        TransactionDialog d = new TransactionDialog(account);
        if (t != null) {
            d.setTransaction(t);
        }
        d.setVisible(true);
        return d.getTransaction();
    }

    private TransactionDialog(Account account) {
        super((Frame)((Object)UIApplication.getFrame()), true);
        this.setTitle(this.rb.getString("Title.NewTrans"));
        this.setDefaultCloseOperation(2);
        this.account = account;
        this.tabbedPane = new JTabbedPane();
        this.buildTabbedPane();
        this.layoutMainPanel();
        this.setLocationRelativeTo((Component)((Object)UIApplication.getFrame()));
        DialogUtils.addBoundsListener(this);
    }

    private void closeDialog() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private Transaction getTransaction() {
        return this.transaction;
    }

    private void setTransaction(Transaction tran) {
        Engine engine = EngineFactory.getEngine("default");
        if (!engine.isStored(tran)) {
            if (tran.getAmount(this.account).signum() >= 0) {
                this.tabbedPane.setSelectedComponent(this.creditPanel);
                this.creditPanel.modifyTransaction(tran);
            } else {
                this.tabbedPane.setSelectedComponent(this.debitPanel);
                this.debitPanel.modifyTransaction(tran);
            }
        }
    }

    private void buildTabbedPane() {
        if (this.tabbedPane.getComponentCount() > 0) {
            if (this.debitPanel != null && this.creditPanel != null) {
                this.debitPanel.removeRegisterListener(this);
                this.creditPanel.removeRegisterListener(this);
            }
            this.tabbedPane.removeAll();
        }
        this.debitPanel = new TransactionPanelEx(this.account, PanelType.DECREASE);
        this.creditPanel = new TransactionPanelEx(this.account, PanelType.INCREASE);
        this.debitPanel.addRegisterListener(this);
        this.creditPanel.addRegisterListener(this);
        String[] tabNames = RegisterFactory.getCreditDebitTabNames(this.account);
        this.tabbedPane.add(tabNames[0], this.creditPanel);
        this.tabbedPane.add(tabNames[1], this.debitPanel);
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, 4dlu, f:d:g", "f:d, 3dlu, f:d, 8dlu, f:d");
        CellConstraints cc = new CellConstraints();
        JPanel p = new JPanel((LayoutManager)layout);
        p.add((Component)new JLabel(this.rb.getString("Label.BaseAccount")), cc.xy(1, 1));
        p.add((Component)new JLabel(this.account.getPathName()), cc.xy(3, 1));
        p.add((Component)this.tabbedPane, cc.xyw(1, 3, 3));
        p.setBorder(Borders.DIALOG_BORDER);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)p, "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    @Override
    public void registerEvent(RegisterEvent e) {
        if (e.getAction() == RegisterEvent.Action.CANCEL) {
            this.transaction = null;
            this.closeDialog();
        } else if (e.getAction() == RegisterEvent.Action.OK) {
            this.transaction = ((TransactionPanelEx)this.tabbedPane.getSelectedComponent()).getTransaction();
            this.closeDialog();
        }
    }

    private static class TransactionPanelEx
    extends TransactionPanel {
        private Transaction t = null;

        protected TransactionPanelEx(Account account, PanelType panelType) {
            super(account, panelType);
        }

        Transaction getTransaction() {
            return this.t;
        }

        @Override
        public void enterAction() {
            if (this.validateForm()) {
                this.t = this.buildTransaction();
                this.fireOkAction();
            } else {
                this.t = null;
            }
        }
    }
}

