/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.DatePanel;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.table.ClippingModel;
import jgnash.ui.register.table.FilterModel;
import jgnash.ui.register.table.FullCommodityRenderer;
import jgnash.ui.register.table.QuantityRenderer;
import jgnash.ui.register.table.RegisterModel;
import jgnash.ui.register.table.ShortCommodityRenderer;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JasperPrint;

public class AccountRegisterReport
extends DynamicJasperReport {
    private AccountListComboBox accountCombo = new AccountListComboBox();
    private JButton refreshButton;
    private DatePanel startDateField;
    private DatePanel endDateField;
    private JCheckBox detailSplitsCheckBox;
    private static final String SHOW_DETAILS = "showDetails";
    private JCheckBox filterCheckBox;
    private static final String FILTERTAG = "filter:";
    private TextField txtFilter;
    private int startIndex;
    private int endIndex;

    public AccountRegisterReport(Account account) {
        if (account != null) {
            this.accountCombo.setSelectedAccount(account);
        }
        Account a = this.accountCombo.getSelectedAccount();
        this.refreshButton = new JButton(this.rb.getString("Button.Refresh"));
        this.refreshButton.setIcon(Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.startDateField = new DatePanel();
        if (a.getTransactionCount() > 0) {
            this.startDateField.setDate(a.getTransactionAt(0).getDate());
        }
        this.endDateField = new DatePanel();
        this.filterCheckBox = new JCheckBox(this.rb.getString("Button.Filter"));
        this.filterCheckBox.setSelected(this.getPreferences().getBoolean(FILTERTAG, false));
        this.filterCheckBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountRegisterReport.this.startDateField.setEnabled(!AccountRegisterReport.this.filterCheckBox.isSelected());
                AccountRegisterReport.this.endDateField.setEnabled(!AccountRegisterReport.this.filterCheckBox.isSelected());
                AccountRegisterReport.this.txtFilter.setEnabled(AccountRegisterReport.this.filterCheckBox.isSelected());
            }
        });
        this.txtFilter = new TextField(40);
        this.txtFilter.setEnabled(false);
        this.detailSplitsCheckBox = new JCheckBox(this.rb.getString("Button.DetailSplits"));
        this.detailSplitsCheckBox.setSelected(this.getPreferences().getBoolean(SHOW_DETAILS, false));
        this.detailSplitsCheckBox.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountRegisterReport.this.getPreferences().putBoolean(AccountRegisterReport.SHOW_DETAILS, AccountRegisterReport.this.detailSplitsCheckBox.isSelected());
            }
        });
        this.refreshButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AccountRegisterReport.this.refreshReport();
            }
        });
    }

    public AccountRegisterReport(Account account, int startIndex, int endIndex) {
        this(account);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        try {
            this.startDateField.setDate(account.getTransactionAt(startIndex).getDate());
            this.endDateField.setDate(account.getTransactionAt(endIndex).getDate());
        }
        catch (Exception ignored) {
            // empty catch block
        }
    }

    @Override
    public JasperPrint createJasperPrint(boolean formatForCSV) {
        this.logger.info(this.rb.getString("Message.CollectingReportData"));
        if (this.filterCheckBox.isSelected()) {
            FilterModel model = RegisterFactory.getFilterTableModel(this.accountCombo.getSelectedAccount(), this.detailSplitsCheckBox.isSelected());
            model.setReconcileSymbol("C");
            model.setFilter(this.txtFilter.getText());
            String hideColName = model.getColumnName(model.getColumnCount() - 1);
            model.setColumnVisible(hideColName, false);
            return this.createJasperPrint(new ReportTableModel(model, true), formatForCSV);
        }
        ClippingModel model = RegisterFactory.getClippingTableModel(this.accountCombo.getSelectedAccount(), this.detailSplitsCheckBox.isSelected());
        model.setReconcileSymbol("C");
        if (this.endIndex > 0) {
            model.setStartIndex(this.startIndex);
            model.setEndIndex(this.endIndex);
            this.endIndex = 0;
            this.startIndex = 0;
        } else {
            model.setStartDate(this.startDateField.getDate());
            model.setEndDate(this.endDateField.getDate());
        }
        return this.createJasperPrint(new ReportTableModel(model, false), formatForCSV);
    }

    @Override
    public JPanel getReportController() {
        FormLayout layout = new FormLayout("p, $lcgap, p:g, 8dlu, p, 8dlu, p", "f:d, $lgap, f:d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.rb.getString("Label.Account"), (Component)this.accountCombo);
        builder.append((Component)this.refreshButton, 3);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.createDatePanel(), 5);
        builder.append((Component)this.detailSplitsCheckBox);
        builder.nextLine();
        builder.append((Component)this.createFilterPanel(), 3);
        layout.addGroupedRow(1);
        layout.addGroupedRow(3);
        layout.addGroupedRow(5);
        return builder.getPanel();
    }

    private JPanel createDatePanel() {
        FormLayout layout = new FormLayout("p, $lcgap, max(48dlu;min), 8dlu, p, $lcgap, max(48dlu;min)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startDateField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endDateField);
        return builder.getPanel();
    }

    private JPanel createFilterPanel() {
        FormLayout layout = new FormLayout("p, $lcgap, p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.filterCheckBox, (Component)this.txtFilter);
        return builder.getPanel();
    }

    @Override
    public String getReportName() {
        return this.accountCombo.getSelectedAccount().getName();
    }

    @Override
    public String getGrandTotalLegend() {
        return null;
    }

    @Override
    public String getGroupFooterLabel() {
        return this.rb.getString("Word.Totals");
    }

    private class ReportTableModel
    extends AbstractReportTableModel {
        private RegisterModel model;
        private static final long serialVersionUID = 1L;
        private boolean sumAmounts;

        protected ReportTableModel(RegisterModel model, boolean sumAmounts) {
            this.model = model;
            this.sumAmounts = sumAmounts;
        }

        @Override
        public CurrencyNode getCurrency() {
            return AccountRegisterReport.this.accountCombo.getSelectedAccount().getCurrencyNode();
        }

        @Override
        public boolean isColumnFixedWidth(int columnIndex) {
            return this.model.getPreferredColumnWeights()[columnIndex] == 0;
        }

        @Override
        public ColumnStyle getColumnStyle(int columnIndex) {
            if (this.sumAmounts && columnIndex == this.model.getColumnCount()) {
                return ColumnStyle.GROUP_NO_HEADER;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(Date.class)) {
                return ColumnStyle.SHORT_DATE;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(FullCommodityRenderer.class)) {
                return ColumnStyle.BALANCE;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(ShortCommodityRenderer.class)) {
                if (this.sumAmounts) {
                    return ColumnStyle.AMOUNT_SUM;
                }
                return ColumnStyle.SHORT_AMOUNT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(QuantityRenderer.class)) {
                return ColumnStyle.QUANTITY;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(String.class)) {
                return ColumnStyle.STRING;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(BigDecimal.class)) {
                return ColumnStyle.SHORT_AMOUNT;
            }
            return ColumnStyle.STRING;
        }

        @Override
        public ColumnHeaderStyle getColumnHeaderStyle(int columnIndex) {
            if (this.sumAmounts && columnIndex == this.model.getColumnCount()) {
                return ColumnHeaderStyle.LEFT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(Date.class)) {
                return ColumnHeaderStyle.LEFT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(ShortCommodityRenderer.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(FullCommodityRenderer.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(QuantityRenderer.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(String.class)) {
                return ColumnHeaderStyle.LEFT;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(BigDecimal.class)) {
                return ColumnHeaderStyle.RIGHT;
            }
            return ColumnHeaderStyle.LEFT;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (this.sumAmounts && columnIndex == this.model.getColumnCount()) {
                return "group";
            }
            return this.model.getColumnName(columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.sumAmounts && columnIndex == this.model.getColumnCount()) {
                return String.class;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(ShortCommodityRenderer.class)) {
                return BigDecimal.class;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(FullCommodityRenderer.class)) {
                return BigDecimal.class;
            }
            if (this.model.getColumnClass(columnIndex).isAssignableFrom(QuantityRenderer.class)) {
                return BigDecimal.class;
            }
            return this.model.getColumnClass(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            if (this.sumAmounts) {
                return this.model.getColumnCount() + 1;
            }
            return this.model.getColumnCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.sumAmounts && columnIndex == this.model.getColumnCount()) {
                return "group";
            }
            return this.model.getValueAt(rowIndex, columnIndex);
        }
    }
}

