/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.imports.qif;

import java.util.Date;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import jgnash.engine.Account;
import jgnash.imports.qif.QifAccount;
import jgnash.imports.qif.QifTransaction;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.DateTableCellRenderer;
import jgnash.util.Resource;

class PartialTable
extends JTable {
    private Resource rb = Resource.get();
    private QifAccount qAccount;
    private Model model;
    private TableCellEditor accEditor = new DefaultCellEditor(new AccountListComboBox());

    public PartialTable(QifAccount qAccount) {
        this.qAccount = qAccount;
        this.model = new Model();
        this.setModel(this.model);
        this.setDefaultRenderer(Date.class, new DateTableCellRenderer());
    }

    public void deleteSelected() {
        int row = this.getSelectedRow();
        this.qAccount.items.remove(row);
        this.model.fireTableRowsDeleted(row, row);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 2) {
            return this.accEditor;
        }
        return super.getCellEditor(row, column);
    }

    public void fireTableDataChanged() {
        this.model.fireTableDataChanged();
    }

    class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 7054758354758853979L;
        private String[] cNames;
        private Class<?>[] cClass;

        Model() {
            this.cNames = new String[]{PartialTable.this.rb.getString("Column.Date"), PartialTable.this.rb.getString("Column.Payee"), PartialTable.this.rb.getString("Column.Account"), PartialTable.this.rb.getString("Column.Amount")};
            this.cClass = new Class[]{Date.class, String.class, String.class, Object.class};
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.cClass[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return PartialTable.this.qAccount.numItems();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            QifTransaction qt = PartialTable.this.qAccount.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return qt.date;
                }
                case 1: {
                    return qt.payee;
                }
                case 2: {
                    return qt.category;
                }
                case 3: {
                    return qt.amount;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 2 && value != null) {
                QifTransaction qt = PartialTable.this.qAccount.get(rowIndex);
                qt.category = ((Account)value).getPathName();
                qt._category = (Account)value;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }
}

