/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.builders;

import ar.com.fdvs.dj.domain.ColumnOperation;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.ColumnBuilderException;
import ar.com.fdvs.dj.domain.constants.ImageScaleMode;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.BarCodeColumn;
import ar.com.fdvs.dj.domain.entities.columns.ExpressionColumn;
import ar.com.fdvs.dj.domain.entities.columns.ImageColumn;
import ar.com.fdvs.dj.domain.entities.columns.OperationColumn;
import ar.com.fdvs.dj.domain.entities.columns.PercentageColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import ar.com.fdvs.dj.domain.entities.columns.SimpleColumn;
import ar.com.fdvs.dj.domain.entities.conditionalStyle.ConditionalStyle;
import ar.com.fdvs.dj.util.PropertiesMap;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class ColumnBuilder {
    public static final int COLUMN_TYPE_DEFAULT = 0;
    public static final int COLUMN_TYPE_IMAGE = 1;
    public static final int COLUMN_TYPE_BARCODE = 2;
    private String title;
    private Integer width = new Integer(50);
    private Boolean fixedWidth = Boolean.FALSE;
    private Style style;
    private Style headerStyle;
    private ColumnProperty columnProperty;
    private CustomExpression customExpression;
    private CustomExpression customExpressionForCalculation;
    private CustomExpression customExpressionToGroupBy;
    private String pattern;
    private boolean printRepeatedValues = true;
    private ArrayList conditionalStyles = new ArrayList();
    private ColumnOperation operation;
    private List operationColumns = new ArrayList();
    private PropertiesMap fieldProperties = new PropertiesMap();
    private ImageScaleMode imageScaleMode = ImageScaleMode.FILL_PROPORTIONALLY;
    private String fieldDescription;
    private String truncateSuffix;
    private Format textFormatter;
    private PropertyColumn percentageColumn;
    private int columnType = 0;
    private static Random random = new Random();
    private int barcodeType;
    private String applicationIdentifier;
    private boolean showText = false;
    private boolean checkSum = false;

    public static ColumnBuilder getInstance() {
        return ColumnBuilder.getNew();
    }

    public static ColumnBuilder getNew() {
        return new ColumnBuilder();
    }

    public AbstractColumn build() throws ColumnBuilderException {
        if (this.customExpression == null && this.columnProperty == null && this.operationColumns.isEmpty() && this.percentageColumn == null) {
            throw new ColumnBuilderException("Either a ColumnProperty or a CustomExpression or a PercentageColumn must be present");
        }
        AbstractColumn col = null;
        col = this.columnType == 1 ? this.buildSimpleImageColumn() : (this.columnType == 2 ? this.buildSimpleBarcodeColumn() : (this.percentageColumn != null ? this.buildPercentageColumn() : (this.columnProperty != null && this.customExpression == null ? this.buildSimpleColumn() : (!this.operationColumns.isEmpty() ? this.buildOperationColumn() : this.buildExpressionColumn()))));
        return col;
    }

    protected AbstractColumn buildSimpleBarcodeColumn() {
        BarCodeColumn column = new BarCodeColumn();
        this.populateCommonAttributes(column);
        column.setColumnProperty(this.columnProperty);
        column.setExpressionToGroupBy(this.customExpressionToGroupBy);
        column.setScaleMode(this.imageScaleMode);
        column.setApplicationIdentifier(this.applicationIdentifier);
        column.setBarcodeType(this.barcodeType);
        column.setShowText(this.showText);
        column.setCheckSum(this.checkSum);
        return column;
    }

    protected AbstractColumn buildSimpleImageColumn() {
        ImageColumn column = new ImageColumn();
        this.populateCommonAttributes(column);
        column.setColumnProperty(this.columnProperty);
        column.setExpressionToGroupBy(this.customExpressionToGroupBy);
        column.setScaleMode(this.imageScaleMode);
        return column;
    }

    protected AbstractColumn buildExpressionColumn() {
        ExpressionColumn column = new ExpressionColumn();
        this.populateCommonAttributes(column);
        if (this.columnProperty != null) {
            this.columnProperty.getFieldProperties().putAll(this.fieldProperties);
            column.setColumnProperty(this.columnProperty);
            column.setExpressionToGroupBy(this.customExpressionToGroupBy);
            column.setFieldDescription(this.fieldDescription);
        } else {
            long random_ = Math.abs(random.nextLong());
            column.setColumnProperty(new ColumnProperty("__name_to_be_replaced_in_registration_manager_" + random_, CustomExpression.class.getName()));
        }
        column.setExpression(this.customExpression);
        column.setExpressionToGroupBy(this.customExpressionToGroupBy);
        column.setExpressionForCalculation(this.customExpressionForCalculation);
        return column;
    }

    protected AbstractColumn buildPercentageColumn() {
        PercentageColumn column = new PercentageColumn();
        this.populateCommonAttributes(column);
        column.setPercentageColumn(this.percentageColumn);
        if (this.pattern == null) {
            column.setPattern("#,##0.00%");
        }
        return column;
    }

    protected AbstractColumn buildSimpleColumn() {
        SimpleColumn column = new SimpleColumn();
        this.populateCommonAttributes(column);
        this.columnProperty.getFieldProperties().putAll(this.fieldProperties);
        column.setColumnProperty(this.columnProperty);
        column.setExpressionToGroupBy(this.customExpressionToGroupBy);
        column.setFieldDescription(this.fieldDescription);
        return column;
    }

    protected AbstractColumn buildOperationColumn() {
        OperationColumn column = new OperationColumn();
        this.populateCommonAttributes(column);
        column.setColumnOperation(this.operation);
        column.setColumns(this.operationColumns);
        return column;
    }

    protected void populateCommonAttributes(AbstractColumn column) {
        column.setTitle(this.title);
        column.setWidth(this.width);
        column.setPattern(this.pattern);
        column.setHeaderStyle(this.headerStyle);
        column.setStyle(this.style);
        column.setPrintRepeatedValues(this.printRepeatedValues);
        column.getConditionalStyles().addAll(this.conditionalStyles);
        column.setFixedWidth(this.fixedWidth);
        column.setTruncateSuffix(this.truncateSuffix);
        column.setTextFormatter(this.textFormatter);
    }

    public ColumnBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public ColumnBuilder setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public ColumnBuilder setPrintRepeatedValues(boolean bool) {
        this.printRepeatedValues = bool;
        return this;
    }

    public ColumnBuilder setPrintRepeatedValues(Boolean bool) {
        this.printRepeatedValues = bool;
        return this;
    }

    public ColumnBuilder setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public ColumnBuilder setWidth(int width) {
        this.width = new Integer(width);
        return this;
    }

    public ColumnBuilder setStyle(Style style) {
        this.style = style;
        return this;
    }

    public ColumnBuilder setHeaderStyle(Style style) {
        this.headerStyle = style;
        return this;
    }

    public ColumnBuilder setColumnProperty(ColumnProperty columnProperty) {
        this.columnProperty = columnProperty;
        return this;
    }

    public ColumnBuilder setColumnProperty(String propertyName, String valueClassName) {
        ColumnProperty columnProperty;
        this.columnProperty = columnProperty = new ColumnProperty(propertyName, valueClassName);
        return this;
    }

    public ColumnBuilder setFieldDescription(String fieldDescription) {
        this.fieldDescription = fieldDescription;
        return this;
    }

    public ColumnBuilder setColumnProperty(String propertyName, String valueClassName, String fieldDescription) {
        ColumnProperty columnProperty;
        this.columnProperty = columnProperty = new ColumnProperty(propertyName, valueClassName);
        this.fieldDescription = fieldDescription;
        return this;
    }

    public ColumnBuilder addFieldProperty(String propertyName, String value) {
        this.fieldProperties.put(propertyName, value);
        return this;
    }

    public ColumnBuilder setCustomExpression(CustomExpression customExpression) {
        this.customExpression = customExpression;
        return this;
    }

    public ColumnBuilder setCustomExpressionToGroupBy(CustomExpression customExpression) {
        this.customExpressionToGroupBy = customExpression;
        return this;
    }

    public ColumnBuilder setCustomExpressionForCalculation(CustomExpression customExpression) {
        this.customExpressionForCalculation = customExpression;
        return this;
    }

    public ColumnBuilder addConditionalStyle(ConditionalStyle conditionalStyle) {
        this.conditionalStyles.add(conditionalStyle);
        return this;
    }

    public ColumnBuilder addConditionalStyles(Collection conditionalStyles) {
        this.conditionalStyles.addAll(conditionalStyles);
        return this;
    }

    public ColumnBuilder addColumnOperation(ColumnOperation operation, AbstractColumn[] operationColumns) {
        this.operation = operation;
        this.operationColumns = new ArrayList();
        for (int i = 0; i < operationColumns.length; ++i) {
            this.operationColumns.add(operationColumns[i]);
        }
        return this;
    }

    public ColumnBuilder setFixedWidth(boolean bool) {
        this.fixedWidth = bool;
        return this;
    }

    public ColumnBuilder setFixedWidth(Boolean bool) {
        this.fixedWidth = bool;
        return this;
    }

    public ColumnBuilder setColumnType(int columnType) {
        this.columnType = columnType;
        return this;
    }

    public ColumnBuilder setImageScaleMode(ImageScaleMode imageScaleMode) {
        this.imageScaleMode = imageScaleMode;
        return this;
    }

    public ColumnBuilder setCommonProperties(String title, String property, String className, int width, boolean fixedWidth) {
        this.setColumnProperty(new ColumnProperty(property, className));
        this.setWidth(new Integer(width));
        this.setTitle(title);
        this.setFixedWidth((Boolean)fixedWidth);
        return this;
    }

    public ColumnBuilder setCommonProperties(String title, String property, Class clazz, int width, boolean fixedWidth) {
        this.setColumnProperty(new ColumnProperty(property, clazz));
        this.setWidth(new Integer(width));
        this.setTitle(title);
        this.setFixedWidth((Boolean)fixedWidth);
        return this;
    }

    public ColumnBuilder setBarcodeType(int barcodeType) {
        this.barcodeType = barcodeType;
        return this;
    }

    public ColumnBuilder setShowText(boolean showText) {
        this.showText = showText;
        return this;
    }

    public ColumnBuilder setCheckSum(boolean checkSum) {
        this.checkSum = checkSum;
        return this;
    }

    public ColumnBuilder setApplicationIdentifier(String applicationIdentifier) {
        this.applicationIdentifier = applicationIdentifier;
        return this;
    }

    public ColumnBuilder setTruncateSuffix(String suffix) {
        this.truncateSuffix = suffix;
        return this;
    }

    public ColumnBuilder setTextFormatter(Format textFormatter) {
        this.textFormatter = textFormatter;
        return this;
    }

    public ColumnBuilder setPercentageColumn(PropertyColumn percentageColumn) {
        this.percentageColumn = percentageColumn;
        return this;
    }

    public ColumnBuilder setPercentageColumn(PropertyColumn percentageColumn, DJGroup group) {
        return this.setPercentageColumn(percentageColumn);
    }
}

