/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.core.DJDefaultScriptlet;
import ar.com.fdvs.dj.domain.ColumnProperty;
import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.DJCalculation;
import ar.com.fdvs.dj.domain.DJDataSource;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.entities.Subreport;
import ar.com.fdvs.dj.domain.entities.SubreportParameter;
import ar.com.fdvs.dj.util.LayoutUtils;
import ar.com.fdvs.dj.util.PropertiesMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRResultSetDataSource;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ExpressionUtils {
    private static final String REPORT_PARAMETERS_MAP = "$P{REPORT_PARAMETERS_MAP}";

    public static JRDesignExpression getParameterExpression(Subreport sr) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName(Map.class.getName());
        if (sr.isUseParentReportParameters()) {
            exp.setText(REPORT_PARAMETERS_MAP);
            return exp;
        }
        if (sr.getParametersExpression() == null) {
            return null;
        }
        if (sr.getParametersMapOrigin() == 0) {
            exp.setText("$P{REPORT_PARAMETERS_MAP}.get( \"" + sr.getParametersExpression() + "\" )");
            return exp;
        }
        if (sr.getParametersMapOrigin() == 1) {
            exp.setText("$F{" + sr.getParametersExpression() + "}");
            return exp;
        }
        return null;
    }

    public static JRDesignExpression getDataSourceExpression(DJDataSource ds) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(JRDataSource.class);
        String dsType = ExpressionUtils.getDataSourceTypeStr(ds.getDataSourceType());
        String expText = null;
        if (ds.getDataSourceOrigin() == 1) {
            expText = dsType + "$F{" + ds.getDataSourceExpression() + "})";
        } else if (ds.getDataSourceOrigin() == 0) {
            expText = dsType + REPORT_PARAMETERS_MAP + ".get( \"" + ds.getDataSourceExpression() + "\" ) )";
        } else if (ds.getDataSourceOrigin() == 100) {
            expText = dsType + REPORT_PARAMETERS_MAP + ".get( \"" + ds.getDataSourceExpression() + "\" ) )";
        } else if (ds.getDataSourceOrigin() == 2) {
            expText = "((" + JRDataSource.class.getName() + ")" + REPORT_PARAMETERS_MAP + ".get( \"REPORT_DATA_SOURCE\" ) )";
        }
        exp.setText(expText);
        return exp;
    }

    public static JRDesignExpression getConnectionExpression(DJDataSource ds) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(Connection.class);
        String dsType = ExpressionUtils.getDataSourceTypeStr(ds.getDataSourceType());
        String expText = dsType + REPORT_PARAMETERS_MAP + ".get( \"" + ds.getDataSourceExpression() + "\" ) )";
        exp.setText(expText);
        return exp;
    }

    public static JRDesignExpression getReportConnectionExpression() {
        JRDesignExpression connectionExpression = new JRDesignExpression();
        connectionExpression.setText("$P{REPORT_CONNECTION}");
        connectionExpression.setValueClass(Connection.class);
        return connectionExpression;
    }

    protected static String getDataSourceTypeStr(int datasourceType) {
        String dsType = "(";
        if (0 == datasourceType) {
            dsType = "new " + JRBeanCollectionDataSource.class.getName() + "((java.util.Collection)";
        } else if (1 == datasourceType) {
            dsType = "new " + JRBeanArrayDataSource.class.getName() + "((Object[])";
        } else if (3 == datasourceType) {
            dsType = "new " + JRResultSetDataSource.class.getName() + "((" + ResultSet.class.getName() + ")";
        } else if (10 == datasourceType) {
            dsType = "((" + JRDataSource.class.getName() + ")";
        } else if (100 == datasourceType) {
            dsType = "((" + Connection.class.getName() + ")";
        }
        return dsType;
    }

    public static JRDesignExpression createStringExpression(String text) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(String.class);
        exp.setText(text);
        return exp;
    }

    public static JRDesignExpression createExpression(String text, Class clazz) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(clazz);
        exp.setText(text);
        return exp;
    }

    public static JRDesignExpression createExpression(String text, String className) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName(className);
        exp.setText(text);
        return exp;
    }

    public static JRDesignExpression createExpression(JasperDesign jasperDesign, SubreportParameter sp) {
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClassName(sp.getClassName());
        String text = null;
        if (sp.getParameterOrigin() == 1) {
            text = "$F{" + sp.getExpression() + "}";
            if (sp.getClassName() == null) {
                JRDesignField jrField = (JRDesignField)jasperDesign.getFieldsMap().get(sp.getExpression());
                if (jrField != null) {
                    exp.setValueClass(jrField.getValueClass());
                } else {
                    exp.setValueClass(Object.class);
                }
            }
        } else {
            text = sp.getParameterOrigin() == 2 ? "$P{REPORT_PARAMETERS_MAP}.get( \"" + sp.getExpression() + "\")" : (sp.getParameterOrigin() == 3 ? "$V{" + sp.getExpression() + "}" : sp.getExpression());
        }
        exp.setText(text);
        return exp;
    }

    public static JRDesignExpression createAndRegisterExpression(DynamicJasperDesign design, String name, CustomExpression expression) {
        LayoutUtils.registerCustomExpressionParameter(design, name, expression);
        return ExpressionUtils.createExpression(name, expression);
    }

    public static JRDesignExpression createExpression(String name, CustomExpression expression) {
        String text = ExpressionUtils.createCustomExpressionInvocationText(name);
        return ExpressionUtils.createExpression(text, expression.getClassName());
    }

    public static String getFieldsMapExpression(Collection columnsAndFields) {
        StringBuffer fieldsMap = new StringBuffer("new  " + PropertiesMap.class.getName() + "()");
        Iterator iter = columnsAndFields.iterator();
        while (iter.hasNext()) {
            ColumnProperty columnProperty = (ColumnProperty)iter.next();
            if (columnProperty == null) continue;
            String propname = columnProperty.getProperty();
            fieldsMap.append(".with(\"" + propname + "\",$F{" + propname + "})");
        }
        return fieldsMap.toString();
    }

    public static String getVariablesMapExpression(Collection variables) {
        StringBuffer variablesMap = new StringBuffer("new  " + PropertiesMap.class.getName() + "()");
        Iterator iter = variables.iterator();
        while (iter.hasNext()) {
            JRVariable jrvar = (JRVariable)iter.next();
            String varname = jrvar.getName();
            variablesMap.append(".with(\"" + varname + "\",$V{" + varname + "})");
        }
        return variablesMap.toString();
    }

    public static String getParametersMapExpression() {
        return "new  " + PropertiesMap.class.getName() + "($P{" + "REPORT_PARAMETERS_MAP" + "} )";
    }

    public static String createParameterName(String preffix, Object obj) {
        String name = obj.toString().substring(obj.toString().lastIndexOf(".") + 1).replaceAll("[\\$@]", "_");
        return preffix + name;
    }

    public static String createCustomExpressionInvocationText(String customExpName) {
        String fieldsMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentFiels()";
        String parametersMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentParams()";
        String variablesMap = "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_SCRIPTLET}).getCurrentVariables()";
        String stringExpression = "((" + CustomExpression.class.getName() + ")$P{REPORT_PARAMETERS_MAP}.get(\"" + customExpName + "\"))." + "evaluate" + "( " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " )";
        return stringExpression;
    }

    public static String createCustomExpressionInvocationText2(String customExpName) {
        String fieldsMap = ExpressionUtils.getTextForFieldsFromScriptlet();
        String parametersMap = ExpressionUtils.getTextForParametersFromScriptlet();
        String variablesMap = ExpressionUtils.getTextForVariablesFromScriptlet();
        String stringExpression = "((" + CustomExpression.class.getName() + ")$P{REPORT_PARAMETERS_MAP}.get(\"" + customExpName + "\"))." + "evaluate" + "( " + fieldsMap + ", " + variablesMap + ", " + parametersMap + " )";
        return stringExpression;
    }

    public static String getTextForVariablesFromScriptlet() {
        return "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_PARAMETERS_MAP}.get(\"REPORT_SCRIPTLET\")).getCurrentVariables()";
    }

    public static String getTextForParametersFromScriptlet() {
        return "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_PARAMETERS_MAP}.get(\"REPORT_SCRIPTLET\")).getCurrentParams()";
    }

    public static String getTextForFieldsFromScriptlet() {
        return "((" + DJDefaultScriptlet.class.getName() + ")$P{REPORT_PARAMETERS_MAP}.get(\"REPORT_SCRIPTLET\")).getCurrentFiels()";
    }

    public static String getValueClassNameForOperation(DJCalculation calc, ColumnProperty prop) {
        if (calc == DJCalculation.COUNT || calc == DJCalculation.DISTINCT_COUNT) {
            return Long.class.getName();
        }
        return prop.getValueClassName();
    }

    public static String getInitialValueExpressionForOperation(DJCalculation calc, ColumnProperty prop) {
        if (calc == DJCalculation.COUNT || calc == DJCalculation.DISTINCT_COUNT) {
            return "new java.lang.Long(\"0\")";
        }
        if (calc == DJCalculation.SUM) {
            return "new " + prop.getValueClassName() + "(\"0\")";
        }
        return null;
    }
}

