/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.decorate;

import EDU.purdue.cs.bloat.context.BloatContext;
import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.ClassHierarchy;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFile;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.reflect.ClassInfo;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.trans.CompactArrayInitializer;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class Main
implements Opcode {
    private static int VERBOSE = 0;
    private static boolean FORCE = false;
    private static boolean CLOSURE = false;
    private static boolean RC = true;
    private static boolean UC = true;
    private static boolean SC = true;
    private static final List SKIP = new ArrayList();
    private static final List ONLY = new ArrayList();
    private static final int NONE = 0;
    private static final int POINTER = 1;
    private static final int SCALAR = 2;

    public static void main(String[] args) {
        ClassFileLoader loader = new ClassFileLoader();
        ArrayList<String> classes = new ArrayList<String>();
        boolean gotdir = false;
        int i = 0;
        while (i < args.length) {
            String pkg;
            if (args[i].equals("-v") || args[i].equals("-verbose")) {
                ++VERBOSE;
            } else if (args[i].equals("-help")) {
                Main.usage();
            } else if (args[i].equals("-classpath")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                String classpath = args[i];
                loader.setClassPath(classpath);
            } else if (args[i].equals("-skip")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                pkg = args[i].replace('.', '/');
                SKIP.add(pkg);
            } else if (args[i].equals("-only")) {
                if (++i >= args.length) {
                    Main.usage();
                }
                pkg = args[i].replace('.', '/');
                ONLY.add(pkg);
            } else if (args[i].equals("-closure")) {
                CLOSURE = true;
            } else if (args[i].equals("-relax-loading")) {
                ClassHierarchy.RELAX = true;
            } else if (args[i].equals("-f")) {
                FORCE = true;
            } else if (args[i].equals("-norc")) {
                RC = false;
            } else if (args[i].equals("-rc")) {
                RC = true;
            } else if (args[i].equals("-nouc")) {
                UC = false;
            } else if (args[i].equals("-uc")) {
                UC = true;
            } else if (args[i].equals("-nosc")) {
                SC = false;
            } else if (args[i].equals("-sc")) {
                SC = true;
            } else if (args[i].startsWith("-")) {
                Main.usage();
            } else if (i == args.length - 1) {
                File f = new File(args[i]);
                if (f.exists() && !f.isDirectory()) {
                    System.err.println("No such directory: " + f.getPath());
                    System.exit(2);
                }
                loader.setOutputDir(f);
                gotdir = true;
            } else {
                classes.add(args[i]);
            }
            ++i;
        }
        if (!gotdir) {
            Main.usage();
        }
        if (classes.size() == 0) {
            Main.usage();
        }
        if (VERBOSE > 3) {
            ClassFileLoader.DEBUG = true;
            ClassEditor.DEBUG = true;
        }
        boolean errors = false;
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            try {
                loader.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Couldn't find class: " + ex.getMessage());
                errors = true;
            }
        }
        if (errors) {
            System.exit(1);
        }
        CachingBloatContext context = new CachingBloatContext(loader, classes, CLOSURE);
        if (!CLOSURE) {
            Iterator e = classes.iterator();
            while (e.hasNext()) {
                String name = (String)e.next();
                try {
                    ClassInfo info = loader.loadClass(name);
                    Main.decorateClass(context, info);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    System.exit(1);
                }
            }
        } else {
            classes = null;
            ClassHierarchy hier = ((BloatContext)context).getHierarchy();
            Iterator e = hier.classes().iterator();
            while (e.hasNext()) {
                Type t = (Type)e.next();
                if (!t.isObject()) continue;
                try {
                    ClassInfo info = loader.loadClass(t.className());
                    Main.decorateClass(context, info);
                }
                catch (ClassNotFoundException ex) {
                    System.err.println("Couldn't find class: " + ex.getMessage());
                    System.exit(1);
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java EDU.purdue.cs.bloat.decorate.Main \n            [-options] classes output_dir\n\nwhere options include:\n    -help             print out this message\n    -v -verbose       turn on verbose mode (can be given multiple times)\n    -classpath <directories separated by colons>\n                      list directories in which to look for classes\n    -f                decorate files even if up-to-date\n    -closure          recursively decorate referenced classes\n    -relax-loading    don't report errors if a class is not found\n    -skip <class|package.*>\n                      skip the given class or package\n                      (this option can be given more than once)\n    -only <class|package.*>\n                      skip all but the given class or package\n                      (this option can be given more than once)\n    -rc               insert residency checks (default)\n    -norc             don't insert residency checks\n    -uc               insert update checks (default)\n    -sc               insert array swizzle checks (default)\n    -nosc             don't insert array swizzle checks");
        System.exit(0);
    }

    private static void decorateClass(EditorContext context, ClassInfo info) {
        String pkg;
        int i;
        ClassFile classFile = (ClassFile)info;
        if (!FORCE) {
            File source = classFile.file();
            File target = classFile.outputFile();
            if (source != null && target != null && source.exists() && target.exists() && source.lastModified() < target.lastModified()) {
                if (VERBOSE > 1) {
                    System.out.println(String.valueOf(classFile.name()) + " is up to date");
                }
                return;
            }
        }
        if (VERBOSE > 2) {
            classFile.print(System.out);
        }
        ClassEditor c = context.editClass(info);
        boolean skip = false;
        String name = c.type().className();
        String qual = String.valueOf(c.type().qualifier()) + "/*";
        if (ONLY.size() > 0) {
            skip = true;
            i = 0;
            while (i < ONLY.size()) {
                pkg = (String)ONLY.get(i);
                if (name.equals(pkg) || qual.equals(pkg)) {
                    skip = false;
                    break;
                }
                ++i;
            }
        }
        if (!skip) {
            i = 0;
            while (i < SKIP.size()) {
                pkg = (String)SKIP.get(i);
                if (name.equals(pkg) || qual.equals(pkg)) {
                    skip = true;
                    break;
                }
                ++i;
            }
        }
        if (skip) {
            if (VERBOSE > 0) {
                System.out.println("Skipping " + c.type().className());
            }
            context.release(info);
            return;
        }
        if (VERBOSE > 0) {
            System.out.println("Decorating class " + c.type().className());
        }
        if (VERBOSE > 2) {
            ((ClassFile)info).print(System.out);
        }
        MethodInfo[] methods = c.methods();
        int j = 0;
        while (j < methods.length) {
            block17: {
                MethodEditor m;
                try {
                    m = context.editMethod(methods[j]);
                }
                catch (ClassFormatException ex) {
                    System.err.println(ex.getMessage());
                    break block17;
                }
                Main.transform(m);
                context.commit(methods[j]);
            }
            ++j;
        }
        context.commit(info);
    }

    private static void transform(MethodEditor method) {
        if (VERBOSE > 1) {
            System.out.println("Decorating method " + method);
        }
        CompactArrayInitializer.transform(method);
        ListIterator<Instruction> iter = method.code().listIterator();
        block12: while (iter.hasNext()) {
            Instruction addInst;
            Object t;
            int depth;
            Object ce = iter.next();
            if (VERBOSE > 2) {
                System.out.println("Examining " + ce);
            }
            if (!(ce instanceof Instruction)) continue;
            Instruction inst = (Instruction)ce;
            int uctype = 0;
            boolean insert_sc = false;
            int opc = inst.opcodeClass();
            switch (opc) {
                case 180: 
                case 190: 
                case 191: 
                case 193: {
                    depth = 0;
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 51: 
                case 52: 
                case 53: {
                    depth = 1;
                    break;
                }
                case 50: {
                    depth = 1;
                    insert_sc = true;
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    depth = 2;
                    break;
                }
                case 80: 
                case 82: {
                    depth = 3;
                    break;
                }
                case 181: {
                    MemberRef ref = (MemberRef)inst.operand();
                    depth = ref.type().stackHeight();
                    if (ref.type().isReference()) {
                        uctype = 1;
                        break;
                    }
                    uctype = 2;
                    break;
                }
                case 182: 
                case 183: 
                case 185: {
                    MemberRef ref = (MemberRef)inst.operand();
                    depth = ref.type().stackHeight();
                    break;
                }
                case 237: {
                    iter.remove();
                    continue block12;
                }
                case 238: {
                    iter.remove();
                    continue block12;
                }
                case 239: {
                    iter.remove();
                    continue block12;
                }
                default: {
                    continue block12;
                }
            }
            if (RC) {
                t = iter.previous();
                Assert.isTrue(t == inst, t + " != " + inst);
                addInst = new Instruction(237, new Integer(depth));
                iter.add(addInst);
                t = iter.previous();
                Assert.isTrue(t == addInst, t + " != " + addInst);
                t = iter.next();
                Assert.isTrue(t == addInst, t + " != " + addInst);
                t = iter.next();
                Assert.isTrue(t == inst, t + " != " + inst);
                if (VERBOSE > 2) {
                    System.out.println("Inserting " + addInst + " before " + inst);
                }
            } else if (VERBOSE > 2) {
                System.out.println("Not inserting rc before " + inst);
            }
            if (insert_sc) {
                if (SC) {
                    t = iter.previous();
                    Assert.isTrue(t == inst, t + " != " + inst);
                    addInst = new Instruction(92);
                    iter.add(addInst);
                    t = iter.previous();
                    Assert.isTrue(t == addInst, t + " != " + addInst);
                    t = iter.next();
                    Assert.isTrue(t == addInst, t + " != " + addInst);
                    addInst = new Instruction(240);
                    iter.add(addInst);
                    t = iter.previous();
                    Assert.isTrue(t == addInst, t + " != " + addInst);
                    t = iter.next();
                    Assert.isTrue(t == addInst, t + " != " + addInst);
                    t = iter.next();
                    Assert.isTrue(t == inst, t + " != " + inst);
                    if (VERBOSE > 2) {
                        System.out.println("Inserting dup2,aswizzle before " + inst);
                    }
                } else if (VERBOSE > 2) {
                    System.out.println("Not inserting aswizzle before " + inst);
                }
            }
            if (uctype == 0) continue;
            if (UC) {
                t = iter.previous();
                Assert.isTrue(t == inst, t + " != " + inst);
                addInst = new Instruction(238, new Integer(depth));
                iter.add(addInst);
                t = iter.previous();
                Assert.isTrue(t == addInst, t + " != " + addInst);
                t = iter.next();
                Assert.isTrue(t == addInst, t + " != " + addInst);
                t = iter.next();
                Assert.isTrue(t == inst, t + " != " + inst);
                if (VERBOSE <= 2) continue;
                System.out.println("Inserting " + addInst + " before " + inst);
                continue;
            }
            if (VERBOSE <= 2) continue;
            System.out.println("Not inserting uc before " + inst);
        }
    }
}

