/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.inline;

import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.InstructionAdapter;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.MultiArrayOperand;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.TryCatch;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class InstructionStack
extends InstructionAdapter {
    MethodEditor method;
    HashMap stacks;
    LinkedList currStack;
    HashMap preexists;
    HashMap currPreexists;

    private static void pre(String s) {
    }

    public InstructionStack(MethodEditor method) {
        this.method = method;
        this.stacks = new HashMap();
        this.preexists = new HashMap();
        Type[] paramTypes = method.paramTypes();
        this.currPreexists = new HashMap();
        int i = 0;
        while (i < paramTypes.length) {
            if (paramTypes[i] != null && paramTypes[i].isObject()) {
                this.currPreexists.put(method.paramAt(i), new HashSet());
            }
            ++i;
        }
    }

    public void handle(Label label) {
        LinkedList stack = (LinkedList)this.stacks.get(label);
        if (stack == null) {
            Iterator tryCatches = this.method.tryCatches().iterator();
            while (tryCatches.hasNext()) {
                TryCatch tc = (TryCatch)tryCatches.next();
                if (!tc.handler().equals(label)) continue;
                Instruction aload = new Instruction(18, "Exception");
                this.currStack = new LinkedList();
                aload.visit(this);
                this.stacks.put(label, stack);
                label.setStartsBlock(true);
                this.currPreexists = new HashMap();
                return;
            }
            if (this.currStack == null) {
                this.currStack = new LinkedList();
                this.stacks.put(label, this.currStack);
            } else {
                this.currStack = (LinkedList)this.currStack.clone();
                this.stacks.put(label, this.currStack);
                this.currPreexists = InstructionStack.clonePreexists(this.currPreexists);
                this.preexists.put(label, this.currPreexists);
            }
        } else {
            this.currStack = InstructionStack.merge(this.currStack, stack);
            this.stacks.put(label, this.currStack);
            HashMap oldPreexists = (HashMap)this.preexists.get(label);
            this.currPreexists = InstructionStack.merge(oldPreexists, this.currPreexists);
            this.preexists.put(label, this.currPreexists);
        }
    }

    public void handle(Instruction inst) {
        inst.visit(this);
        if (inst.isJump()) {
            Label target = (Label)inst.operand();
            target.setStartsBlock(true);
            LinkedList targetStack = (LinkedList)this.stacks.get(target);
            if (targetStack != null) {
                this.stacks.put(target, InstructionStack.merge(this.currStack, targetStack));
                HashMap oldPreexists = (HashMap)this.preexists.get(target);
                this.preexists.put(target, InstructionStack.merge(this.currPreexists, oldPreexists));
            } else {
                this.stacks.put(target, this.currStack.clone());
                this.preexists.put(target, InstructionStack.clonePreexists(this.currPreexists));
            }
            if (!inst.isConditionalJump()) {
                this.currStack = new LinkedList();
            }
        } else if (inst.isSwitch()) {
            Switch sw = (Switch)inst.operand();
            Label defaultTarget = sw.defaultTarget();
            defaultTarget.setStartsBlock(true);
            LinkedList defaultStack = (LinkedList)this.stacks.get(defaultTarget);
            if (defaultStack != null) {
                Assert.isTrue(defaultStack.size() == this.currStack.size(), "Stack height mismatch (" + defaultStack.size() + " != " + this.currStack.size() + ") at " + inst);
                this.stacks.put(defaultTarget, InstructionStack.merge(this.currStack, defaultStack));
                HashMap defaultPreexists = (HashMap)this.preexists.get(defaultTarget);
                this.preexists.put(defaultTarget, InstructionStack.merge(this.currPreexists, defaultPreexists));
            } else {
                this.stacks.put(defaultTarget, this.currStack.clone());
                this.preexists.put(defaultTarget, InstructionStack.clonePreexists(this.currPreexists));
            }
            Label[] targets = sw.targets();
            int t = 0;
            while (t < targets.length) {
                Label target = targets[t];
                target.setStartsBlock(true);
                LinkedList targetStack = (LinkedList)this.stacks.get(target);
                if (targetStack != null) {
                    Assert.isTrue(targetStack.size() == this.currStack.size(), "Stack height mismatch (" + targetStack.size() + " != " + this.currStack.size() + ") at " + inst);
                    this.stacks.put(target, InstructionStack.merge(this.currStack, targetStack));
                    HashMap oldPreexists = (HashMap)this.preexists.get(target);
                    this.preexists.put(target, InstructionStack.merge(oldPreexists, this.currPreexists));
                } else {
                    this.stacks.put(target, this.currStack.clone());
                    this.preexists.put(target, InstructionStack.clonePreexists(this.currPreexists));
                }
                ++t;
            }
        } else if (inst.isJsr()) {
            LinkedList subStack = new LinkedList();
            LinkedList oldStack = this.currStack;
            this.currStack = subStack;
            inst.visit(this);
            this.currStack = oldStack;
            Label subroutine = (Label)inst.operand();
            subroutine.setStartsBlock(true);
            this.stacks.put(subroutine, subStack);
            this.preexists.put(subroutine, new HashMap());
        } else if (inst.isReturn() || inst.isThrow()) {
            this.currStack = new LinkedList();
        }
    }

    private void push(Instruction inst) {
        HashSet<Instruction> set = new HashSet<Instruction>();
        set.add(inst);
        this.currStack.add(set);
    }

    private void pop() {
        this.currStack.removeLast();
    }

    private void pop(int n) {
        int i = 0;
        while (i < n) {
            this.currStack.removeLast();
            ++i;
        }
    }

    public int height() {
        return this.currStack.size();
    }

    public Set atDepth(int n) {
        Set set = (Set)this.currStack.get(this.currStack.size() - 1 - n);
        return set;
    }

    public HashSet preexistsAtDepth(int n) {
        InstructionStack.pre("  Preexisting variables: " + InstructionStack.db(this.currPreexists));
        HashSet<Type> atDepth = null;
        Iterator insts = this.atDepth(n).iterator();
        Assert.isTrue(insts.hasNext(), "No instructions at depth " + n);
        while (insts.hasNext()) {
            Instruction inst = (Instruction)insts.next();
            InstructionStack.pre("    Instruction at " + n + ": " + inst);
            if (inst.opcodeClass() == 25) {
                LocalVariable var = (LocalVariable)inst.operand();
                Set set = (Set)this.currPreexists.get(var);
                if (set != null) {
                    if (set.isEmpty()) {
                        atDepth = new HashSet<Type>();
                        continue;
                    }
                    if (atDepth == null) {
                        atDepth = new HashSet();
                    }
                    atDepth.addAll(set);
                    continue;
                }
            } else {
                HashSet set;
                if (inst.opcodeClass() == 187) {
                    if (atDepth != null && atDepth.isEmpty()) continue;
                    Type type = (Type)inst.operand();
                    InstructionStack.pre("      Constructing " + Type.truncatedName(type));
                    if (atDepth == null) {
                        atDepth = new HashSet();
                    }
                    atDepth.add(type);
                    continue;
                }
                if (inst.opcodeClass() == 89 && (set = this.preexistsAtDepth(n - 1)) != null) {
                    if (set.isEmpty()) {
                        atDepth = new HashSet();
                        continue;
                    }
                    atDepth.addAll(set);
                    continue;
                }
            }
            InstructionStack.pre("  Doesn't preexist");
            return null;
        }
        InstructionStack.pre("  Preexists");
        return atDepth;
    }

    private static LinkedList merge(LinkedList stack1, LinkedList stack2) {
        Assert.isFalse(stack1 == null && stack2 == null, "Cannot merge two null stacks");
        LinkedList merge = new LinkedList();
        if (stack1 == null || stack1.size() == 0) {
            merge.addAll(stack2);
            return merge;
        }
        if (stack2 == null || stack2.size() == 0) {
            merge.addAll(stack1);
            return merge;
        }
        Assert.isTrue(stack1.size() == stack2.size(), "Stacks of unequal height cannot be merged (" + stack1.size() + " != " + stack2.size() + ")");
        int i = 0;
        while (i < stack1.size()) {
            HashSet mergeSet = new HashSet();
            mergeSet.addAll((Set)stack1.get(i));
            mergeSet.addAll((Set)stack2.get(i));
            merge.add(i, mergeSet);
            ++i;
        }
        return merge;
    }

    private static HashMap merge(HashMap one, HashMap two) {
        Assert.isFalse(one == null && two == null, "Can't merge null preexists");
        if (one == null) {
            return InstructionStack.clonePreexists(two);
        }
        if (two == null) {
            return InstructionStack.clonePreexists(one);
        }
        HashMap result = new HashMap();
        HashSet allVars = new HashSet();
        allVars.addAll(one.keySet());
        allVars.addAll(two.keySet());
        Iterator iter = allVars.iterator();
        while (iter.hasNext()) {
            HashSet set;
            LocalVariable var = (LocalVariable)iter.next();
            if (!one.containsKey(var)) {
                set = (HashSet)two.get(var);
                if (set != null) {
                    set = (HashSet)set.clone();
                }
                result.put(var, set);
                continue;
            }
            if (!two.containsKey(var)) {
                set = (HashSet)one.get(var);
                if (set != null) {
                    set = (HashSet)set.clone();
                }
                result.put(var, set);
                continue;
            }
            HashSet oneSet = (HashSet)one.get(var);
            HashSet twoSet = (HashSet)two.get(var);
            if (oneSet == null || twoSet == null) {
                result.put(var, null);
                continue;
            }
            if (oneSet.isEmpty() || twoSet.isEmpty()) {
                result.put(var, new HashSet());
                continue;
            }
            HashSet set2 = new HashSet();
            set2.addAll(oneSet);
            set2.addAll(twoSet);
            result.put(var, set2);
        }
        InstructionStack.pre("Merge of " + InstructionStack.db(one) + " and " + InstructionStack.db(two) + " is " + InstructionStack.db(result));
        return result;
    }

    static String db(HashMap preexists) {
        if (preexists == null) {
            return "\n  null?\n";
        }
        StringBuffer sb = new StringBuffer("\n");
        Iterator vars = preexists.keySet().iterator();
        while (vars.hasNext()) {
            LocalVariable var = (LocalVariable)vars.next();
            Set set = (Set)preexists.get(var);
            if (set == null) {
                sb.append("  " + var + ": null\n");
                continue;
            }
            sb.append("  " + var + ": ");
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                Type type = (Type)iter.next();
                sb.append(Type.truncatedName(type));
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private static HashMap clonePreexists(HashMap old) {
        HashMap<LocalVariable, Object> clone = new HashMap<LocalVariable, Object>();
        Iterator vars = old.keySet().iterator();
        while (vars.hasNext()) {
            LocalVariable var = (LocalVariable)vars.next();
            HashSet set = (HashSet)old.get(var);
            if (set == null) {
                clone.put(var, null);
                continue;
            }
            clone.put(var, set.clone());
        }
        return clone;
    }

    public void visit_nop(Instruction inst) {
    }

    public void visit_ldc(Instruction inst) {
        this.push(inst);
    }

    public void visit_iload(Instruction inst) {
        this.push(inst);
    }

    public void visit_lload(Instruction inst) {
        this.push(inst);
    }

    public void visit_fload(Instruction inst) {
        this.push(inst);
    }

    public void visit_dload(Instruction inst) {
        this.push(inst);
    }

    public void visit_aload(Instruction inst) {
        this.push(inst);
    }

    public void visit_iaload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_laload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_faload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_daload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_aaload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_baload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_caload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_saload(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_istore(Instruction inst) {
        this.pop();
    }

    public void visit_lstore(Instruction inst) {
        this.pop();
    }

    public void visit_fstore(Instruction inst) {
        this.pop();
    }

    public void visit_dstore(Instruction inst) {
        this.pop();
    }

    public void visit_astore(Instruction inst) {
        LocalVariable var = (LocalVariable)inst.operand();
        HashSet set = this.preexistsAtDepth(0);
        if (set == null) {
            InstructionStack.pre("      " + var + " does not preexist");
            this.currPreexists.put(var, null);
        } else if (set.isEmpty()) {
            InstructionStack.pre("      " + var + " preexists");
            this.currPreexists.put(var, new HashSet());
        } else {
            InstructionStack.pre("      " + var + " preexists with types");
            this.currPreexists.put(var, set.clone());
        }
        this.pop();
    }

    public void visit_iastore(Instruction inst) {
        this.pop(3);
    }

    public void visit_lastore(Instruction inst) {
        this.pop(3);
    }

    public void visit_fastore(Instruction inst) {
        this.pop(3);
    }

    public void visit_dastore(Instruction inst) {
        this.pop(3);
    }

    public void visit_aastore(Instruction inst) {
        this.pop(3);
    }

    public void visit_bastore(Instruction inst) {
        this.pop(3);
    }

    public void visit_castore(Instruction inst) {
        this.pop(3);
    }

    public void visit_sastore(Instruction inst) {
        this.pop(3);
    }

    private void checkCategory(Set insts, int category) {
        Iterator iter = insts.iterator();
        while (iter.hasNext()) {
            Instruction inst = (Instruction)iter.next();
            Assert.isTrue(inst.category() == category, "Category mismatch: " + inst.category() + " != " + category);
        }
    }

    private int checkCategory(Set insts) {
        int category = 0;
        Iterator iter = insts.iterator();
        while (iter.hasNext()) {
            Instruction inst = (Instruction)iter.next();
            if (category == 0) {
                category = inst.category();
                continue;
            }
            Assert.isTrue(inst.category() == category, "Category mismatch in instruction set");
        }
        Assert.isTrue(category != 0, "No instructions in set");
        return category;
    }

    public void visit_pop(Instruction inst) {
        Set insts = this.atDepth(0);
        this.checkCategory(insts, 1);
        this.pop();
    }

    public void visit_pop2(Instruction inst) {
        Set top1 = (Set)this.currStack.removeLast();
        int category = this.checkCategory(top1);
        if (category == 1) {
            Set top2 = (Set)this.currStack.removeLast();
            this.checkCategory(top2, 1);
        }
    }

    public void visit_dup(Instruction inst) {
        Set dup = this.atDepth(0);
        this.checkCategory(dup, 1);
        this.currStack.add(new HashSet(dup));
    }

    public void visit_dup_x1(Instruction inst) {
        Set dup = this.atDepth(0);
        this.checkCategory(dup, 1);
        this.currStack.add(this.currStack.size() - 2, new HashSet(dup));
    }

    public void visit_dup_x2(Instruction inst) {
        Set top1 = this.atDepth(0);
        this.checkCategory(top1, 1);
        Set top2 = this.atDepth(1);
        int category = this.checkCategory(top2);
        if (category == 1) {
            Set top3 = this.atDepth(2);
            this.checkCategory(top3, 1);
            this.currStack.add(this.currStack.size() - 3, new HashSet(top1));
        } else {
            this.currStack.add(this.currStack.size() - 2, new HashSet(top1));
        }
    }

    public void visit_dup2(Instruction inst) {
        Set top = this.atDepth(0);
        int category = this.checkCategory(top);
        if (category == 1) {
            Set top1 = this.atDepth(1);
            this.checkCategory(top1, 1);
            this.currStack.add(new HashSet(top1));
            this.currStack.add(new HashSet(top));
        } else {
            this.currStack.add(new HashSet(top));
        }
    }

    public void visit_dup2_x1(Instruction inst) {
        Set top = this.atDepth(0);
        int category = this.checkCategory(top);
        if (category == 1) {
            Set top1 = this.atDepth(1);
            this.checkCategory(top1, 1);
            int n = this.currStack.size() - 3;
            this.currStack.add(n, top1);
            this.currStack.add(n, top);
        } else {
            Set top1 = this.atDepth(1);
            this.checkCategory(top1, 1);
            this.currStack.add(this.currStack.size() - 2, new HashSet(top));
        }
    }

    public void visit_dup2_x2(Instruction inst) {
        Set top = this.atDepth(0);
        int category = this.checkCategory(top);
        if (category == 1) {
            Set top1 = this.atDepth(1);
            int category1 = this.checkCategory(top1);
            if (category1 == 1) {
                Set top2 = this.atDepth(2);
                int category2 = this.checkCategory(top2);
                if (category2 == 1) {
                    this.checkCategory(this.atDepth(3), 1);
                    int n = this.currStack.size() - 4;
                    this.currStack.add(n, new HashSet(top1));
                    this.currStack.add(n, new HashSet(top));
                } else {
                    int n = this.currStack.size() - 3;
                    this.currStack.add(n, new HashSet(top1));
                    this.currStack.add(n, new HashSet(top));
                }
            } else {
                Assert.isTrue(false, "Impossible stack combination for dup2_x1: ... 2 1");
            }
        } else {
            Set top1 = this.atDepth(1);
            int category1 = this.checkCategory(top1);
            if (category1 == 1) {
                int category2 = this.checkCategory(this.atDepth(2));
                if (category2 == 1) {
                    this.currStack.add(this.currStack.size() - 3, new HashSet(top));
                } else {
                    Assert.isTrue(false, "Impossible stack combination for dup2_x1: ... 2 1 2");
                }
            } else {
                this.currStack.add(this.currStack.size() - 2, new HashSet(top));
            }
        }
    }

    public void visit_swap(Instruction inst) {
        Set top = (Set)this.currStack.removeLast();
        Set next = (Set)this.currStack.removeLast();
        this.checkCategory(top, 1);
        this.checkCategory(next, 1);
        this.currStack.add(top);
        this.currStack.add(next);
    }

    public void visit_iadd(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ladd(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_fadd(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_dadd(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_isub(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lsub(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_fsub(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_dsub(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_imul(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lmul(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_fmul(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_dmul(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_idiv(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ldiv(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_fdiv(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ddiv(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_irem(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lrem(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_frem(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_drem(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ineg(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_lneg(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_fneg(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_dneg(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_ishl(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lshl(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ishr(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lshr(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_iushr(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lushr(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_iand(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_land(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ior(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lor(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ixor(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_lxor(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_iinc(Instruction inst) {
    }

    public void visit_i2l(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_i2f(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_i2d(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_l2i(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_l2f(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_l2d(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_f2i(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_f2l(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_f2d(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_d2i(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_d2l(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_d2f(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_i2b(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_i2c(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_i2s(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_lcmp(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_fcmpl(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_fcmpg(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_dcmpl(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_dcmpg(Instruction inst) {
        this.pop(2);
        this.push(inst);
    }

    public void visit_ifeq(Instruction inst) {
        this.pop();
    }

    public void visit_ifne(Instruction inst) {
        this.pop();
    }

    public void visit_iflt(Instruction inst) {
        this.pop();
    }

    public void visit_ifge(Instruction inst) {
        this.pop();
    }

    public void visit_ifgt(Instruction inst) {
        this.pop();
    }

    public void visit_ifle(Instruction inst) {
        this.pop();
    }

    public void visit_if_icmpeq(Instruction inst) {
        this.pop(2);
    }

    public void visit_if_icmpne(Instruction inst) {
        this.pop(2);
    }

    public void visit_if_icmplt(Instruction inst) {
        this.pop(2);
    }

    public void visit_if_icmpge(Instruction inst) {
        this.pop(2);
    }

    public void visit_if_icmpgt(Instruction inst) {
        this.pop(2);
    }

    public void visit_if_icmple(Instruction inst) {
        this.pop(2);
    }

    public void visit_if_acmpeq(Instruction inst) {
        this.pop(2);
    }

    public void visit_if_acmpne(Instruction inst) {
        this.pop(2);
    }

    public void visit_goto(Instruction inst) {
    }

    public void visit_jsr(Instruction inst) {
        this.push(inst);
    }

    public void visit_ret(Instruction inst) {
    }

    public void visit_switch(Instruction inst) {
        this.pop();
    }

    public void visit_ireturn(Instruction inst) {
    }

    public void visit_lreturn(Instruction inst) {
    }

    public void visit_freturn(Instruction inst) {
    }

    public void visit_dreturn(Instruction inst) {
    }

    public void visit_areturn(Instruction inst) {
    }

    public void visit_return(Instruction inst) {
    }

    public void visit_getstatic(Instruction inst) {
        this.push(inst);
    }

    public void visit_putstatic(Instruction inst) {
        this.pop();
    }

    public void visit_putstatic_nowb(Instruction inst) {
        this.pop();
    }

    public void visit_getfield(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_putfield(Instruction inst) {
        this.pop(2);
    }

    public void visit_putfield_nowb(Instruction inst) {
        this.pop(2);
    }

    public void visit_invokevirtual(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.pop(type.paramTypes().length);
        this.pop();
        if (type.returnType() != Type.VOID) {
            this.push(inst);
        }
    }

    public void visit_invokespecial(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.pop(type.paramTypes().length);
        this.pop();
        if (type.returnType() != Type.VOID) {
            this.push(inst);
        }
    }

    public void visit_invokestatic(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.pop(type.paramTypes().length);
        if (type.returnType() != Type.VOID) {
            this.push(inst);
        }
    }

    public void visit_invokeinterface(Instruction inst) {
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        this.pop(type.paramTypes().length);
        this.pop();
        if (type.returnType() != Type.VOID) {
            this.push(inst);
        }
    }

    public void visit_new(Instruction inst) {
        this.push(inst);
    }

    public void visit_newarray(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_arraylength(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_athrow(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_checkcast(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_instanceof(Instruction inst) {
        this.pop();
        this.push(inst);
    }

    public void visit_monitorenter(Instruction inst) {
        this.pop();
    }

    public void visit_monitorexit(Instruction inst) {
        this.pop();
    }

    public void visit_multianewarray(Instruction inst) {
        MultiArrayOperand operand = (MultiArrayOperand)inst.operand();
        int dim = operand.dimensions();
        this.pop(dim);
        this.push(inst);
    }

    public void visit_ifnull(Instruction inst) {
        this.pop();
    }

    public void visit_ifnonnull(Instruction inst) {
        this.pop();
    }

    public void visit_rc(Instruction inst) {
    }

    public void visit_aupdate(Instruction inst) {
    }

    public void visit_supdate(Instruction inst) {
    }

    public void visit_aswizzle(Instruction inst) {
    }

    public void visit_aswrange(Instruction inst) {
    }
}

