/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class XmlFriendlyReplacer {
    private String dollarReplacement;
    private String underscoreReplacement;
    private transient Map escapeCache;
    private transient Map unescapeCache;

    public XmlFriendlyReplacer() {
        this("_-", "__");
    }

    public XmlFriendlyReplacer(String dollarReplacement, String underscoreReplacement) {
        this.dollarReplacement = dollarReplacement;
        this.underscoreReplacement = underscoreReplacement;
        this.escapeCache = new WeakHashMap();
        this.unescapeCache = new WeakHashMap();
    }

    public String escapeName(String name) {
        WeakReference ref = (WeakReference)this.escapeCache.get(name);
        String s = ref == null ? null : ref.get();
        if (s == null) {
            char c;
            int i;
            int length = name.length();
            for (i = 0; i < length && (c = name.charAt(i)) != '$' && c != '_'; ++i) {
            }
            if (i == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i > 0) {
                result.append(name.substring(0, i));
            }
            while (i < length) {
                char c2 = name.charAt(i);
                if (c2 == '$') {
                    result.append(this.dollarReplacement);
                } else if (c2 == '_') {
                    result.append(this.underscoreReplacement);
                } else {
                    result.append(c2);
                }
                ++i;
            }
            s = result.toString();
            this.escapeCache.put(name, new WeakReference<String>(s));
        }
        return s;
    }

    public String unescapeName(String name) {
        WeakReference ref = (WeakReference)this.unescapeCache.get(name);
        String s = ref == null ? null : ref.get();
        if (s == null) {
            char c;
            int i;
            char dollarReplacementFirstChar = this.dollarReplacement.charAt(0);
            char underscoreReplacementFirstChar = this.underscoreReplacement.charAt(0);
            int length = name.length();
            for (i = 0; i < length && (c = name.charAt(i)) != dollarReplacementFirstChar && c != underscoreReplacementFirstChar; ++i) {
            }
            if (i == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i > 0) {
                result.append(name.substring(0, i));
            }
            while (i < length) {
                char c2 = name.charAt(i);
                if (c2 == dollarReplacementFirstChar && name.startsWith(this.dollarReplacement, i)) {
                    i += this.dollarReplacement.length() - 1;
                    result.append('$');
                } else if (c2 == underscoreReplacementFirstChar && name.startsWith(this.underscoreReplacement, i)) {
                    i += this.underscoreReplacement.length() - 1;
                    result.append('_');
                } else {
                    result.append(c2);
                }
                ++i;
            }
            s = result.toString();
            this.unescapeCache.put(name, new WeakReference<String>(s));
        }
        return s;
    }

    private Object readResolve() {
        this.escapeCache = new WeakHashMap();
        this.unescapeCache = new WeakHashMap();
        return this;
    }
}

