/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.collections.facades;

import com.db4o.collections.facades.CachedObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class FastListCache {
    private transient List _list;

    public FastListCache(int n) {
        this._list = new ArrayList(n);
        for (int i = 0; i < this._list.size(); ++i) {
            this._list.set(i, CachedObject.NONE);
        }
    }

    public void add(Object object) {
        this._list.add(new CachedObject(object));
    }

    public void add(int n, Object object) {
        this._list.add(n, new CachedObject(object));
    }

    public void addAll(Collection collection) {
        this._list.addAll(this.toCachedObjectCollection(collection));
    }

    public void addAll(int n, Collection collection) {
        this._list.addAll(n, this.toCachedObjectCollection(collection));
    }

    public void clear() {
        this._list.clear();
    }

    public boolean contains(Object object) {
        return this._list.contains(new CachedObject(object));
    }

    public int indexOf(Object object) {
        return this._list.indexOf(new CachedObject(object));
    }

    public void remove(Object object) {
        this._list.remove(new CachedObject(object));
    }

    public void remove(int n) {
        this._list.remove(n);
    }

    public void removeAll(Collection collection) {
        this._list.removeAll(this.toCachedObjectCollection(collection));
    }

    public void retainAll(Collection collection) {
        this._list.retainAll(this.toCachedObjectCollection(collection));
    }

    public void set(int n, Object object) {
        this._list.set(n, new CachedObject(object));
    }

    private Collection toCachedObjectCollection(Collection collection) {
        ArrayList<CachedObject> arrayList = new ArrayList<CachedObject>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(new CachedObject(iterator.next()));
        }
        return arrayList;
    }

    public CachedObject get(int n) {
        return (CachedObject)this._list.get(n);
    }

    public boolean containsAll(Collection collection) {
        return this._list.containsAll(this.toCachedObjectCollection(collection));
    }
}

