/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Stack4;
import com.db4o.foundation.Tree;

public abstract class AbstractTreeIterator
implements Iterator4 {
    private final Tree _tree;
    private Stack4 _stack;

    public AbstractTreeIterator(Tree tree) {
        this._tree = tree;
    }

    public Object current() {
        if (this._stack == null) {
            throw new IllegalStateException();
        }
        Tree tree = this.peek();
        if (tree == null) {
            return null;
        }
        return this.currentValue(tree);
    }

    private Tree peek() {
        return (Tree)this._stack.peek();
    }

    public void reset() {
        this._stack = null;
    }

    public boolean moveNext() {
        if (this._stack == null) {
            this.initStack();
            return this._stack != null;
        }
        Tree tree = this.peek();
        if (tree == null) {
            return false;
        }
        if (this.pushPreceding(tree._subsequent)) {
            return true;
        }
        while (true) {
            this._stack.pop();
            Tree tree2 = this.peek();
            if (tree2 == null) {
                return false;
            }
            if (tree == tree2._preceding) {
                return true;
            }
            tree = tree2;
        }
    }

    private void initStack() {
        if (this._tree == null) {
            return;
        }
        this._stack = new Stack4();
        this.pushPreceding(this._tree);
    }

    private boolean pushPreceding(Tree tree) {
        if (tree == null) {
            return false;
        }
        while (tree != null) {
            this._stack.push(tree);
            tree = tree._preceding;
        }
        return true;
    }

    protected abstract Object currentValue(Tree var1);
}

