/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.ReferenceSystem;

public class ReferenceSystemRegistry {
    private final Collection4 _referenceSystems = new Collection4();

    public void removeId(final int n) {
        this.removeReference(new ReferenceSource(){

            public ObjectReference referenceFrom(ReferenceSystem referenceSystem) {
                return referenceSystem.referenceForId(n);
            }
        });
    }

    public void removeObject(final Object object) {
        this.removeReference(new ReferenceSource(){

            public ObjectReference referenceFrom(ReferenceSystem referenceSystem) {
                return referenceSystem.referenceForObject(object);
            }
        });
    }

    public void removeReference(final ObjectReference objectReference) {
        this.removeReference(new ReferenceSource(){

            public ObjectReference referenceFrom(ReferenceSystem referenceSystem) {
                return objectReference;
            }
        });
    }

    private void removeReference(ReferenceSource referenceSource) {
        Iterator4 iterator4 = this._referenceSystems.iterator();
        while (iterator4.moveNext()) {
            ReferenceSystem referenceSystem = (ReferenceSystem)iterator4.current();
            ObjectReference objectReference = referenceSource.referenceFrom(referenceSystem);
            if (objectReference == null) continue;
            referenceSystem.removeReference(objectReference);
        }
    }

    public void addReferenceSystem(ReferenceSystem referenceSystem) {
        this._referenceSystems.add(referenceSystem);
    }

    public void removeReferenceSystem(ReferenceSystem referenceSystem) {
        this._referenceSystems.remove(referenceSystem);
    }

    private static interface ReferenceSource {
        public ObjectReference referenceFrom(ReferenceSystem var1);
    }
}

