/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.Db4oIOException;
import com.db4o.internal.fileheader.FileHeader1;
import com.db4o.io.IoAdapter;

public class CachedIoAdapter
extends IoAdapter {
    private Page _head;
    private Page _tail;
    private long _position;
    private int _pageSize;
    private int _pageCount;
    private long _fileLength;
    private long _filePointer;
    private IoAdapter _io;
    private boolean _readOnly;
    private static int DEFAULT_PAGE_SIZE = 1024;
    private static int DEFAULT_PAGE_COUNT = 64;

    public CachedIoAdapter(IoAdapter ioAdapter) {
        this(ioAdapter, DEFAULT_PAGE_SIZE, DEFAULT_PAGE_COUNT);
    }

    public CachedIoAdapter(IoAdapter ioAdapter, int n, int n2) {
        this._io = ioAdapter;
        this._pageSize = n;
        this._pageCount = n2;
    }

    public CachedIoAdapter(String string, boolean bl, long l, boolean bl2, IoAdapter ioAdapter, int n, int n2) throws Db4oIOException {
        this._readOnly = bl2;
        this._pageSize = n;
        this._pageCount = n2;
        this.initCache();
        this.initIOAdaptor(string, bl, l, bl2, ioAdapter);
        this._position = l;
        this._filePointer = l;
        this._fileLength = this._io.getLength();
    }

    public IoAdapter open(String string, boolean bl, long l, boolean bl2) throws Db4oIOException {
        return new CachedIoAdapter(string, bl, l, bl2, this._io, this._pageSize, this._pageCount);
    }

    public void delete(String string) {
        this._io.delete(string);
    }

    public boolean exists(String string) {
        return this._io.exists(string);
    }

    private void initIOAdaptor(String string, boolean bl, long l, boolean bl2, IoAdapter ioAdapter) throws Db4oIOException {
        this._io = ioAdapter.open(string, bl, l, bl2);
    }

    private void initCache() {
        this._head = new Page(this._pageSize);
        this._head._prev = null;
        Page page = this._head;
        Page page2 = this._head;
        for (int i = 0; i < this._pageCount - 1; ++i) {
            page._next = page2 = new Page(this._pageSize);
            page2._prev = page;
            page = page2;
        }
        this._tail = page2;
    }

    public int read(byte[] byArray, int n) throws Db4oIOException {
        long l = this._position;
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            Page page = this.getPage(l, true);
            int n4 = page.read(byArray, n3, l, n2);
            this.movePageToHead(page);
            if (n4 <= 0) break;
            n2 -= n4;
            l += (long)n4;
            n3 += n4;
        }
        this._position = l;
        return n3 == 0 ? -1 : n3;
    }

    public void write(byte[] byArray, int n) throws Db4oIOException {
        long l;
        this.validateReadOnly();
        long l2 = this._position;
        Page page = null;
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            boolean bl = n2 < this._pageSize || l2 % (long)this._pageSize != 0L;
            page = this.getPage(l2, bl);
            page.ensureEndAddress(this.getLength());
            int n4 = page.write(byArray, n3, l2, n2);
            if (this.containsHeaderBlock(page)) {
                this.flushPage(page);
            }
            this.movePageToHead(page);
            n2 -= n4;
            l2 += (long)n4;
            n3 += n4;
        }
        this._position = l = l2;
        this._fileLength = Math.max(l, this._fileLength);
    }

    private void validateReadOnly() {
        if (this._readOnly) {
            throw new Db4oIOException();
        }
    }

    public void sync() throws Db4oIOException {
        this.validateReadOnly();
        this.flushAllPages();
        this._io.sync();
    }

    public long getLength() throws Db4oIOException {
        return this._fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Db4oIOException {
        try {
            this.flushAllPages();
        }
        finally {
            this._io.close();
        }
    }

    public IoAdapter delegatedIoAdapter() {
        return this._io.delegatedIoAdapter();
    }

    private Page getPage(long l, boolean bl) throws Db4oIOException {
        Page page = this.getPageFromCache(l);
        if (page != null) {
            if (this.containsHeaderBlock(page)) {
                this.getPageFromDisk(page, l);
            }
            page.ensureEndAddress(this._fileLength);
            return page;
        }
        page = this.getFreePageFromCache();
        if (bl) {
            this.getPageFromDisk(page, l);
        } else {
            this.resetPageAddress(page, l);
        }
        return page;
    }

    private boolean containsHeaderBlock(Page page) {
        return page.startAddress() <= (long)FileHeader1.LENGTH;
    }

    private void resetPageAddress(Page page, long l) {
        page.startAddress(l);
        page.endAddress(l + (long)this._pageSize);
    }

    private Page getFreePageFromCache() throws Db4oIOException {
        if (!this._tail.isFree()) {
            this.flushPage(this._tail);
        }
        return this._tail;
    }

    private Page getPageFromCache(long l) throws Db4oIOException {
        Page page = this._head;
        while (page != null) {
            if (page.contains(l)) {
                return page;
            }
            page = page._next;
        }
        return null;
    }

    private void flushAllPages() throws Db4oIOException {
        Page page = this._head;
        while (page != null) {
            this.flushPage(page);
            page = page._next;
        }
    }

    private void flushPage(Page page) throws Db4oIOException {
        if (!page._dirty) {
            return;
        }
        this.ioSeek(page.startAddress());
        this.writePageToDisk(page);
    }

    private void getPageFromDisk(Page page, long l) throws Db4oIOException {
        long l2 = l - l % (long)this._pageSize;
        page.startAddress(l2);
        this.ioSeek(page._startAddress);
        int n = this.ioRead(page);
        if (n > 0) {
            page.endAddress(l2 + (long)n);
        } else {
            page.endAddress(l2);
        }
    }

    private int ioRead(Page page) throws Db4oIOException {
        int n = this._io.read(page._buffer);
        if (n > 0) {
            this._filePointer = page._startAddress + (long)n;
        }
        return n;
    }

    private void movePageToHead(Page page) {
        if (page == this._head) {
            return;
        }
        if (page == this._tail) {
            Page page2 = this._tail._prev;
            page2._next = null;
            this._tail._next = this._head;
            this._tail._prev = null;
            this._head._prev = page;
            this._head = this._tail;
            this._tail = page2;
        } else {
            page._prev._next = page._next;
            page._next._prev = page._prev;
            page._next = this._head;
            this._head._prev = page;
            page._prev = null;
            this._head = page;
        }
    }

    private void writePageToDisk(Page page) throws Db4oIOException {
        this._io.write(page._buffer, page.size());
        this._filePointer = page.endAddress();
        page._dirty = false;
    }

    public void seek(long l) throws Db4oIOException {
        this._position = l;
    }

    private void ioSeek(long l) throws Db4oIOException {
        if (this._filePointer != l) {
            this._io.seek(l);
            this._filePointer = l;
        }
    }

    private static class Page {
        byte[] _buffer;
        long _startAddress = -1L;
        long _endAddress;
        int _bufferSize;
        boolean _dirty;
        Page _prev;
        Page _next;
        private byte[] zeroBytes;

        public Page(int n) {
            this._bufferSize = n;
            this._buffer = new byte[this._bufferSize];
        }

        void ensureEndAddress(long l) {
            long l2 = this._startAddress + (long)this._bufferSize;
            if (this._endAddress < l2 && l > this._endAddress) {
                long l3 = Math.min(l, l2);
                if (this.zeroBytes == null) {
                    this.zeroBytes = new byte[this._bufferSize];
                }
                System.arraycopy(this.zeroBytes, 0, this._buffer, (int)(this._endAddress - this._startAddress), (int)(l3 - this._endAddress));
                this._endAddress = l3;
            }
        }

        long endAddress() {
            return this._endAddress;
        }

        void startAddress(long l) {
            this._startAddress = l;
        }

        long startAddress() {
            return this._startAddress;
        }

        void endAddress(long l) {
            this._endAddress = l;
        }

        int size() {
            return (int)(this._endAddress - this._startAddress);
        }

        int read(byte[] byArray, int n, long l, int n2) {
            int n3 = (int)(l - this._startAddress);
            int n4 = (int)(this._endAddress - l);
            int n5 = Math.min(n4, n2);
            if (n5 <= 0) {
                return -1;
            }
            System.arraycopy(this._buffer, n3, byArray, n, n5);
            return n5;
        }

        int write(byte[] byArray, int n, long l, int n2) {
            int n3 = (int)(l - this._startAddress);
            int n4 = this._bufferSize - n3;
            int n5 = Math.min(n4, n2);
            System.arraycopy(byArray, n, this._buffer, n3, n5);
            long l2 = l + (long)n5;
            if (l2 > this._endAddress) {
                this._endAddress = l2;
            }
            this._dirty = true;
            return n5;
        }

        boolean contains(long l) {
            return this._startAddress != -1L && l >= this._startAddress && l < this._startAddress + (long)this._bufferSize;
        }

        boolean isFree() {
            return this._startAddress == -1L;
        }
    }
}

