/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.Subroutine;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.FieldEditor;
import EDU.purdue.cs.bloat.editor.IncOperand;
import EDU.purdue.cs.bloat.editor.Instruction;
import EDU.purdue.cs.bloat.editor.InstructionVisitor;
import EDU.purdue.cs.bloat.editor.Label;
import EDU.purdue.cs.bloat.editor.LocalVariable;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.MultiArrayOperand;
import EDU.purdue.cs.bloat.editor.Opcode;
import EDU.purdue.cs.bloat.editor.Switch;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.reflect.ClassFormatException;
import EDU.purdue.cs.bloat.tree.AddressStoreStmt;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.ArrayLengthExpr;
import EDU.purdue.cs.bloat.tree.ArrayRefExpr;
import EDU.purdue.cs.bloat.tree.CallExpr;
import EDU.purdue.cs.bloat.tree.CallMethodExpr;
import EDU.purdue.cs.bloat.tree.CallStaticExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.ExprStmt;
import EDU.purdue.cs.bloat.tree.FieldExpr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.InstanceOfExpr;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.JumpStmt;
import EDU.purdue.cs.bloat.tree.LabelStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.MonitorStmt;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.OperandStack;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.ReturnAddressExpr;
import EDU.purdue.cs.bloat.tree.ReturnExprStmt;
import EDU.purdue.cs.bloat.tree.ReturnStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.StackManipStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.ThrowStmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.VarExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import EDU.purdue.cs.bloat.util.Assert;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class Tree
extends Node
implements InstructionVisitor,
Opcode {
    public static boolean DEBUG = false;
    public static boolean FLATTEN = false;
    public static boolean USE_STACK = true;
    public static boolean AUPDATE_FIX_HACK = false;
    public static boolean AUPDATE_FIX_HACK_CHANGED = false;
    public static boolean USE_PERSISTENT = false;
    Block block;
    Subroutine sub;
    Block next;
    OperandStack stack;
    StmtList stmts;
    Stack savedStack;
    static int stackpos = 0;
    boolean saveValue;
    private int nextIndex = 0;
    Instruction last = null;

    private void db(String s) {
        if (DEBUG) {
            System.out.println(s);
        }
    }

    public Tree(Block block, OperandStack predStack) {
        this.block = block;
        if (DEBUG) {
            System.out.println("    new tree for " + block);
        }
        this.stack = new OperandStack();
        this.stmts = new StmtList();
        this.appendStmt(new LabelStmt(block.label()));
        int i = 0;
        while (i < predStack.size()) {
            Expr expr = predStack.get(i);
            Expr copy = (Expr)expr.clone();
            copy.setDef(null);
            this.stack.push(copy);
            ++i;
        }
    }

    public void cleanupOnly() {
    }

    public void initLocals(Collection locals) {
        LocalExpr[] t = new LocalExpr[locals.size()];
        if (t.length == 0) {
            return;
        }
        Iterator iter = locals.iterator();
        int i = 0;
        while (iter.hasNext()) {
            t[i] = (LocalExpr)iter.next();
            ++i;
        }
        this.addStmt(new InitStmt(t));
    }

    public void removeStmt(Stmt stmt) {
        this.stmts.remove(stmt);
    }

    public void removeLastStmt() {
        ListIterator iter = this.stmts.listIterator(this.stmts.size());
        while (iter.hasPrevious()) {
            Stmt s = (Stmt)iter.previous();
            if (s instanceof LabelStmt) continue;
            iter.remove();
            return;
        }
    }

    public List stmts() {
        return this.stmts;
    }

    public Stmt lastStmt() {
        ListIterator iter = this.stmts.listIterator(this.stmts.size());
        while (iter.hasPrevious()) {
            Stmt s = (Stmt)iter.previous();
            if (s instanceof LabelStmt) continue;
            return s;
        }
        return null;
    }

    public OperandStack stack() {
        return this.stack;
    }

    public void addStmtAfter(Stmt stmt, Stmt after) {
        if (DEBUG) {
            System.out.println("insert: " + stmt + " after " + after);
        }
        ListIterator iter = this.stmts.listIterator();
        while (iter.hasNext()) {
            Stmt s = (Stmt)iter.next();
            if (s != after) continue;
            iter.add(stmt);
            stmt.setParent(this);
            return;
        }
        throw new RuntimeException(after + " not found");
    }

    public void addStmtBefore(Stmt stmt, Stmt before) {
        if (DEBUG) {
            System.out.println("insert: " + stmt + " before " + before);
        }
        ListIterator iter = this.stmts.listIterator();
        while (iter.hasNext()) {
            Stmt s = (Stmt)iter.next();
            if (s != before) continue;
            iter.previous();
            iter.add(stmt);
            stmt.setParent(this);
            return;
        }
        throw new RuntimeException(before + " not found");
    }

    public void prependStmt(Stmt stmt) {
        if (DEBUG) {
            System.out.println("prepend: " + stmt + " in " + this.block);
        }
        ListIterator iter = this.stmts.listIterator();
        while (iter.hasNext()) {
            Stmt s = (Stmt)iter.next();
            if (s instanceof LabelStmt) continue;
            iter.previous();
            iter.add(stmt);
            stmt.setParent(this);
            return;
        }
        this.appendStmt(stmt);
    }

    private void saveStack() {
        int height = 0;
        int i = 0;
        while (i < this.stack.size()) {
            VarExpr copy;
            ExprStmt store;
            VarExpr target;
            Expr expr = this.stack.get(i);
            if (USE_STACK) {
                if (!(expr instanceof StackExpr) || ((StackExpr)expr).index() != height) {
                    target = new StackExpr(height, expr.type());
                    store = new ExprStmt(new StoreExpr(target, expr, expr.type()));
                    this.appendStmt(store);
                    copy = (StackExpr)((StackExpr)target).clone();
                    copy.setDef(null);
                    this.stack.set(i, copy);
                }
            } else if (!(expr instanceof LocalExpr) || !((LocalExpr)expr).fromStack() || ((LocalExpr)expr).index() != height) {
                target = this.newStackLocal(this.nextIndex++, expr.type());
                store = new ExprStmt(new StoreExpr(target, expr, expr.type()));
                this.appendStmt(store);
                copy = (LocalExpr)((LocalExpr)target).clone();
                copy.setDef(null);
                this.stack.set(i, copy);
            }
            height += expr.type().stackHeight();
            ++i;
        }
    }

    private void appendStmt(Stmt stmt) {
        if (DEBUG) {
            System.out.println("      append: " + stmt);
        }
        stmt.setParent(this);
        this.stmts.add(stmt);
    }

    public void addStmt(Stmt stmt) {
        this.saveStack();
        this.appendStmt(stmt);
    }

    public void addStmtBeforeJump(Stmt stmt) {
        Stmt last = this.lastStmt();
        Assert.isTrue(last instanceof JumpStmt, "Last statement of " + this.block + " is " + last + ", not a jump");
        this.addStmtBefore(stmt, last);
    }

    private void throwClassFormatException(String msg) {
        MethodEditor method = this.block.graph().method();
        throw new ClassFormatException("Method " + method.declaringClass().type().className() + "." + method.name() + " " + method.type() + ": " + msg);
    }

    public void addInstruction(Instruction inst, Block next) {
        Assert.isTrue(inst.isJsr() || inst.isConditionalJump(), "Wrong addInstruction called with " + inst);
        Assert.isTrue(next != null, "Null next block for " + inst);
        this.next = next;
        this.addInst(inst);
    }

    public void addInstruction(Instruction inst) {
        Assert.isTrue(!inst.isJsr() && !inst.isConditionalJump(), "Wrong addInstruction called with " + inst);
        this.next = null;
        this.addInst(inst);
    }

    public void addInstruction(Instruction inst, Subroutine sub) {
        Assert.isTrue(inst.isRet() || inst.opcodeClass() == 58, "Wrong addInstruction called with " + inst);
        this.sub = sub;
        this.next = null;
        this.addInst(inst);
    }

    public void addLabel(Label label) {
        if (this.last != null) {
            switch (this.last.opcodeClass()) {
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: {
                    break;
                }
                default: {
                    this.addInst(this.last, false);
                    this.last = null;
                }
            }
        }
        this.addStmt(new LabelStmt(label));
    }

    private void addInst(Instruction inst, boolean saveValue) {
        if (DEBUG) {
            int i = 0;
            while (i < this.stack.size()) {
                Expr exp = this.stack.peek(i);
                System.out.println(String.valueOf(i > 0 ? "-" + i : " " + i) + ": " + exp);
                ++i;
            }
        }
        if (DEBUG) {
            System.out.println("    add " + inst + " save=" + saveValue);
        }
        try {
            this.saveValue = saveValue;
            if (FLATTEN) {
                this.saveStack();
            }
            inst.visit(this);
        }
        catch (EmptyStackException e) {
            this.throwClassFormatException("Empty operand stack at " + inst);
            return;
        }
    }

    private void addInst(Instruction inst) {
        if (this.last == null) {
            this.last = inst;
        } else {
            switch (this.last.opcodeClass()) {
                case 89: {
                    switch (inst.opcodeClass()) {
                        case 54: 
                        case 56: 
                        case 58: 
                        case 179: {
                            this.addInst(inst, true);
                            this.last = null;
                        }
                    }
                    break;
                }
                case 92: {
                    switch (inst.opcodeClass()) {
                        case 55: 
                        case 57: 
                        case 179: {
                            this.addInst(inst, true);
                            this.last = null;
                        }
                    }
                    break;
                }
                case 90: {
                    switch (inst.opcodeClass()) {
                        case 181: 
                        case 204: {
                            this.addInst(inst, true);
                            this.last = null;
                        }
                    }
                    break;
                }
                case 93: {
                    switch (inst.opcodeClass()) {
                        case 181: 
                        case 204: {
                            this.addInst(inst, true);
                            this.last = null;
                        }
                    }
                    break;
                }
                case 91: {
                    switch (inst.opcodeClass()) {
                        case 79: 
                        case 81: 
                        case 83: 
                        case 84: 
                        case 85: 
                        case 86: {
                            this.addInst(inst, true);
                            this.last = null;
                        }
                    }
                    break;
                }
                case 94: {
                    switch (inst.opcodeClass()) {
                        case 80: 
                        case 82: {
                            this.addInst(inst, true);
                            this.last = null;
                        }
                    }
                }
            }
            if (this.last != null) {
                this.addInst(this.last, false);
                this.last = inst;
            }
        }
        Assert.isTrue(this.last == null || this.last == inst);
        if (inst.isJump() || inst.isSwitch() || inst.isThrow() || inst.isReturn() || inst.isJsr() || inst.isRet()) {
            this.addInst(inst, false);
            this.last = null;
        }
    }

    public StackExpr newStack(Type type) {
        return new StackExpr(stackpos++, type);
    }

    public LocalExpr newStackLocal(int index, Type type) {
        if (index >= this.nextIndex) {
            this.nextIndex = index + 1;
        }
        return new LocalExpr(index, true, type);
    }

    public LocalExpr newLocal(int index, Type type) {
        return new LocalExpr(index, false, type);
    }

    public LocalExpr newLocal(Type type) {
        LocalVariable var = this.block.graph().method().newLocal(type);
        return new LocalExpr(var.index(), type);
    }

    public String toString() {
        String x = "(TREE " + this.block + " stack=";
        int i = 0;
        while (i < this.stack.size()) {
            Expr expr = this.stack.get(i);
            x = String.valueOf(x) + expr.type().shortName();
            ++i;
        }
        return String.valueOf(x) + ")";
    }

    public void visit_nop(Instruction inst) {
    }

    public void visit_ldc(Instruction inst) {
        Type type;
        Object value = inst.operand();
        if (value == null) {
            type = Type.NULL;
        } else if (value instanceof Integer) {
            type = Type.INTEGER;
        } else if (value instanceof Long) {
            type = Type.LONG;
        } else if (value instanceof Float) {
            type = Type.FLOAT;
        } else if (value instanceof Double) {
            type = Type.DOUBLE;
        } else if (value instanceof String) {
            type = Type.STRING;
        } else if (value instanceof Type) {
            type = Type.CLASS;
        } else {
            this.throwClassFormatException("Illegal constant type: " + value.getClass().getName() + ": " + value);
            return;
        }
        ConstantExpr top = new ConstantExpr(value, type);
        this.stack.push(top);
    }

    public void visit_iload(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        LocalExpr top = new LocalExpr(operand.index(), Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lload(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        LocalExpr top = new LocalExpr(operand.index(), Type.LONG);
        this.stack.push(top);
    }

    public void visit_fload(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        LocalExpr top = new LocalExpr(operand.index(), Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_dload(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        LocalExpr top = new LocalExpr(operand.index(), Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_aload(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        LocalExpr top = new LocalExpr(operand.index(), Type.OBJECT);
        this.stack.push(top);
        this.db("      aload: " + top);
    }

    public void visit_iaload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.INTEGER.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.INTEGER, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_laload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.LONG.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.LONG, Type.LONG);
        this.stack.push(top);
    }

    public void visit_faload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.FLOAT.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.FLOAT, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_daload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.DOUBLE.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.DOUBLE, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_aaload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.OBJECT.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.OBJECT, Type.OBJECT);
        this.stack.push(top);
    }

    public void visit_baload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.BYTE.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.BYTE, Type.BYTE);
        this.stack.push(top);
    }

    public void visit_caload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.CHARACTER.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.CHARACTER, Type.CHARACTER);
        this.stack.push(top);
    }

    public void visit_saload(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.SHORT.arrayType());
        ArrayRefExpr top = new ArrayRefExpr(array, index, Type.SHORT, Type.SHORT);
        this.stack.push(top);
    }

    private void addStore(MemExpr target, Expr expr) {
        if (this.saveValue) {
            this.stack.push(new StoreExpr(target, expr, expr.type()));
        } else {
            this.addStmt(new ExprStmt(new StoreExpr(target, expr, expr.type())));
        }
    }

    public void visit_istore(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        Expr expr = this.stack.pop(Type.INTEGER);
        LocalExpr target = new LocalExpr(operand.index(), expr.type());
        this.addStore(target, expr);
    }

    public void visit_lstore(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        Expr expr = this.stack.pop(Type.LONG);
        LocalExpr target = new LocalExpr(operand.index(), expr.type());
        this.addStore(target, expr);
    }

    public void visit_fstore(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        Expr expr = this.stack.pop(Type.FLOAT);
        LocalExpr target = new LocalExpr(operand.index(), expr.type());
        this.addStore(target, expr);
    }

    public void visit_dstore(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        Expr expr = this.stack.pop(Type.DOUBLE);
        LocalExpr target = new LocalExpr(operand.index(), expr.type());
        this.addStore(target, expr);
    }

    public void visit_astore(Instruction inst) {
        LocalVariable operand = (LocalVariable)inst.operand();
        Expr expr = this.stack.peek();
        if (expr.type().isAddress()) {
            Assert.isTrue(this.sub != null);
            Assert.isTrue(!this.saveValue);
            expr = this.stack.pop(Type.ADDRESS);
            this.sub.setReturnAddress(operand);
            this.addStmt(new AddressStoreStmt(this.sub));
        } else {
            expr = this.stack.pop(Type.OBJECT);
            LocalExpr target = new LocalExpr(operand.index(), expr.type());
            this.addStore(target, expr);
        }
    }

    public void visit_iastore(Instruction inst) {
        Expr value = this.stack.pop(Type.INTEGER);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.INTEGER.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.INTEGER, Type.INTEGER);
        this.addStore(target, value);
    }

    public void visit_lastore(Instruction inst) {
        Expr value = this.stack.pop(Type.LONG);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.LONG.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.LONG, Type.LONG);
        this.addStore(target, value);
    }

    public void visit_fastore(Instruction inst) {
        Expr value = this.stack.pop(Type.FLOAT);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.FLOAT.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.FLOAT, Type.FLOAT);
        this.addStore(target, value);
    }

    public void visit_dastore(Instruction inst) {
        Expr value = this.stack.pop(Type.DOUBLE);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.DOUBLE.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.DOUBLE, Type.DOUBLE);
        this.addStore(target, value);
    }

    public void visit_aastore(Instruction inst) {
        Expr value = this.stack.pop(Type.OBJECT);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.OBJECT.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.OBJECT, Type.OBJECT);
        this.addStore(target, value);
    }

    public void visit_bastore(Instruction inst) {
        Expr value = this.stack.pop(Type.BYTE);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.BYTE.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.BYTE, Type.BYTE);
        this.addStore(target, value);
    }

    public void visit_castore(Instruction inst) {
        Expr value = this.stack.pop(Type.CHARACTER);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.CHARACTER.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.CHARACTER, Type.CHARACTER);
        this.addStore(target, value);
    }

    public void visit_sastore(Instruction inst) {
        Expr value = this.stack.pop(Type.SHORT);
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.SHORT.arrayType());
        ArrayRefExpr target = new ArrayRefExpr(array, index, Type.SHORT, Type.SHORT);
        this.addStore(target, value);
    }

    public void visit_pop(Instruction inst) {
        Expr expr = this.stack.pop1();
        this.addStmt(new ExprStmt(expr));
    }

    public void visit_pop2(Instruction inst) {
        Expr[] expr = this.stack.pop2();
        if (expr.length == 1) {
            this.addStmt(new ExprStmt(expr[0]));
        } else {
            this.addStmt(new ExprStmt(expr[0]));
            this.addStmt(new ExprStmt(expr[1]));
        }
    }

    public void visit_dup(Instruction inst) {
        this.db("      dup");
        if (USE_STACK) {
            this.saveStack();
            StackExpr s0 = (StackExpr)this.stack.pop1();
            StackExpr[] s = new StackExpr[]{s0};
            this.manip(s, new int[2], 1);
        } else {
            Expr s0 = this.stack.pop1();
            LocalExpr t0 = this.newStackLocal(this.stack.height(), s0.type());
            this.db("        s0: " + s0);
            this.db("        t0: " + t0);
            if (!t0.equalsExpr(s0)) {
                this.db("          t0 <- s0");
                this.addStore(t0, s0);
            }
            Expr copy = (Expr)t0.clone();
            copy.setDef(null);
            this.stack.push(copy);
            copy = (Expr)t0.clone();
            copy.setDef(null);
            this.stack.push(copy);
        }
    }

    public void visit_dup_x1(Instruction inst) {
        if (USE_STACK) {
            this.saveStack();
            StackExpr s1 = (StackExpr)this.stack.pop1();
            StackExpr s0 = (StackExpr)this.stack.pop1();
            StackExpr[] s = new StackExpr[]{s0, s1};
            int[] nArray = new int[3];
            nArray[0] = 1;
            nArray[2] = 1;
            this.manip(s, nArray, 2);
        } else {
            Expr s1 = this.stack.pop1();
            Expr s0 = this.stack.pop1();
            LocalExpr t0 = this.newStackLocal(this.stack.height(), s0.type());
            LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s1.type());
            if (!t0.equalsExpr(s0)) {
                this.addStore(t0, s0);
            }
            if (!t1.equalsExpr(s1)) {
                this.addStore(t1, s1);
            }
            Expr copy = (Expr)t1.clone();
            copy.setDef(null);
            this.stack.push(copy);
            copy = (Expr)t0.clone();
            copy.setDef(null);
            this.stack.push(copy);
            copy = (Expr)t1.clone();
            copy.setDef(null);
            this.stack.push(copy);
        }
    }

    public void visit_dup_x2(Instruction inst) {
        this.db("      dup_x2");
        if (USE_STACK) {
            this.saveStack();
            StackExpr s2 = (StackExpr)this.stack.pop1();
            Expr[] s01 = this.stack.pop2();
            if (s01.length == 2) {
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0], (StackExpr)s01[1], s2};
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[2] = 1;
                nArray[3] = 2;
                this.manip(s, nArray, 3);
            } else {
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0], s2};
                int[] nArray = new int[3];
                nArray[0] = 1;
                nArray[2] = 1;
                this.manip(s, nArray, 3);
            }
        } else {
            Expr s2 = this.stack.pop1();
            Expr[] s01 = this.stack.pop2();
            this.db("        s2: " + s2);
            this.db("        s01: " + s01[0] + (s01.length > 1 ? " " + s01[1] : ""));
            if (s01.length == 2) {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s01[1].type());
                LocalExpr t2 = this.newStackLocal(this.stack.height() + 2, s2.type());
                this.db("        t0: " + t0);
                this.db("        t1: " + t1);
                this.db("        t2: " + t2);
                if (!t0.equalsExpr(s01[0])) {
                    this.db("          t0 <- s01[0]");
                    this.addStore(t0, s01[0]);
                }
                if (!t1.equalsExpr(s01[1])) {
                    this.db("          t1 <- s01[1]");
                    this.addStore(t1, s01[1]);
                }
                if (!t2.equalsExpr(s2)) {
                    this.db("          t2 <- s2");
                    this.addStore(t2, s2);
                }
                Expr copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
            } else {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                LocalExpr t2 = this.newStackLocal(this.stack.height() + 2, s2.type());
                if (!t0.equalsExpr(s01[0])) {
                    this.addStore(t0, s01[0]);
                }
                if (!t2.equalsExpr(s2)) {
                    this.addStore(t2, s2);
                }
                Expr copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
            }
        }
    }

    public void visit_dup2(Instruction inst) {
        if (USE_STACK) {
            this.saveStack();
            Expr[] s01 = this.stack.pop2();
            if (s01.length == 1) {
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0]};
                this.manip(s, new int[2], 4);
            } else {
                Assert.isTrue(s01.length == 2);
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0], (StackExpr)s01[1]};
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[3] = 1;
                this.manip(s, nArray, 4);
            }
        } else {
            Expr[] s01 = this.stack.pop2();
            if (s01.length == 1) {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                if (!t0.equalsExpr(s01[0])) {
                    this.addStore(t0, s01[0]);
                }
                Expr copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
            } else {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s01[1].type());
                if (!t0.equalsExpr(s01[0])) {
                    this.addStore(t0, s01[0]);
                }
                if (!t1.equalsExpr(s01[1])) {
                    this.addStore(t1, s01[1]);
                }
                Expr copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
            }
        }
    }

    public void visit_dup2_x1(Instruction inst) {
        if (USE_STACK) {
            this.saveStack();
            Expr[] s12 = this.stack.pop2();
            StackExpr s0 = (StackExpr)this.stack.pop1();
            if (s12.length == 2) {
                StackExpr[] s = new StackExpr[]{s0, (StackExpr)s12[0], (StackExpr)s12[1]};
                int[] nArray = new int[5];
                nArray[0] = 1;
                nArray[1] = 2;
                nArray[3] = 1;
                nArray[4] = 2;
                this.manip(s, nArray, 5);
            } else {
                StackExpr[] s = new StackExpr[]{s0, (StackExpr)s12[0]};
                int[] nArray = new int[3];
                nArray[0] = 1;
                nArray[2] = 1;
                this.manip(s, nArray, 5);
            }
        } else {
            Expr[] s12 = this.stack.pop2();
            StackExpr s0 = (StackExpr)this.stack.pop1();
            if (s12.length == 2) {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s0.type());
                LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s12[0].type());
                LocalExpr t2 = this.newStackLocal(this.stack.height() + 2, s12[1].type());
                if (!t0.equalsExpr(s0)) {
                    this.addStore(t0, s0);
                }
                if (!t1.equalsExpr(s12[0])) {
                    this.addStore(t1, s12[0]);
                }
                if (!t2.equalsExpr(s12[1])) {
                    this.addStore(t2, s12[1]);
                }
                Expr copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
            } else {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s0.type());
                LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s12[0].type());
                if (!t0.equalsExpr(s0)) {
                    this.addStore(t0, s0);
                }
                if (!t1.equalsExpr(s12[0])) {
                    this.addStore(t1, s12[0]);
                }
                Expr copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
            }
        }
    }

    public void visit_dup2_x2(Instruction inst) {
        if (USE_STACK) {
            this.saveStack();
            Expr[] s23 = this.stack.pop2();
            Expr[] s01 = this.stack.pop2();
            if (s01.length == 2 && s23.length == 2) {
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0], (StackExpr)s01[1], (StackExpr)s23[0], (StackExpr)s23[1]};
                int[] nArray = new int[6];
                nArray[0] = 2;
                nArray[1] = 3;
                nArray[3] = 1;
                nArray[4] = 2;
                nArray[5] = 3;
                this.manip(s, nArray, 6);
            } else if (s01.length == 2 && s23.length == 1) {
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0], (StackExpr)s01[1], (StackExpr)s23[0]};
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[2] = 1;
                nArray[3] = 2;
                this.manip(s, nArray, 6);
            } else if (s01.length == 1 && s23.length == 2) {
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0], (StackExpr)s23[0], (StackExpr)s23[1]};
                int[] nArray = new int[5];
                nArray[0] = 1;
                nArray[1] = 2;
                nArray[3] = 1;
                nArray[4] = 2;
                this.manip(s, nArray, 6);
            } else if (s01.length == 1 && s23.length == 2) {
                StackExpr[] s = new StackExpr[]{(StackExpr)s01[0], (StackExpr)s23[0]};
                int[] nArray = new int[3];
                nArray[0] = 1;
                nArray[2] = 1;
                this.manip(s, nArray, 6);
            }
        } else {
            Expr[] s23 = this.stack.pop2();
            Expr[] s01 = this.stack.pop2();
            if (s01.length == 2 && s23.length == 2) {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s01[1].type());
                LocalExpr t2 = this.newStackLocal(this.stack.height() + 2, s23[0].type());
                LocalExpr t3 = this.newStackLocal(this.stack.height() + 3, s23[1].type());
                if (!t0.equalsExpr(s01[0])) {
                    this.addStore(t0, s01[0]);
                }
                if (!t1.equalsExpr(s01[1])) {
                    this.addStore(t1, s01[1]);
                }
                if (!t2.equalsExpr(s23[0])) {
                    this.addStore(t2, s23[0]);
                }
                if (!t3.equalsExpr(s23[1])) {
                    this.addStore(t3, s23[1]);
                }
                Expr copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t3.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t3.clone();
                copy.setDef(null);
                this.stack.push(copy);
            } else if (s01.length == 2 && s23.length == 1) {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s01[1].type());
                LocalExpr t2 = this.newStackLocal(this.stack.height() + 2, s23[0].type());
                if (!t0.equalsExpr(s01[0])) {
                    this.addStore(t0, s01[0]);
                }
                if (!t1.equalsExpr(s01[1])) {
                    this.addStore(t1, s01[1]);
                }
                if (!t2.equalsExpr(s23[0])) {
                    this.addStore(t2, s23[0]);
                }
                Expr copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t1.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
            } else if (s01.length == 1 && s23.length == 2) {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                LocalExpr t2 = this.newStackLocal(this.stack.height() + 2, s23[0].type());
                LocalExpr t3 = this.newStackLocal(this.stack.height() + 3, s23[1].type());
                if (!t0.equalsExpr(s01[0])) {
                    this.addStore(t0, s01[0]);
                }
                if (!t2.equalsExpr(s23[0])) {
                    this.addStore(t2, s23[0]);
                }
                if (!t3.equalsExpr(s23[1])) {
                    this.addStore(t3, s23[1]);
                }
                Expr copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t3.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t3.clone();
                copy.setDef(null);
                this.stack.push(copy);
            } else if (s01.length == 1 && s23.length == 2) {
                LocalExpr t0 = this.newStackLocal(this.stack.height(), s01[0].type());
                LocalExpr t2 = this.newStackLocal(this.stack.height() + 2, s23[0].type());
                if (!t0.equalsExpr(s01[0])) {
                    this.addStore(t0, s01[0]);
                }
                if (!t2.equalsExpr(s23[0])) {
                    this.addStore(t2, s23[0]);
                }
                Expr copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t0.clone();
                copy.setDef(null);
                this.stack.push(copy);
                copy = (Expr)t2.clone();
                copy.setDef(null);
                this.stack.push(copy);
            }
        }
    }

    public void visit_swap(Instruction inst) {
        if (USE_STACK) {
            this.saveStack();
            StackExpr s1 = (StackExpr)this.stack.pop1();
            StackExpr s0 = (StackExpr)this.stack.pop1();
            StackExpr[] s = new StackExpr[]{s0, s1};
            int[] nArray = new int[2];
            nArray[0] = 1;
            this.manip(s, nArray, 0);
        } else {
            Expr s1 = this.stack.pop1();
            Expr s0 = this.stack.pop1();
            LocalExpr t0 = this.newStackLocal(this.stack.height(), s0.type());
            LocalExpr t1 = this.newStackLocal(this.stack.height() + 1, s1.type());
            if (!t0.equalsExpr(s0)) {
                this.addStore(t0, s0);
            }
            if (!t1.equalsExpr(s1)) {
                this.addStore(t1, s1);
            }
            Expr copy = (Expr)t1.clone();
            copy.setDef(null);
            this.stack.push(copy);
            copy = (Expr)t0.clone();
            copy.setDef(null);
            this.stack.push(copy);
        }
    }

    private void manip(StackExpr[] source, int[] s, int kind) {
        Assert.isTrue(USE_STACK);
        int height = 0;
        int i = 0;
        while (i < this.stack.size()) {
            Expr expr = this.stack.get(i);
            height += expr.type().stackHeight();
            ++i;
        }
        StackExpr[] target = new StackExpr[s.length];
        int i2 = 0;
        while (i2 < s.length) {
            target[i2] = new StackExpr(height, source[s[i2]].type());
            StackExpr copy = (StackExpr)target[i2].clone();
            copy.setDef(null);
            this.stack.push(copy);
            height += target[i2].type().stackHeight();
            ++i2;
        }
        this.appendStmt(new StackManipStmt(target, source, kind));
    }

    public void visit_iadd(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ArithExpr top = new ArithExpr('+', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_ladd(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ArithExpr top = new ArithExpr('+', left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_fadd(Instruction inst) {
        Expr right = this.stack.pop(Type.FLOAT);
        Expr left = this.stack.pop(Type.FLOAT);
        ArithExpr top = new ArithExpr('+', left, right, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_dadd(Instruction inst) {
        Expr right = this.stack.pop(Type.DOUBLE);
        Expr left = this.stack.pop(Type.DOUBLE);
        ArithExpr top = new ArithExpr('+', left, right, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_isub(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ArithExpr top = new ArithExpr('-', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lsub(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ArithExpr top = new ArithExpr('-', left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_fsub(Instruction inst) {
        Expr right = this.stack.pop(Type.FLOAT);
        Expr left = this.stack.pop(Type.FLOAT);
        ArithExpr top = new ArithExpr('-', left, right, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_dsub(Instruction inst) {
        Expr right = this.stack.pop(Type.DOUBLE);
        Expr left = this.stack.pop(Type.DOUBLE);
        ArithExpr top = new ArithExpr('-', left, right, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_imul(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ArithExpr top = new ArithExpr('*', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lmul(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ArithExpr top = new ArithExpr('*', left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_fmul(Instruction inst) {
        Expr right = this.stack.pop(Type.FLOAT);
        Expr left = this.stack.pop(Type.FLOAT);
        ArithExpr top = new ArithExpr('*', left, right, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_dmul(Instruction inst) {
        Expr right = this.stack.pop(Type.DOUBLE);
        Expr left = this.stack.pop(Type.DOUBLE);
        ArithExpr top = new ArithExpr('*', left, right, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_idiv(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ZeroCheckExpr check = new ZeroCheckExpr(right, Type.INTEGER);
        ArithExpr top = new ArithExpr('/', left, check, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_ldiv(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ZeroCheckExpr check = new ZeroCheckExpr(right, Type.LONG);
        ArithExpr top = new ArithExpr('/', left, check, Type.LONG);
        this.stack.push(top);
    }

    public void visit_fdiv(Instruction inst) {
        Expr right = this.stack.pop(Type.FLOAT);
        Expr left = this.stack.pop(Type.FLOAT);
        ArithExpr top = new ArithExpr('/', left, right, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_ddiv(Instruction inst) {
        Expr right = this.stack.pop(Type.DOUBLE);
        Expr left = this.stack.pop(Type.DOUBLE);
        ArithExpr top = new ArithExpr('/', left, right, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_irem(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ZeroCheckExpr check = new ZeroCheckExpr(right, Type.INTEGER);
        ArithExpr top = new ArithExpr('%', left, check, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lrem(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ZeroCheckExpr check = new ZeroCheckExpr(right, Type.LONG);
        ArithExpr top = new ArithExpr('%', left, check, Type.LONG);
        this.stack.push(top);
    }

    public void visit_frem(Instruction inst) {
        Expr right = this.stack.pop(Type.FLOAT);
        Expr left = this.stack.pop(Type.FLOAT);
        ArithExpr top = new ArithExpr('%', left, right, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_drem(Instruction inst) {
        Expr right = this.stack.pop(Type.DOUBLE);
        Expr left = this.stack.pop(Type.DOUBLE);
        ArithExpr top = new ArithExpr('%', left, right, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_ineg(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        NegExpr top = new NegExpr(expr, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lneg(Instruction inst) {
        Expr expr = this.stack.pop(Type.LONG);
        NegExpr top = new NegExpr(expr, Type.LONG);
        this.stack.push(top);
    }

    public void visit_fneg(Instruction inst) {
        Expr expr = this.stack.pop(Type.FLOAT);
        NegExpr top = new NegExpr(expr, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_dneg(Instruction inst) {
        Expr expr = this.stack.pop(Type.DOUBLE);
        NegExpr top = new NegExpr(expr, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_ishl(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ShiftExpr top = new ShiftExpr(0, left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lshl(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.LONG);
        ShiftExpr top = new ShiftExpr(0, left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_ishr(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ShiftExpr top = new ShiftExpr(1, left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lshr(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.LONG);
        ShiftExpr top = new ShiftExpr(1, left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_iushr(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ShiftExpr top = new ShiftExpr(2, left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lushr(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.LONG);
        ShiftExpr top = new ShiftExpr(2, left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_iand(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ArithExpr top = new ArithExpr('&', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_land(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ArithExpr top = new ArithExpr('&', left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_ior(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ArithExpr top = new ArithExpr('|', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lor(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ArithExpr top = new ArithExpr('|', left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_ixor(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        ArithExpr top = new ArithExpr('^', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lxor(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ArithExpr top = new ArithExpr('^', left, right, Type.LONG);
        this.stack.push(top);
    }

    public void visit_iinc(Instruction inst) {
        IncOperand operand = (IncOperand)inst.operand();
        int incr = operand.incr();
        if (incr < 0) {
            ConstantExpr right = new ConstantExpr(new Integer(-incr), Type.INTEGER);
            LocalExpr left = new LocalExpr(operand.var().index(), Type.INTEGER);
            ArithExpr top = new ArithExpr('-', left, right, Type.INTEGER);
            LocalExpr copy = (LocalExpr)((Expr)left).clone();
            copy.setDef(null);
            this.addStmt(new ExprStmt(new StoreExpr(copy, top, left.type())));
        } else if (incr > 0) {
            ConstantExpr right = new ConstantExpr(new Integer(incr), Type.INTEGER);
            LocalExpr left = new LocalExpr(operand.var().index(), Type.INTEGER);
            ArithExpr top = new ArithExpr('+', left, right, Type.INTEGER);
            LocalExpr copy = (LocalExpr)((Expr)left).clone();
            copy.setDef(null);
            this.addStmt(new ExprStmt(new StoreExpr(copy, top, left.type())));
        }
    }

    public void visit_i2l(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        CastExpr top = new CastExpr(expr, Type.LONG, Type.LONG);
        this.stack.push(top);
    }

    public void visit_i2f(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        CastExpr top = new CastExpr(expr, Type.FLOAT, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_i2d(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        CastExpr top = new CastExpr(expr, Type.DOUBLE, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_l2i(Instruction inst) {
        Expr expr = this.stack.pop(Type.LONG);
        CastExpr top = new CastExpr(expr, Type.INTEGER, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_l2f(Instruction inst) {
        Expr expr = this.stack.pop(Type.LONG);
        CastExpr top = new CastExpr(expr, Type.FLOAT, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_l2d(Instruction inst) {
        Expr expr = this.stack.pop(Type.LONG);
        CastExpr top = new CastExpr(expr, Type.DOUBLE, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_f2i(Instruction inst) {
        Expr expr = this.stack.pop(Type.FLOAT);
        CastExpr top = new CastExpr(expr, Type.INTEGER, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_f2l(Instruction inst) {
        Expr expr = this.stack.pop(Type.FLOAT);
        CastExpr top = new CastExpr(expr, Type.LONG, Type.LONG);
        this.stack.push(top);
    }

    public void visit_f2d(Instruction inst) {
        Expr expr = this.stack.pop(Type.FLOAT);
        CastExpr top = new CastExpr(expr, Type.DOUBLE, Type.DOUBLE);
        this.stack.push(top);
    }

    public void visit_d2i(Instruction inst) {
        Expr expr = this.stack.pop(Type.DOUBLE);
        CastExpr top = new CastExpr(expr, Type.INTEGER, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_d2l(Instruction inst) {
        Expr expr = this.stack.pop(Type.DOUBLE);
        CastExpr top = new CastExpr(expr, Type.LONG, Type.LONG);
        this.stack.push(top);
    }

    public void visit_d2f(Instruction inst) {
        Expr expr = this.stack.pop(Type.DOUBLE);
        CastExpr top = new CastExpr(expr, Type.FLOAT, Type.FLOAT);
        this.stack.push(top);
    }

    public void visit_i2b(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        CastExpr top = new CastExpr(expr, Type.BYTE, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_i2c(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        CastExpr top = new CastExpr(expr, Type.CHARACTER, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_i2s(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        CastExpr top = new CastExpr(expr, Type.SHORT, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_lcmp(Instruction inst) {
        Expr right = this.stack.pop(Type.LONG);
        Expr left = this.stack.pop(Type.LONG);
        ArithExpr top = new ArithExpr('?', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_fcmpl(Instruction inst) {
        Expr right = this.stack.pop(Type.FLOAT);
        Expr left = this.stack.pop(Type.FLOAT);
        ArithExpr top = new ArithExpr('<', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_fcmpg(Instruction inst) {
        Expr right = this.stack.pop(Type.FLOAT);
        Expr left = this.stack.pop(Type.FLOAT);
        ArithExpr top = new ArithExpr('>', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_dcmpl(Instruction inst) {
        Expr right = this.stack.pop(Type.DOUBLE);
        Expr left = this.stack.pop(Type.DOUBLE);
        ArithExpr top = new ArithExpr('<', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_dcmpg(Instruction inst) {
        Expr right = this.stack.pop(Type.DOUBLE);
        Expr left = this.stack.pop(Type.DOUBLE);
        ArithExpr top = new ArithExpr('>', left, right, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_ifeq(Instruction inst) {
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(0, left, t, this.next));
    }

    public void visit_ifne(Instruction inst) {
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(1, left, t, this.next));
    }

    public void visit_iflt(Instruction inst) {
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(4, left, t, this.next));
    }

    public void visit_ifge(Instruction inst) {
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(3, left, t, this.next));
    }

    public void visit_ifgt(Instruction inst) {
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(2, left, t, this.next));
    }

    public void visit_ifle(Instruction inst) {
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(5, left, t, this.next));
    }

    public void visit_if_icmpeq(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(0, left, right, t, this.next));
    }

    public void visit_if_icmpne(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(1, left, right, t, this.next));
    }

    public void visit_if_icmplt(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(4, left, right, t, this.next));
    }

    public void visit_if_icmpge(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(3, left, right, t, this.next));
    }

    public void visit_if_icmpgt(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(2, left, right, t, this.next));
    }

    public void visit_if_icmple(Instruction inst) {
        Expr right = this.stack.pop(Type.INTEGER);
        Expr left = this.stack.pop(Type.INTEGER);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(5, left, right, t, this.next));
    }

    public void visit_if_acmpeq(Instruction inst) {
        Expr right = this.stack.pop(Type.OBJECT);
        Expr left = this.stack.pop(Type.OBJECT);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(0, left, right, t, this.next));
    }

    public void visit_if_acmpne(Instruction inst) {
        Expr right = this.stack.pop(Type.OBJECT);
        Expr left = this.stack.pop(Type.OBJECT);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfCmpStmt(1, left, right, t, this.next));
    }

    public void visit_goto(Instruction inst) {
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new GotoStmt(t));
    }

    public void visit_jsr(Instruction inst) {
        Subroutine sub = this.block.graph().labelSub((Label)inst.operand());
        this.addStmt(new JsrStmt(sub, this.next));
        this.stack.push(new ReturnAddressExpr(Type.ADDRESS));
    }

    public void visit_ret(Instruction inst) {
        Assert.isTrue(this.sub != null);
        this.addStmt(new RetStmt(this.sub));
    }

    public void visit_switch(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Switch sw = (Switch)inst.operand();
        Block defaultTarget = (Block)this.block.graph().getNode(sw.defaultTarget());
        Assert.isTrue(defaultTarget != null, "No block for " + inst);
        Block[] targets = new Block[sw.targets().length];
        int i = 0;
        while (i < targets.length) {
            targets[i] = (Block)this.block.graph().getNode(sw.targets()[i]);
            Assert.isTrue(targets[i] != null, "No block for " + inst);
            ++i;
        }
        this.addStmt(new SwitchStmt(index, defaultTarget, targets, sw.values()));
    }

    public void visit_ireturn(Instruction inst) {
        Expr expr = this.stack.pop(Type.INTEGER);
        this.addStmt(new ReturnExprStmt(expr));
    }

    public void visit_lreturn(Instruction inst) {
        Expr expr = this.stack.pop(Type.LONG);
        this.addStmt(new ReturnExprStmt(expr));
    }

    public void visit_freturn(Instruction inst) {
        Expr expr = this.stack.pop(Type.FLOAT);
        this.addStmt(new ReturnExprStmt(expr));
    }

    public void visit_dreturn(Instruction inst) {
        Expr expr = this.stack.pop(Type.DOUBLE);
        this.addStmt(new ReturnExprStmt(expr));
    }

    public void visit_areturn(Instruction inst) {
        Expr expr = this.stack.pop(Type.OBJECT);
        this.addStmt(new ReturnExprStmt(expr));
    }

    public void visit_return(Instruction inst) {
        this.addStmt(new ReturnStmt());
    }

    public void visit_getstatic(Instruction inst) {
        MemberRef field = (MemberRef)inst.operand();
        Type type = field.nameAndType().type();
        try {
            EditorContext context = this.block.graph().method().declaringClass().context();
            FieldEditor e = context.editField(field);
            if (e.isFinal() && e.constantValue() != null) {
                ConstantExpr top = new ConstantExpr(e.constantValue(), type);
                this.stack.push(top);
                context.release(e.fieldInfo());
                return;
            }
            context.release(e.fieldInfo());
        }
        catch (NoSuchFieldException context) {
            // empty catch block
        }
        StaticFieldExpr top = new StaticFieldExpr(field, type);
        this.stack.push(top);
    }

    public void visit_putstatic(Instruction inst) {
        MemberRef field = (MemberRef)inst.operand();
        Type type = field.nameAndType().type();
        Expr value = this.stack.pop(type);
        StaticFieldExpr target = new StaticFieldExpr(field, type);
        this.addStore(target, value);
    }

    public void visit_putstatic_nowb(Instruction inst) {
        this.visit_putstatic(inst);
    }

    public void visit_getfield(Instruction inst) {
        MemberRef field = (MemberRef)inst.operand();
        Type type = field.nameAndType().type();
        Expr obj = this.stack.pop(Type.OBJECT);
        ZeroCheckExpr check = new ZeroCheckExpr(obj, obj.type());
        FieldExpr top = new FieldExpr(check, field, type);
        this.stack.push(top);
    }

    public void visit_putfield(Instruction inst) {
        Expr obj;
        MemberRef field = (MemberRef)inst.operand();
        Type type = field.nameAndType().type();
        Expr value = this.stack.pop(type);
        Expr ucCheck = obj = this.stack.pop(Type.OBJECT);
        if (USE_PERSISTENT) {
            ucCheck = new UCExpr(obj, 1, obj.type());
        }
        ZeroCheckExpr check = new ZeroCheckExpr(ucCheck, obj.type());
        FieldExpr target = new FieldExpr(check, field, type);
        this.addStore(target, value);
    }

    public void visit_putfield_nowb(Instruction inst) {
        MemberRef field = (MemberRef)inst.operand();
        Type type = field.nameAndType().type();
        Expr value = this.stack.pop(type);
        Expr obj = this.stack.pop(Type.OBJECT);
        ZeroCheckExpr check = new ZeroCheckExpr(obj, obj.type());
        FieldExpr target = new FieldExpr(check, field, type);
        this.addStore(target, value);
    }

    public void visit_invokevirtual(Instruction inst) {
        this.addCall(inst, 0);
    }

    public void visit_invokespecial(Instruction inst) {
        this.addCall(inst, 1);
    }

    public void visit_invokestatic(Instruction inst) {
        this.addCall(inst, 0);
    }

    public void visit_invokeinterface(Instruction inst) {
        this.addCall(inst, 2);
    }

    private void addCall(Instruction inst, int kind) {
        CallExpr top;
        MemberRef method = (MemberRef)inst.operand();
        Type type = method.nameAndType().type();
        Type[] paramTypes = type.paramTypes();
        Expr[] params = new Expr[paramTypes.length];
        int i = paramTypes.length - 1;
        while (i >= 0) {
            params[i] = this.stack.pop(paramTypes[i]);
            --i;
        }
        if (inst.opcodeClass() != 184) {
            Expr obj = this.stack.pop(Type.OBJECT);
            top = new CallMethodExpr(kind, obj, params, method, type.returnType());
        } else {
            top = new CallStaticExpr(params, method, type.returnType());
        }
        if (type.returnType().equals(Type.VOID)) {
            this.addStmt(new ExprStmt(top));
        } else {
            this.stack.push(top);
        }
    }

    public void visit_new(Instruction inst) {
        Type type = (Type)inst.operand();
        NewExpr top = new NewExpr(type, Type.OBJECT);
        this.stack.push(top);
        this.db("      new: " + top);
    }

    public void visit_newarray(Instruction inst) {
        Type type = (Type)inst.operand();
        Expr size = this.stack.pop(Type.INTEGER);
        NewArrayExpr top = new NewArrayExpr(size, type, type.arrayType());
        this.stack.push(top);
    }

    public void visit_arraylength(Instruction inst) {
        Expr array = this.stack.pop(Type.OBJECT);
        ArrayLengthExpr top = new ArrayLengthExpr(array, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_athrow(Instruction inst) {
        Expr expr = this.stack.pop(Type.THROWABLE);
        this.addStmt(new ThrowStmt(expr));
    }

    public void visit_checkcast(Instruction inst) {
        Expr expr = this.stack.pop(Type.OBJECT);
        Type type = (Type)inst.operand();
        CastExpr top = new CastExpr(expr, type, type);
        this.stack.push(top);
    }

    public void visit_instanceof(Instruction inst) {
        Type type = (Type)inst.operand();
        Expr expr = this.stack.pop(Type.OBJECT);
        InstanceOfExpr top = new InstanceOfExpr(expr, type, Type.INTEGER);
        this.stack.push(top);
    }

    public void visit_monitorenter(Instruction inst) {
        Expr obj = this.stack.pop(Type.OBJECT);
        this.addStmt(new MonitorStmt(0, obj));
    }

    public void visit_monitorexit(Instruction inst) {
        Expr obj = this.stack.pop(Type.OBJECT);
        this.addStmt(new MonitorStmt(1, obj));
    }

    public void visit_multianewarray(Instruction inst) {
        MultiArrayOperand operand = (MultiArrayOperand)inst.operand();
        Expr[] dim = new Expr[operand.dimensions()];
        int i = dim.length - 1;
        while (i >= 0) {
            dim[i] = this.stack.pop(Type.INTEGER);
            --i;
        }
        Type type = operand.type();
        NewMultiArrayExpr top = new NewMultiArrayExpr(dim, type.elementType(dim.length), type);
        this.stack.push(top);
    }

    public void visit_ifnull(Instruction inst) {
        Expr left = this.stack.pop(Type.OBJECT);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(0, left, t, this.next));
    }

    public void visit_ifnonnull(Instruction inst) {
        Expr left = this.stack.pop(Type.OBJECT);
        Block t = (Block)this.block.graph().getNode(inst.operand());
        Assert.isTrue(t != null, "No block for " + inst);
        this.addStmt(new IfZeroStmt(1, left, t, this.next));
    }

    public void visit_rc(Instruction inst) {
        Integer depth = (Integer)inst.operand();
        Expr object = this.stack.peek(depth);
        this.stack.replace(depth, new RCExpr(object, object.type()));
    }

    public void visit_aupdate(Instruction inst) {
        Expr object;
        Integer depth = (Integer)inst.operand();
        if (AUPDATE_FIX_HACK && depth == 1 && (object = this.stack.peek()).type().isWide()) {
            depth = new Integer(2);
            inst.setOperand(depth);
            AUPDATE_FIX_HACK_CHANGED = true;
        }
        object = this.stack.peek(depth);
        this.stack.replace(depth, new UCExpr(object, 1, object.type()));
    }

    public void visit_supdate(Instruction inst) {
        Integer depth = (Integer)inst.operand();
        Expr object = this.stack.peek(depth);
        this.stack.replace(depth, new UCExpr(object, 2, object.type()));
    }

    public void visit_aswizzle(Instruction inst) {
        Expr index = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.OBJECT.arrayType());
        this.addStmt(new SCStmt(array, index));
    }

    public void visit_aswrange(Instruction inst) {
        Expr end = this.stack.pop(Type.INTEGER);
        Expr start = this.stack.pop(Type.INTEGER);
        Expr array = this.stack.pop(Type.OBJECT.arrayType());
        this.addStmt(new SRStmt(array, start, end));
    }

    public void visitForceChildren(TreeVisitor visitor) {
        LinkedList list = new LinkedList(this.stmts);
        if (visitor.reverse()) {
            ListIterator iter = list.listIterator(this.stmts.size());
            while (iter.hasPrevious()) {
                Stmt s = (Stmt)iter.previous();
                s.visit(visitor);
            }
        } else {
            ListIterator iter = list.listIterator();
            while (iter.hasNext()) {
                Stmt s = (Stmt)iter.next();
                s.visit(visitor);
            }
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitTree(this);
    }

    public Node parent() {
        return null;
    }

    public Block block() {
        return this.block;
    }

    class StmtList
    extends LinkedList {
        StmtList() {
        }

        public void clear() {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ((Stmt)iter.next()).cleanup();
            }
            super.clear();
        }

        public boolean remove(Object o) {
            if (super.remove(o)) {
                ((Stmt)o).cleanup();
                return true;
            }
            return false;
        }

        public boolean removeAll(Collection c) {
            boolean changed = false;
            if (c == this) {
                changed = this.size() > 0;
                this.clear();
            } else {
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    boolean bl = changed = this.remove(iter.next()) || changed;
                }
            }
            return changed;
        }

        public boolean retainAll(Collection c) {
            boolean changed = false;
            if (c == this) {
                return false;
            }
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                if (c.contains(iter.next())) continue;
                changed = true;
                iter.remove();
            }
            return changed;
        }

        public Object set(int index, Object element) {
            Stmt s;
            if (index < this.size() && (s = (Stmt)this.get(index)) != element) {
                s.cleanup();
            }
            return super.set(index, element);
        }

        public Object remove(int index) {
            Object o = super.remove(index);
            if (o != null) {
                ((Stmt)o).cleanup();
            }
            return o;
        }

        public ListIterator listIterator() {
            return this.listIterator(0);
        }

        public ListIterator listIterator(int index) {
            ListIterator iter = super.listIterator(index);
            return new ListIterator(this, iter){
                Object last;
                final /* synthetic */ StmtList this$1;
                private final /* synthetic */ ListIterator val$iter;
                {
                    this.this$1 = stmtList;
                    this.val$iter = listIterator;
                    this.last = null;
                }

                public boolean hasNext() {
                    return this.val$iter.hasNext();
                }

                public Object next() {
                    this.last = this.val$iter.next();
                    return this.last;
                }

                public boolean hasPrevious() {
                    return this.val$iter.hasPrevious();
                }

                public Object previous() {
                    this.last = this.val$iter.previous();
                    return this.last;
                }

                public int nextIndex() {
                    return this.val$iter.nextIndex();
                }

                public int previousIndex() {
                    return this.val$iter.previousIndex();
                }

                public void add(Object obj) {
                    Assert.isTrue(obj instanceof Stmt);
                    ((Stmt)obj).setParent(StmtList.access$0(this.this$1));
                    this.last = null;
                    this.val$iter.add(obj);
                }

                public void set(Object obj) {
                    if (this.last == null) {
                        throw new NoSuchElementException();
                    }
                    Assert.isTrue(obj instanceof Stmt);
                    ((Stmt)obj).setParent(StmtList.access$0(this.this$1));
                    ((Stmt)this.last).cleanup();
                    this.last = null;
                    this.val$iter.set(obj);
                }

                public void remove() {
                    if (this.last == null) {
                        throw new NoSuchElementException();
                    }
                    ((Stmt)this.last).cleanup();
                    this.last = null;
                    this.val$iter.remove();
                }
            };
        }

        public Iterator iterator() {
            Iterator iter = super.iterator();
            return new Iterator(this, iter){
                Object last;
                final /* synthetic */ StmtList this$1;
                private final /* synthetic */ Iterator val$iter;
                {
                    this.this$1 = stmtList;
                    this.val$iter = iterator;
                    this.last = null;
                }

                public boolean hasNext() {
                    return this.val$iter.hasNext();
                }

                public Object next() {
                    this.last = this.val$iter.next();
                    return this.last;
                }

                public void remove() {
                    if (this.last == null) {
                        throw new NoSuchElementException();
                    }
                    ((Stmt)this.last).cleanup();
                    this.last = null;
                    this.val$iter.remove();
                }
            };
        }

        static /* synthetic */ Tree access$0(StmtList stmtList) {
            return stmtList.Tree.this;
        }
    }
}

