/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.ExchangeRate;
import jgnash.engine.dao.CommodityDAO;

public class ExchangeRateDAO {
    private transient CommodityDAO commodityDAO;

    ExchangeRateDAO(CommodityDAO commodityDAO) {
        this.commodityDAO = commodityDAO;
    }

    public ExchangeRate getExchangeRateNode(CurrencyNode baseCurrency, CurrencyNode exchangeCurrency) {
        if (baseCurrency.equals(exchangeCurrency)) {
            return null;
        }
        String rateId = Engine.buildExchangeRateId(baseCurrency, exchangeCurrency);
        ExchangeRate node = this.commodityDAO.getExchangeNode(rateId);
        if (node == null) {
            node = new ExchangeRate(Engine.buildExchangeRateId(baseCurrency, exchangeCurrency));
            this.commodityDAO.addExchangeRate(node);
        }
        return node;
    }
}

