/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.util.List;
import java.util.prefs.Preferences;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;

public class ReconcileManager {
    private static final String RECONCILE_INCOMEEXPENSE = "reconcileIncomeExpense";
    private static final String RECONCILE_BOTHSIDES = "reconcileBothSides";
    private static boolean reconcileIncomeExpense;
    private static boolean reconcileBothSides;

    private ReconcileManager() {
    }

    public static void setAutoReconcileIncomeExpense(boolean reconcile) {
        reconcileIncomeExpense = reconcile;
        Preferences p = Preferences.userNodeForPackage(ReconcileManager.class);
        p.putBoolean(RECONCILE_INCOMEEXPENSE, reconcileIncomeExpense);
        if (reconcile) {
            ReconcileManager.setAutoReconcileBothSides(false);
        }
    }

    public static boolean getAutoReconcileIncomeExpense() {
        return reconcileIncomeExpense;
    }

    public static void setAutoReconcileBothSides(boolean reconcile) {
        reconcileBothSides = reconcile;
        Preferences p = Preferences.userNodeForPackage(ReconcileManager.class);
        p.putBoolean(RECONCILE_BOTHSIDES, reconcileBothSides);
        if (reconcile) {
            ReconcileManager.setAutoReconcileIncomeExpense(false);
        }
    }

    public static boolean getAutoReconcileBothSides() {
        return reconcileBothSides;
    }

    public static boolean isAutoReconcileDisabled() {
        return !reconcileBothSides && !reconcileIncomeExpense;
    }

    public static void setDoNotAutoReconcile() {
        ReconcileManager.setAutoReconcileBothSides(false);
        ReconcileManager.setAutoReconcileIncomeExpense(false);
    }

    public static void reconcileTransaction(Account account, Transaction t, ReconciledState reconciled) {
        t.setReconciled(account, reconciled);
        if (ReconcileManager.getAutoReconcileBothSides()) {
            t.setReconciled(reconciled);
        } else if (ReconcileManager.getAutoReconcileIncomeExpense()) {
            List<TransactionEntry> entries = t.getTransactionEntries();
            for (TransactionEntry entry : entries) {
                Account d;
                Account c = entry.getCreditAccount();
                if (c.instanceOf(AccountType.INCOME) || c.instanceOf(AccountType.EXPENSE)) {
                    entry.setCreditReconciled(ReconciledState.RECONCILED);
                }
                if (!(d = entry.getDebitAccount()).instanceOf(AccountType.INCOME) && !d.instanceOf(AccountType.EXPENSE)) continue;
                entry.setDebitReconciled(ReconciledState.RECONCILED);
            }
        }
    }

    public static void reconcileTransaction(Account account, Transaction t, boolean reconciled) {
        ReconcileManager.reconcileTransaction(account, t, reconciled ? ReconciledState.RECONCILED : ReconciledState.NOT_RECONCILED);
    }

    static {
        Preferences p = Preferences.userNodeForPackage(ReconcileManager.class);
        reconcileIncomeExpense = p.getBoolean(RECONCILE_INCOMEEXPENSE, false);
        reconcileBothSides = p.getBoolean(RECONCILE_BOTHSIDES, true);
    }
}

