/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.Date;
import jgnash.util.DateUtils;

public class SecurityHistoryNode
implements Comparable<SecurityHistoryNode> {
    private Date date = DateUtils.levelDate(new Date());
    private BigDecimal price = BigDecimal.ZERO;
    private BigDecimal high = BigDecimal.ZERO;
    private BigDecimal low = BigDecimal.ZERO;
    private long volume = 0L;

    public void setHigh(BigDecimal high) {
        if (high != null) {
            this.high = high;
        }
    }

    public void setLow(BigDecimal low) {
        if (low != null) {
            this.low = low;
        }
    }

    public void setVolume(long volume) {
        this.volume = volume;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public long getVolume() {
        return this.volume;
    }

    public void setDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Null assignment is not allowed");
        }
        this.date = DateUtils.levelDate(date);
    }

    public Date getDate() {
        return this.date;
    }

    public void setPrice(BigDecimal price) {
        if (price != null) {
            this.price = price;
        }
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    @Override
    public int compareTo(SecurityHistoryNode node) {
        return this.getDate().compareTo(node.getDate());
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SecurityHistoryNode && this.date.equals(((SecurityHistoryNode)other).date);
    }
}

