/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.recurring;

import java.util.Calendar;
import java.util.Date;
import jgnash.engine.recurring.RecurringIterator;
import jgnash.engine.recurring.Reminder;
import jgnash.engine.recurring.ReminderType;
import jgnash.util.DateUtils;

public class DailyReminder
extends Reminder {
    private static final long serialVersionUID = -6999664985694769498L;

    @Override
    public RecurringIterator getIterator() {
        return new DailyIterator();
    }

    @Override
    public ReminderType getReminderType() {
        return ReminderType.DAILY;
    }

    private class DailyIterator
    implements RecurringIterator {
        private Calendar calendar = Calendar.getInstance();

        public DailyIterator() {
            if (DailyReminder.this.getLastDate() != null) {
                this.calendar.setTime(DailyReminder.this.getLastDate());
            } else {
                this.calendar.setTime(DailyReminder.this.getStartDate());
                this.calendar.add(5, DailyReminder.this.getIncrement() * -1);
            }
        }

        @Override
        public Date next() {
            this.calendar.add(5, DailyReminder.this.getIncrement());
            Date date = this.calendar.getTime();
            if (DailyReminder.this.getEndDate() == null) {
                return date;
            }
            if (DateUtils.before(date, DailyReminder.this.getEndDate())) {
                return date;
            }
            return null;
        }
    }
}

