/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.SecurityNode;
import jgnash.ui.account.AccountListDialog;
import jgnash.ui.account.AccountSecuritiesDialog;
import jgnash.ui.components.CurrencyComboBox;
import jgnash.ui.components.JTextFieldEx;
import jgnash.util.Resource;

class AccountPanel
extends JPanel
implements ActionListener {
    private Resource rb = Resource.get();
    private Account parentAccount;
    private Set<SecurityNode> commodityList = new TreeSet<SecurityNode>();
    private CurrencyComboBox currencyCombo;
    private JTextFieldEx codeField;
    JCheckBox placeholderBox;
    private JTextFieldEx nameField;
    private JCheckBox lockedBox;
    private JButton parentButton;
    private JTextFieldEx descriptionField;
    private JButton securityButton;
    private JTextArea notesArea;
    private JCheckBox hideButton;
    private JComboBox accountTypeCombo;
    private DefaultComboBoxModel accountTypeModel;

    public AccountPanel() {
        Engine engine = EngineFactory.getEngine("default");
        this.layoutMainPanel();
        this.setAccountCurrency(engine.getDefaultCurrency());
        this.setAccountType(AccountType.BANK);
    }

    private void initComponents() {
        this.codeField = new JTextFieldEx();
        this.nameField = new JTextFieldEx();
        this.nameField.setText(this.rb.getString("Word.Name"));
        this.descriptionField = new JTextFieldEx();
        this.descriptionField.setText(this.rb.getString("Word.Description"));
        this.currencyCombo = new CurrencyComboBox();
        this.securityButton = new JButton(this.rb.getString("Word.None"));
        this.accountTypeModel = new DefaultComboBoxModel<Object>(AccountType.getAccountTypeSet().toArray());
        this.accountTypeCombo = new JComboBox(this.accountTypeModel);
        this.lockedBox = new JCheckBox(this.rb.getString("Button.Locked"));
        this.placeholderBox = new JCheckBox(this.rb.getString("Button.PlaceHolder"));
        this.hideButton = new JCheckBox(this.rb.getString("Button.HideAccount"));
        this.parentButton = new JButton("Root");
        this.notesArea = new JTextArea();
        this.notesArea.setLineWrap(true);
        this.notesArea.setAutoscrolls(false);
        this.notesArea.setPreferredSize(new Dimension(100, 80));
        this.accountTypeCombo.addActionListener(this);
        this.securityButton.addActionListener(this);
        this.parentButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("right:max(20dlu;pref), $lcgap, 100dlu:grow(1.0)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.AccountInfo"));
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.Name"), (Component)this.nameField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Description"), (Component)this.descriptionField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.AccountID"), (Component)this.codeField);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Currency"), (Component)this.currencyCombo);
        builder.nextLine();
        builder.append(this.rb.getString("Label.Securities"), (Component)this.securityButton);
        builder.nextLine();
        builder.append(this.rb.getString("Label.AccountType"), (Component)this.accountTypeCombo);
        builder.nextLine();
        builder.append(this.rb.getString("Label.AccountOptions"), (Component)this.lockedBox);
        builder.nextLine();
        builder.append("", (Component)this.placeholderBox);
        builder.nextLine();
        builder.append("", (Component)this.hideButton);
        builder.setRowGroupingEnabled(false);
        builder.appendSeparator(this.rb.getString("Title.ParentAccount"));
        builder.append((Component)this.parentButton, 3);
        builder.appendSeparator(this.rb.getString("Title.Notes"));
        JScrollPane pane = new JScrollPane(this.notesArea);
        pane.setAutoscrolls(true);
        builder.appendRow("f:60dlu:g(1.0)");
        builder.append((Component)pane, 3);
    }

    private void showAccountListDialog() {
        AccountListDialog dlg = new AccountListDialog(this.parentAccount);
        dlg.setLocationRelativeTo(this);
        dlg.setVisible(true);
        if (dlg.getReturnStatus()) {
            this.setParentAccount(dlg.getAccount());
        }
    }

    private void accountAction() {
        this.updateCommodityButton();
    }

    public void setParentAccount(Account parentAccount) {
        this.parentAccount = parentAccount;
        this.parentButton.setText(parentAccount.getName());
        this.setAccountCurrency(parentAccount.getCurrencyNode());
    }

    public Account getParentAccount() {
        return this.parentAccount;
    }

    public void setAccountName(String name) {
        this.nameField.setText(name);
    }

    public String getAccountName() {
        return this.nameField.getText();
    }

    public void setAccountCode(String code) {
        this.codeField.setText(code);
    }

    public void setAccountHidden(boolean hide) {
        this.hideButton.setSelected(hide);
    }

    public String getAccountCode() {
        return this.codeField.getText();
    }

    public void setAccountDescription(String description) {
        this.descriptionField.setText(description);
    }

    public String getAccountDescription() {
        return this.descriptionField.getText();
    }

    public void setAccountCurrency(CurrencyNode node) {
        this.currencyCombo.setSelectedNode(node);
    }

    public CurrencyNode getAccountCurrency() {
        return (CurrencyNode)this.currencyCombo.getSelectedNode();
    }

    protected void disableAccountCurrency() {
        this.currencyCombo.setEnabled(false);
    }

    public void setAccountNotes(String notes) {
        this.notesArea.setText(notes);
    }

    public String getAccountNotes() {
        return this.notesArea.getText();
    }

    public void setAccountLocked(boolean locked) {
        this.lockedBox.setSelected(locked);
    }

    public boolean isAccountLocked() {
        return this.lockedBox.isSelected();
    }

    public void setPlaceholder(boolean selected) {
        this.placeholderBox.setSelected(selected);
    }

    public boolean isPlaceholder() {
        return this.placeholderBox.isSelected();
    }

    public void setAccountType(AccountType type) {
        this.accountTypeCombo.setSelectedItem((Object)type);
        this.updateCommodityButton();
    }

    public AccountType getAccountType() {
        return (AccountType)((Object)this.accountTypeCombo.getSelectedItem());
    }

    public boolean isAccountHidden() {
        return this.hideButton.isSelected();
    }

    public void setAccountSecurities(Set<SecurityNode> list) {
        this.commodityList.clear();
        this.commodityList.addAll(list);
    }

    public Set<SecurityNode> getAccountSecurities() {
        return this.commodityList;
    }

    private void showSecuritiesDialog() {
        AccountSecuritiesDialog dlg = new AccountSecuritiesDialog(null, this.commodityList, this);
        dlg.setLocationRelativeTo(null);
        dlg.setVisible(true);
        if (dlg.getReturnValue()) {
            this.commodityList = dlg.getSecuritiesList();
        }
        this.updateCommodityText();
    }

    private void updateCommodityButton() {
        AccountType type = this.getAccountType();
        if (type == AccountType.INVEST || type == AccountType.MUTUAL) {
            this.securityButton.setEnabled(true);
            this.updateCommodityText();
        } else {
            this.securityButton.setEnabled(false);
        }
    }

    private void updateCommodityText() {
        if (!this.commodityList.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            Iterator<SecurityNode> it = this.commodityList.iterator();
            SecurityNode node = it.next();
            buf.append(node.getSymbol());
            while (it.hasNext()) {
                buf.append(", ");
                node = it.next();
                buf.append(node.getSymbol());
            }
            this.securityButton.setText(buf.toString());
            this.securityButton.setToolTipText(buf.toString());
        } else {
            this.securityButton.setText(this.rb.getString("Word.None"));
        }
    }

    protected void disableAccountType(AccountType type) {
        if (type.isMutable()) {
            for (AccountType t : AccountType.values()) {
                if (t.isMutable()) continue;
                this.accountTypeModel.removeElement((Object)t);
            }
        } else {
            this.accountTypeCombo.setSelectedItem((Object)type);
            this.accountTypeCombo.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.accountTypeCombo) {
            this.accountAction();
        } else if (e.getSource() == this.securityButton) {
            this.showSecuritiesDialog();
        } else if (e.getSource() == this.parentButton) {
            this.showAccountListDialog();
        }
    }
}

