/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.ui.account.AccountListFilterDialog;
import jgnash.ui.account.AccountTools;
import jgnash.ui.account.ExpandingAccountTablePane;
import jgnash.ui.components.RollOverButton;
import jgnash.ui.register.RegisterFrame;
import jgnash.util.Resource;

public class ExpandingAccountTablePanel
extends JPanel
implements ActionListener,
MessageListener {
    private Resource rb = Resource.get();
    private ExpandingAccountTablePane accountPane;
    private JButton deleteButton;
    private JButton filterButton;
    private JButton modifyButton;
    private JButton newButton;
    private JButton reconcileButton;
    private JButton zoomButton;
    private AccountPopup popup;

    public ExpandingAccountTablePanel() {
        this.initComponents();
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
        this.deleteButton.addActionListener(this);
        this.filterButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.reconcileButton.addActionListener(this);
        this.zoomButton.addActionListener(this);
        this.popup = new AccountPopup();
        this.accountPane.accountTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ExpandingAccountTablePanel.this.updateToolBarState(ExpandingAccountTablePanel.this.accountPane.getSelectedAccount(e.getPoint()));
                ExpandingAccountTablePanel.this.checkForDoubleClick(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ExpandingAccountTablePanel.this.checkForPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ExpandingAccountTablePanel.this.checkForPopup(e);
            }
        });
        if (ExpandingAccountTablePanel.getEngine() == null || ExpandingAccountTablePanel.getEngine().getRootAccount() == null) {
            this.enableButtons(false);
        }
        Logger log = Logger.getLogger(ExpandingAccountTablePanel.class.getName());
        log.fine("AccountListPanel construction complete");
    }

    private static Engine getEngine() {
        return EngineFactory.getEngine("default");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.modifyButton) {
            this.modifyAccount();
        } else if (e.getSource() == this.newButton) {
            this.createAccount();
        } else if (e.getSource() == this.deleteButton) {
            this.deleteAccount();
        } else if (e.getSource() == this.reconcileButton) {
            this.accountPane.reconcileAccount();
        } else if (e.getSource() == this.filterButton) {
            this.showAccountFilterDialog();
        } else if (e.getSource() == this.zoomButton) {
            this.zoomAction();
        }
    }

    private void checkForDoubleClick(MouseEvent e) {
        if (e.getClickCount() >= 2) {
            final Account account = this.accountPane.getSelectedAccount(e.getPoint());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (account != null && !account.isPlaceHolder()) {
                        RegisterFrame.showDialog(account);
                    }
                }
            });
        }
    }

    private void checkForPopup(MouseEvent e) {
        Account selectedAccount;
        if (e.isPopupTrigger() && (selectedAccount = this.accountPane.getSelectedAccount(e.getPoint())) != null) {
            this.accountPane.setSelectedAccount(selectedAccount);
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void createAccount() {
        if (ExpandingAccountTablePanel.getEngine().getRootAccount() != null) {
            AccountTools.createAccount(this.accountPane.getSelectedAccount());
        }
    }

    private void deleteAccount() {
        Account account;
        if (ExpandingAccountTablePanel.getEngine().getRootAccount() != null && (account = this.getSelectedAccount()) != null) {
            ExpandingAccountTablePanel.getEngine().removeAccount(account);
        }
    }

    private void enableButtons(final boolean e) {
        final JButton[] list = new JButton[]{this.newButton, this.modifyButton, this.reconcileButton, this.deleteButton, this.filterButton, this.zoomButton};
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (JButton button : list) {
                    button.setEnabled(e);
                }
            }
        });
    }

    public Account getSelectedAccount() {
        return this.accountPane.getSelectedAccount();
    }

    private void initComponents() {
        this.accountPane = new ExpandingAccountTablePane();
        JPanel toolPanel = new JPanel();
        JToolBar toolBar = new JToolBar();
        this.setLayout(new BorderLayout());
        toolPanel.setLayout(new BorderLayout());
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.newButton = new RollOverButton(this.rb.getString("Button.New"), Resource.getIcon("/jgnash/resource/document-new.png"));
        this.newButton.setToolTipText(this.rb.getString("ToolTip.NewAccount"));
        toolBar.add(this.newButton);
        this.modifyButton = new RollOverButton(this.rb.getString("Button.Modify"), Resource.getIcon("/jgnash/resource/document-properties.png"));
        this.modifyButton.setToolTipText(this.rb.getString("ToolTip.ModifyAccount"));
        toolBar.add(this.modifyButton);
        this.reconcileButton = new RollOverButton(this.rb.getString("Button.Reconcile"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.reconcileButton.setToolTipText(this.rb.getString("ToolTip.ReconcileAccount"));
        toolBar.add(this.reconcileButton);
        this.deleteButton = new RollOverButton(this.rb.getString("Button.Delete"), Resource.getIcon("/jgnash/resource/edit-delete.png"));
        this.deleteButton.setToolTipText(this.rb.getString("ToolTip.DeleteAccount"));
        toolBar.add(this.deleteButton);
        this.filterButton = new RollOverButton(this.rb.getString("Button.Filter"), Resource.getIcon("/jgnash/resource/preferences-system.png"));
        this.filterButton.setToolTipText(this.rb.getString("ToolTip.FilterAccount"));
        toolBar.add(this.filterButton);
        this.zoomButton = new RollOverButton(this.rb.getString("Button.Zoom"), Resource.getIcon("/jgnash/resource/edit-find.png"));
        toolBar.add(this.zoomButton);
        toolPanel.add((Component)toolBar, "North");
        toolPanel.add((Component)new JSeparator(), "Center");
        this.add((Component)toolPanel, "North");
        this.accountPane.setBorder(new EmptyBorder(new Insets(0, 0, 0, 0)));
        this.accountPane.setMinimumSize(new Dimension(200, 100));
        this.accountPane.setAutoscrolls(true);
        this.add((Component)this.accountPane, "Center");
    }

    @Override
    public void messagePosted(Message event) {
        if (event.getEvent() == ChannelEvent.FILE_NEW_SUCCESS) {
            this.enableButtons(true);
        } else if (event.getEvent() == ChannelEvent.FILE_LOAD_SUCCESS) {
            this.enableButtons(true);
        } else if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
            this.enableButtons(false);
        }
    }

    private void modifyAccount() {
        Account account;
        if (ExpandingAccountTablePanel.getEngine().getRootAccount() != null && (account = this.getSelectedAccount()) != null) {
            AccountTools.modifyAccount(account);
        }
    }

    public void showAccountFilterDialog() {
        AccountListFilterDialog dlg = new AccountListFilterDialog(this.accountPane.model);
        dlg.setVisible(true);
    }

    void toggleAccountVisibility() {
        if (this.getSelectedAccount() != null) {
            ExpandingAccountTablePanel.getEngine().toggleAccountVisibility(this.accountPane.getSelectedAccount());
        }
    }

    private void updateToolBarState(Account account) {
        if (account != null) {
            int count = account.getTransactionCount();
            this.deleteButton.setEnabled(count == 0 && account.getChildCount() == 0);
            this.reconcileButton.setEnabled(count > 0);
        }
    }

    private void zoomAction() {
        Account account;
        if (ExpandingAccountTablePanel.getEngine().getRootAccount() != null && (account = this.getSelectedAccount()) != null) {
            RegisterFrame.showDialog(account);
        }
    }

    private class AccountPopup
    extends JPopupMenu
    implements ActionListener {
        JMenuItem menuVisible;
        JMenuItem reconcile;
        JMenuItem delete;
        private static final String MODIFY = "mod";
        private static final String NEW = "new";

        public AccountPopup() {
            JMenuItem menuItem = new JMenuItem(ExpandingAccountTablePanel.this.rb.getString("Menu.New.Name"));
            menuItem.setActionCommand(NEW);
            menuItem.addActionListener(this);
            this.add(menuItem);
            menuItem = new JMenuItem(ExpandingAccountTablePanel.this.rb.getString("Menu.Modify.Name"));
            menuItem.setActionCommand(MODIFY);
            menuItem.addActionListener(this);
            this.add(menuItem);
            this.delete = new JMenuItem(ExpandingAccountTablePanel.this.rb.getString("Menu.Delete.Name"));
            this.delete.addActionListener(this);
            this.add(this.delete);
            this.addSeparator();
            this.menuVisible = new JMenuItem(ExpandingAccountTablePanel.this.rb.getString("Menu.Hide.Name"));
            this.menuVisible.addActionListener(this);
            this.add(this.menuVisible);
            this.addSeparator();
            this.reconcile = new JMenuItem(ExpandingAccountTablePanel.this.rb.getString("Menu.Reconcile.Name"));
            this.reconcile.addActionListener(this);
            this.add(this.reconcile);
        }

        @Override
        public void actionPerformed(final ActionEvent actionEvent) {
            final String command = actionEvent.getActionCommand();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (command.equals(AccountPopup.NEW)) {
                        ExpandingAccountTablePanel.this.createAccount();
                    } else if (actionEvent.getSource() == AccountPopup.this.delete) {
                        ExpandingAccountTablePanel.this.deleteAccount();
                    } else if (command.equals(AccountPopup.MODIFY)) {
                        ExpandingAccountTablePanel.this.modifyAccount();
                    } else if (actionEvent.getSource() == AccountPopup.this.menuVisible) {
                        ExpandingAccountTablePanel.this.toggleAccountVisibility();
                    } else if (actionEvent.getSource() == AccountPopup.this.reconcile) {
                        ExpandingAccountTablePanel.this.accountPane.reconcileAccount();
                    }
                }
            });
        }

        @Override
        public void show(Component invoker, int x, int y) {
            Account acc = ExpandingAccountTablePanel.this.accountPane.getSelectedAccount();
            if (acc != null) {
                if (acc.isVisible()) {
                    this.menuVisible.setText(ExpandingAccountTablePanel.this.rb.getString("Menu.Hide.Name"));
                } else {
                    this.menuVisible.setText(ExpandingAccountTablePanel.this.rb.getString("Menu.Show.Name"));
                }
                int count = acc.getTransactionCount();
                this.delete.setEnabled(count == 0 && acc.getChildCount() == 0);
                this.reconcile.setEnabled(count > 0);
            }
            super.show(invoker, x, y);
        }
    }
}

