/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.commodity;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import jgnash.engine.SecurityNode;
import jgnash.text.CommodityFormat;
import jgnash.util.Resource;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;

public class SecurityItemLabelGenerator
implements XYToolTipGenerator {
    private DateFormat dateFormatter;
    private NumberFormat numberFormatter;
    private String dateLabel;
    private String closeLabel;

    public SecurityItemLabelGenerator(SecurityNode node) {
        this(DateFormat.getDateInstance(3), CommodityFormat.getShortNumberFormat(node.getReportedCurrencyNode()));
    }

    private SecurityItemLabelGenerator(DateFormat dateFormatter, NumberFormat numberFormatter) {
        if (dateFormatter == null) {
            throw new IllegalArgumentException("Null 'dateFormatter' argument.");
        }
        if (numberFormatter == null) {
            throw new IllegalArgumentException("Null 'numberFormatter' argument.");
        }
        this.dateFormatter = dateFormatter;
        this.numberFormatter = numberFormatter;
        Resource rb = Resource.get();
        this.dateLabel = rb.getString("Label.Date");
        this.closeLabel = rb.getString("Label.Close");
    }

    public String generateToolTip(XYDataset dataset, int series, int item) {
        String result = null;
        if (dataset instanceof OHLCDataset) {
            OHLCDataset d = (OHLCDataset)dataset;
            Number close = d.getClose(series, item);
            Number x = d.getX(series, item);
            if (x != null) {
                Date date = new Date(x.longValue());
                result = this.dateLabel + " " + this.dateFormatter.format(date);
                if (close != null) {
                    result = result + " " + this.closeLabel + "  " + this.numberFormatter.format(close.doubleValue());
                }
            }
        }
        return result;
    }
}

