/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jgnash.ui.actions.DatabasePathAction;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class OpenDatabaseDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private JTextField nameField = new JTextFieldEx();
    private JPasswordField passwordField = new JPasswordField();
    private JTextField hostField = new JTextFieldEx();
    private JLabel fileFieldLabel = new JLabel(this.rb.getString("Label.DatabaseName"));
    private JTextField fileField = new JTextFieldEx();
    private JCheckBox passwordBox = null;
    private JButton fileButton = new JButton("...");
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox remoteButton = null;
    private JIntegerField portField = new JIntegerField();
    private boolean result = false;

    public OpenDatabaseDialog(JFrame parent) {
        super((Frame)parent, true);
        this.setTitle(this.rb.getString("Title.Open"));
        this.layoutMainPanel();
        this.setMinimumSize(this.getSize());
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(parent);
        DialogUtils.addBoundsListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.fileButton) {
            String file = DatabasePathAction.databaseNameAction(this, DatabasePathAction.Type.OPEN);
            if (file.length() > 0) {
                this.fileField.setText(file);
            }
        } else if (e.getSource() == this.remoteButton) {
            this.updateForm();
        } else if (e.getSource() == this.cancelButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.okButton) {
            this.result = true;
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    public String getDatabasePath() {
        return this.fileField.getText();
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public boolean getResult() {
        return this.result;
    }

    public String getHost() {
        return this.hostField.getText();
    }

    public void setHost(String host) {
        this.hostField.setText(host);
    }

    public void setPort(int port) {
        this.portField.setIntValue(port);
    }

    public String getUserName() {
        return this.nameField.getText();
    }

    public boolean isRemote() {
        return this.remoteButton.isSelected();
    }

    public int getPort() {
        return this.portField.intValue();
    }

    private void initComponents() {
        this.passwordBox = new JCheckBox(this.rb.getString("Button.RememberPassword"));
        this.remoteButton = new JCheckBox(this.rb.getString("Button.RemoteServer"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.fileButton.addActionListener(this);
        this.remoteButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 4dlu, fill:70dlu:g, 1dlu, d", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.fileFieldLabel, (Component)this.fileField, (Component)this.fileButton);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.remoteButton, 4);
        builder.append(this.rb.getString("Label.DatabaseServer"), (Component)this.hostField, 3);
        builder.append(this.rb.getString("Label.Port"), (Component)this.portField, 3);
        builder.append(this.rb.getString("Label.UserName"), (Component)this.nameField, 3);
        builder.append(this.rb.getString("Label.Password"), (Component)this.passwordField, 3);
        builder.append((Component)this.passwordBox, 4);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 5);
        this.getContentPane().add(builder.getPanel());
        this.updateForm();
        this.nameField.setEnabled(false);
        this.passwordField.setEnabled(false);
        this.pack();
    }

    public boolean savePassword() {
        return this.passwordBox.isSelected();
    }

    public void setDatabasePath(String dataBase) {
        this.fileField.setText(dataBase);
    }

    public void setUserName(String userName) {
        this.nameField.setText(userName);
    }

    public void setPassword(String password) {
        this.passwordField.setText(password);
    }

    public void setRemote(boolean remote) {
        this.remoteButton.setSelected(remote);
        this.updateForm();
    }

    private void updateForm() {
        boolean remote = this.remoteButton.isSelected();
        this.fileField.setEnabled(!remote);
        this.fileButton.setEnabled(!remote);
        this.hostField.setEnabled(remote);
        this.portField.setEnabled(remote);
        this.nameField.setEnabled(remote);
        this.passwordField.setEnabled(remote);
        this.passwordBox.setEnabled(remote);
    }
}

