/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.option;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jgnash.engine.ReconcileManager;
import jgnash.ui.MainFrame;
import jgnash.ui.ThemeManager;
import jgnash.ui.UIApplication;
import jgnash.ui.components.AutoCompleteFactory;
import jgnash.ui.register.AbstractTransactionPanel;
import jgnash.ui.register.RegisterFactory;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXColorSelectionButton;

class RegisterOptions
extends JPanel
implements ActionListener {
    private final Resource rb = Resource.get();
    private JButton evenButton;
    private JCheckBox registerFollowsCheckBox;
    private JCheckBox autoCompleteCheckBox;
    private JCheckBox sortableCheckBox;
    private JCheckBox useAccountTermsCheckBox;
    private JCheckBox regDateCheckBox;
    private JCheckBox confirmTransDeleteCheckBox;
    private JButton oddButton;
    private JRadioButton autoReconcileBothSidesButton;
    private JRadioButton autoReconcileIncomeExpenseButton;
    private JRadioButton disableAutoReconcileButton;

    public RegisterOptions() {
        this.layoutMainPanel();
        this.evenButton.setBackground(RegisterFactory.getEvenColor());
        this.oddButton.setBackground(RegisterFactory.getOddColor());
        this.autoCompleteCheckBox.setSelected(AutoCompleteFactory.isEnabled());
        this.confirmTransDeleteCheckBox.setSelected(RegisterFactory.isConfirmTransactionDeleteEnabled());
        this.sortableCheckBox.setSelected(RegisterFactory.isSortingEnabled());
        this.registerFollowsCheckBox.setSelected(MainFrame.doesRegisterFollowTree());
        this.useAccountTermsCheckBox.setSelected(RegisterFactory.isAccountingTermsEnabled());
        this.regDateCheckBox.setSelected(AbstractTransactionPanel.getRememberLastDate());
        if (ReconcileManager.getAutoReconcileBothSides()) {
            this.autoReconcileBothSidesButton.setSelected(true);
        } else if (ReconcileManager.getAutoReconcileIncomeExpense()) {
            this.autoReconcileIncomeExpenseButton.setSelected(true);
        } else if (ReconcileManager.isAutoReconcileDisabled()) {
            this.disableAutoReconcileButton.setSelected(true);
        }
        this.autoCompleteCheckBox.addActionListener(this);
        this.confirmTransDeleteCheckBox.addActionListener(this);
        this.sortableCheckBox.addActionListener(this);
        this.registerFollowsCheckBox.addActionListener(this);
        this.useAccountTermsCheckBox.addActionListener(this);
        this.regDateCheckBox.addActionListener(this);
        this.disableAutoReconcileButton.addActionListener(this);
        this.autoReconcileBothSidesButton.addActionListener(this);
        this.autoReconcileIncomeExpenseButton.addActionListener(this);
        this.oddButton.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RegisterFactory.setOddColor(RegisterOptions.this.oddButton.getBackground());
                RegisterOptions.this.oddButton.setToolTipText(RegisterOptions.buildColorString(RegisterOptions.this.oddButton.getBackground()));
                if (!ThemeManager.isLookAndFeelSubstance()) {
                    UIApplication.repaint();
                }
            }
        });
        this.evenButton.addPropertyChangeListener("background", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                RegisterFactory.setEvenColor(RegisterOptions.this.evenButton.getBackground());
                RegisterOptions.this.evenButton.setToolTipText(RegisterOptions.buildColorString(RegisterOptions.this.evenButton.getBackground()));
                if (!ThemeManager.isLookAndFeelSubstance()) {
                    UIApplication.repaint();
                }
            }
        });
    }

    private void initComponents() {
        this.evenButton = new JXColorSelectionButton();
        this.oddButton = new JXColorSelectionButton();
        this.autoCompleteCheckBox = new JCheckBox(this.rb.getString("Button.EnableAutoComplete"));
        this.confirmTransDeleteCheckBox = new JCheckBox(this.rb.getString("Button.ConfirmTransDelete"));
        this.sortableCheckBox = new JCheckBox(this.rb.getString("Button.EnableSortCol"));
        this.registerFollowsCheckBox = new JCheckBox(this.rb.getString("Button.RegisterFollowsList"));
        this.useAccountTermsCheckBox = new JCheckBox(this.rb.getString("Button.AccTerms"));
        this.regDateCheckBox = new JCheckBox(this.rb.getString("Button.RegDate"));
        this.autoReconcileIncomeExpenseButton = new JRadioButton(this.rb.getString("Button.ReconcileIncomeExpense"));
        this.autoReconcileBothSidesButton = new JRadioButton(this.rb.getString("Button.ReconcileBoth"));
        this.disableAutoReconcileButton = new JRadioButton(this.rb.getString("Button.ReconcileDisable"));
        ButtonGroup g = new ButtonGroup();
        g.add(this.autoReconcileIncomeExpenseButton);
        g.add(this.autoReconcileBothSidesButton);
        g.add(this.disableAutoReconcileButton);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.Colors"));
        builder.append((Component)this.buildColorPanel());
        builder.appendSeparator(this.rb.getString("Title.DefaultBehavior"));
        builder.append((Component)this.sortableCheckBox);
        builder.append((Component)this.registerFollowsCheckBox);
        builder.append((Component)this.autoCompleteCheckBox);
        builder.append((Component)this.useAccountTermsCheckBox);
        builder.append((Component)this.regDateCheckBox);
        builder.append((Component)this.confirmTransDeleteCheckBox);
        builder.appendSeparator(this.rb.getString("Title.ReconcileSettings"));
        builder.append((Component)this.disableAutoReconcileButton);
        builder.append((Component)this.autoReconcileBothSidesButton);
        builder.append((Component)this.autoReconcileIncomeExpenseButton);
    }

    private JPanel buildColorPanel() {
        FormLayout layout = new FormLayout("p, $lcgap, p, 8dlu, p, $lcgap, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append(this.rb.getString("Label.EvenRows"), (Component)this.evenButton);
        builder.append(this.rb.getString("Label.OddRows"), (Component)this.oddButton);
        return builder.getPanel();
    }

    private static String buildColorString(Color c) {
        StringBuilder buf = new StringBuilder("[");
        buf.append(c.getRed());
        buf.append(",");
        buf.append(c.getGreen());
        buf.append(",");
        buf.append(c.getBlue());
        buf.append("]");
        return buf.toString();
    }

    private void registerFollowsAccountListAction() {
        MainFrame.setRegisterFollowsTree(this.registerFollowsCheckBox.isSelected());
    }

    private void reconcileAction() {
        if (this.disableAutoReconcileButton.isSelected()) {
            ReconcileManager.setDoNotAutoReconcile();
        } else if (this.autoReconcileBothSidesButton.isSelected()) {
            ReconcileManager.setAutoReconcileBothSides(true);
        } else {
            ReconcileManager.setAutoReconcileIncomeExpense(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sortableCheckBox) {
            RegisterFactory.setSortingEnabled(this.sortableCheckBox.isSelected());
        } else if (e.getSource() == this.autoCompleteCheckBox) {
            AutoCompleteFactory.setEnabled(this.autoCompleteCheckBox.isSelected());
        } else if (e.getSource() == this.disableAutoReconcileButton || e.getSource() == this.autoReconcileBothSidesButton || e.getSource() == this.autoReconcileIncomeExpenseButton) {
            this.reconcileAction();
        } else if (e.getSource() == this.registerFollowsCheckBox) {
            this.registerFollowsAccountListAction();
        } else if (e.getSource() == this.useAccountTermsCheckBox) {
            RegisterFactory.setAccountingTermsEnabled(this.useAccountTermsCheckBox.isSelected());
        } else if (e.getSource() == this.regDateCheckBox) {
            AbstractTransactionPanel.setRememberLastDate(this.regDateCheckBox.isSelected());
        } else if (e.getSource() == this.confirmTransDeleteCheckBox) {
            RegisterFactory.setConfirmTransactionDeleteEnabled(this.confirmTransDeleteCheckBox.isSelected());
        }
    }
}

