/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.recurring;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.recurring.PendingReminder;
import jgnash.engine.recurring.Reminder;
import jgnash.ui.UIApplication;
import jgnash.ui.components.ColoredDateTableCellRenderer;
import jgnash.ui.components.ColoredTableCellRenderer;
import jgnash.ui.components.TimePeriodCombo;
import jgnash.ui.recurring.ReminderObjectTableModel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

class NotificationDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private final Resource rb = Resource.get();
    private JButton cancelButton;
    private JButton okButton;
    private TimePeriodCombo periodCombo = new TimePeriodCombo();
    private ReminderObjectTableModel model;
    private JTable table;
    private List<PendingReminder> reminders;

    protected static int showDialog(List<PendingReminder> reminders, int snoozeTime) {
        NotificationDialog d = new NotificationDialog(reminders);
        d.setSnoozeTime(snoozeTime);
        d.setVisible(true);
        d.toFront();
        return d.getSnoozeTime();
    }

    private NotificationDialog(List<PendingReminder> reminders) {
        super((Frame)UIApplication.getFrame(), true);
        this.reminders = reminders;
        this.model = new ReminderObjectTableModel(reminders);
        this.setTitle(this.rb.getString("Title.Reminder"));
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        this.setLocationRelativeTo(UIApplication.getFrame());
        DialogUtils.addBoundsListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
    }

    private int getSnoozeTime() {
        return this.periodCombo.getSelectedPeriod();
    }

    private void setSnoozeTime(final int snooze) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationDialog.this.periodCombo.setSelectedPeriod(snooze);
            }
        });
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:p, 4dlu, fill:p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        this.cancelButton = new JButton(this.rb.getString("Button.RemindLater"));
        this.okButton = new JButton(this.rb.getString("Button.AckSel"));
        this.table = new JTable(this.model);
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new ColoredTableCellRenderer()));
        this.table.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new ColoredDateTableCellRenderer()));
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setColumnSelectionAllowed(false);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.setAutoscrolls(true);
        builder.appendRow(RowSpec.decode((String)"fill:80dlu:g"));
        builder.append((Component)scrollPane, 3);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.RemindLater"), (Component)this.periodCombo);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add(builder.getPanel());
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.okButton) {
            for (PendingReminder pending : this.reminders) {
                if (!pending.isSelected()) continue;
                Reminder reminder = pending.getReminder();
                if (reminder.getTransaction() != null) {
                    Transaction t = reminder.getTransaction();
                    t.setDate(pending.getCommitDate());
                    EngineFactory.getEngine("default").addTransaction(t);
                }
                reminder.setLastDate();
                EngineFactory.getEngine("default").updateReminder(reminder);
            }
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int selectedRow;
        if (!e.getValueIsAdjusting() && e.getSource() == this.table.getSelectionModel() && (selectedRow = this.table.getSelectedRow()) >= 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotificationDialog.this.model.toggleSelectedState(NotificationDialog.this.table.convertRowIndexToModel(selectedRow));
                    NotificationDialog.this.table.clearSelection();
                }
            });
        }
    }
}

