/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.ui.UIApplication;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.register.TransactionPanel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class EditTransactionDialog
extends JDialog
implements RegisterListener {
    private final TransactionPanel transPanel;

    protected EditTransactionDialog(Account a, PanelType transType) {
        super((Frame)UIApplication.getFrame(), true);
        Resource rb = Resource.get();
        this.setTitle(rb.getString("Title.NewTrans") + " " + a.getPathName());
        this.transPanel = new TransactionPanel(a, transType);
        this.transPanel.addRegisterListener(this);
        this.layoutMainPanel();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditTransactionDialog.this.closeDialog();
            }
        });
        DialogUtils.addBoundsListener(this);
    }

    void closeDialog() {
        this.transPanel.removeRegisterListener(this);
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void layoutMainPanel() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.transPanel, "Center");
        this.pack();
    }

    protected void newTransaction(Transaction t) {
        this.transPanel.newTransaction(t);
        this.transPanel.setAutoComplete(false);
    }

    @Override
    public void registerEvent(RegisterEvent e) {
        if (e.getAction() == RegisterEvent.Action.CANCEL) {
            this.closeDialog();
        } else if (e.getAction() == RegisterEvent.Action.OK) {
            this.closeDialog();
        }
    }
}

