/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionType;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.ShadowBorder;
import jgnash.ui.register.AbstractEntryFormPanel;
import jgnash.ui.register.AbstractRegisterPanel;
import jgnash.ui.register.AdjustmentPanel;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.register.TransactionPanel;
import jgnash.ui.register.TransferPanel;
import jgnash.ui.register.invest.InvestmentTransactionDialog;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.RegisterTable;

public class RegisterPanel
extends AbstractRegisterPanel
implements ActionListener,
RegisterListener {
    private NumberFormat format;
    Account account;
    private AbstractRegisterTableModel model;
    private RegisterTable table;
    private TransactionPanel debitPanel;
    private TransactionPanel creditPanel;
    private TransferPanel transferPanel;
    private AdjustmentPanel adjustPanel;
    JButton newButton;
    JButton deleteButton;
    JButton jumpButton;
    private JLabel accountPath;
    private JTabbedPane tabbedPane;
    private JLabel accountBalance;
    private JLabel reconciledBalance;
    private JPanel buttonPanel;
    JButton duplicateButton;

    protected RegisterPanel(Account account) {
        this.account = account;
        this.format = CommodityFormat.getFullNumberFormat(account.getCurrencyNode());
        this.table = RegisterFactory.generateTable(account);
        this.model = (AbstractRegisterTableModel)this.table.getModel();
        this.layoutMainPanel();
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
        this.deleteButton.addActionListener(this);
        this.duplicateButton.addActionListener(this);
        this.jumpButton.addActionListener(this);
        this.newButton.addActionListener(this);
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION);
        this.debitPanel = new TransactionPanel(account, PanelType.DECREASE);
        this.creditPanel = new TransactionPanel(account, PanelType.INCREASE);
        this.transferPanel = new TransferPanel(account);
        this.adjustPanel = new AdjustmentPanel(account);
        this.debitPanel.addRegisterListener(this);
        this.creditPanel.addRegisterListener(this);
        this.transferPanel.addRegisterListener(this);
        this.adjustPanel.addRegisterListener(this);
        String[] tabNames = RegisterFactory.getCreditDebitTabNames(account);
        this.tabbedPane.add(tabNames[0], this.creditPanel);
        this.tabbedPane.add(tabNames[1], this.debitPanel);
        this.tabbedPane.add(this.rb.getString("Tab.Transfer"), this.transferPanel);
        this.tabbedPane.add(this.rb.getString("Tab.Adjust"), this.adjustPanel);
        if (account.getAccountType() == AccountType.CHECKING || account.getAccountType() == AccountType.CREDIT) {
            this.tabbedPane.setSelectedComponent(this.debitPanel);
        }
        this.table.addKeyListener(this);
        this.installPopupHandler();
        this.updateAccountState();
        this.updateAccountInfo();
    }

    void initComponents() {
        this.newButton = new JButton(this.rb.getString("Button.New"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.duplicateButton = new JButton(this.rb.getString("Button.Duplicate"));
        this.jumpButton = new JButton(this.rb.getString("Button.Jump"));
        this.tabbedPane = new JTabbedPane();
        this.accountPath = new JLabel(this.rb.getString("Label.Path"));
        this.accountBalance = new JLabel("0.00");
        this.reconciledBalance = new JLabel("0.00");
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.createTopPanel());
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow("fill:60dlu:g");
        JScrollPane s = new JScrollPane(this.table);
        s.setBorder(new ShadowBorder());
        builder.append((Component)s);
        this.buttonPanel = this.createButtonPanel();
        builder.append((Component)this.buttonPanel);
        builder.append((Component)this.tabbedPane);
    }

    private JPanel createTopPanel() {
        FormLayout layout = new FormLayout("45dlu:g, 4dlu, p, 4dlu, right:p, 12dlu, p, 4dlu, right:p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.accountPath, (Component)new JLabel(this.rb.getString("Label.Balance")), (Component)this.accountBalance);
        builder.append((Component)new JLabel(this.rb.getString("Label.ReconciledBalance")), (Component)this.reconciledBalance);
        return builder.getPanel();
    }

    JPanel createButtonPanel() {
        return ButtonBarFactory.buildLeftAlignedBar((JButton)this.newButton, (JButton)this.duplicateButton, (JButton)this.jumpButton, (JButton)this.deleteButton);
    }

    @Override
    public AbstractRegisterTableModel getTableModel() {
        return this.model;
    }

    @Override
    public RegisterTable getTable() {
        return this.table;
    }

    private void updateAccountInfo() {
        this.accountPath.setText(this.account.getName());
        this.accountPath.setToolTipText(this.getAccountPath());
        this.accountBalance.setText(this.format.format(this.getAccountBalance()));
        this.reconciledBalance.setText(this.format.format(this.account.getReconciledBalance()));
    }

    public int getAccountID() {
        return this.account.hashCode();
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    private BigDecimal getAccountBalance() {
        return this.account.getBalance();
    }

    @Override
    protected void modifyTransaction(int index) {
        if (index >= this.model.getRowCount()) {
            System.out.println("RegisterPanel: should not have exceeded model size");
            return;
        }
        Transaction t = this.model.getTransactionAt(index);
        if (t instanceof InvestmentTransaction) {
            ((AbstractEntryFormPanel)this.tabbedPane.getSelectedComponent()).clearForm();
            InvestmentTransactionDialog.showDialog((InvestmentTransaction)t);
            return;
        }
        if (t.getTransactionType() == TransactionType.SINGLENTRY) {
            this.tabbedPane.setSelectedComponent(this.adjustPanel);
            this.adjustPanel.modifyTransaction(t);
        } else if (t.getAmount(this.account).signum() >= 0) {
            this.tabbedPane.setSelectedComponent(this.creditPanel);
            this.creditPanel.modifyTransaction(t);
        } else {
            this.tabbedPane.setSelectedComponent(this.debitPanel);
            this.debitPanel.modifyTransaction(t);
        }
    }

    @Override
    protected void clear() {
        this.debitPanel.clearForm();
        this.creditPanel.clearForm();
        this.transferPanel.clearForm();
        this.adjustPanel.clearForm();
        this.table.clearSelection();
    }

    private void autoScroll() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle cell = RegisterPanel.this.table.getCellRect(RegisterPanel.this.table.getRowCount() - 1, 0, true);
                RegisterPanel.this.table.scrollRectToVisible(cell);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            this.deleteAction();
        } else if (e.getSource() == this.newButton) {
            this.clear();
        } else if (e.getSource() == this.duplicateButton) {
            this.duplicateAction();
        } else if (e.getSource() == this.jumpButton) {
            this.jumpAction();
        }
    }

    @Override
    public void registerEvent(RegisterEvent e) {
        if (e.getAction() == RegisterEvent.Action.CANCEL) {
            this.table.clearSelection();
        }
    }

    private void updateAccountState() {
        this.buttonPanel.setVisible(!this.account.isLocked());
        this.tabbedPane.setVisible(!this.account.isLocked());
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.ACCOUNT).equals(this.account)) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case ACCOUNT_MODIFY: {
                            RegisterPanel.this.updateAccountState();
                            RegisterPanel.this.updateAccountInfo();
                            break;
                        }
                        case TRANSACTION_ADD: {
                            Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
                            int index = RegisterPanel.this.account.indexOf(t);
                            if (index == RegisterPanel.this.account.getTransactionCount() - 1) {
                                RegisterPanel.this.autoScroll();
                            }
                            RegisterPanel.this.updateAccountInfo();
                            break;
                        }
                        case TRANSACTION_REMOVE: {
                            RegisterPanel.this.updateAccountInfo();
                            break;
                        }
                    }
                }
            });
        }
    }
}

