/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.CurrencyNode;
import jgnash.text.CommodityFormat;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.ReportFactory;
import jgnash.util.DateUtils;

public abstract class AbstractReportTableModel
extends AbstractTableModel {
    public abstract CurrencyNode getCurrency();

    public abstract ColumnStyle getColumnStyle(int var1);

    public abstract ColumnHeaderStyle getColumnHeaderStyle(int var1);

    public boolean isColumnFixedWidth(int columnIndex) {
        return false;
    }

    private int getGroupColumn() {
        int column = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (this.getColumnStyle(i) != ColumnStyle.GROUP) continue;
            column = i;
            break;
        }
        return column;
    }

    public String getColumnPrototypeValueAt(int columnIndex) {
        String longest;
        block18: {
            block17: {
                NumberFormat nf;
                int groupColumn = this.getGroupColumn();
                longest = "";
                if (!this.getColumnClass(columnIndex).isAssignableFrom(BigDecimal.class)) break block17;
                boolean sum = this.getColumnStyle(columnIndex) == ColumnStyle.BALANCE_WITH_SUM || this.getColumnStyle(columnIndex) == ColumnStyle.BALANCE_WITH_SUM_AND_GLOBAL || this.getColumnStyle(columnIndex) == ColumnStyle.AMOUNT_SUM;
                HashMap<String, BigDecimal> groupMap = new HashMap<String, BigDecimal>();
                switch (this.getColumnStyle(columnIndex)) {
                    case QUANTITY: {
                        nf = ReportFactory.getQuantityFormat();
                        break;
                    }
                    case PERCENTAGE: {
                        nf = ReportFactory.getPercentageFormat();
                        break;
                    }
                    default: {
                        nf = CommodityFormat.getFullNumberFormat(this.getCurrency());
                    }
                }
                BigDecimal total = BigDecimal.ZERO;
                for (int i = 0; i < this.getRowCount(); ++i) {
                    BigDecimal value = (BigDecimal)this.getValueAt(i, columnIndex);
                    if (value == null) continue;
                    String prototype = nf.format(value);
                    if (prototype.length() > longest.length()) {
                        longest = prototype;
                    }
                    if (sum) {
                        total = total.add(value);
                    }
                    if (groupColumn < 0) continue;
                    String group = (String)this.getValueAt(i, groupColumn);
                    BigDecimal o = (BigDecimal)groupMap.get(group);
                    if (o != null) {
                        groupMap.put(group, o.add(value));
                        continue;
                    }
                    groupMap.put(group, value);
                }
                if (!sum) break block18;
                if (nf.format(total).length() > longest.length()) {
                    longest = nf.format(total);
                }
                for (BigDecimal value : groupMap.values()) {
                    if (nf.format(value).length() <= longest.length()) continue;
                    longest = nf.format(value);
                }
                break block18;
            }
            if (this.getColumnStyle(columnIndex) == ColumnStyle.STRING) {
                for (int i = 0; i < this.getRowCount(); ++i) {
                    String val = (String)this.getValueAt(i, columnIndex);
                    if (val == null || val.length() <= longest.length()) continue;
                    longest = val;
                }
            } else if (this.getColumnStyle(columnIndex) == ColumnStyle.SHORT_DATE) {
                DateFormat format = DateUtils.getShortDateFormat();
                for (int i = 0; i < this.getRowCount(); ++i) {
                    try {
                        String val;
                        Date date = (Date)this.getValueAt(i, columnIndex);
                        if (date == null || (val = format.format(date)).length() <= longest.length()) continue;
                        longest = val;
                        continue;
                    }
                    catch (IllegalArgumentException ignored) {
                        // empty catch block
                    }
                }
            }
        }
        return longest;
    }
}

