/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.ui.util.CursorUtils;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class IncomeExpensePieChart {
    private static final String STARTDATE = "startDate";
    private final Resource rb = Resource.get();
    private Preferences pref = Preferences.userNodeForPackage(IncomeExpensePieChart.class);
    private AccountListComboBox combo;
    private JCheckBox showEmptyCheck;
    private JCheckBox showPercentCheck;
    private Cursor ZOOM_IN = CursorUtils.getCursor(0);
    private Cursor ZOOM_OUT = CursorUtils.getCursor(1);
    private Point lastPoint;
    private Account currentAccount;
    private ChartPanel chartPanel;
    private DatePanel startField;
    private DatePanel endField;
    private PieSectionLabelGenerator defaultLabels;
    private PieSectionLabelGenerator percentLabels;

    public static void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                IncomeExpensePieChart chart = new IncomeExpensePieChart();
                JPanel p = chart.createPanel();
                GenericCloseDialog d = new GenericCloseDialog(p);
                d.setTitle(rb.getString("Title.AccountBalance"));
                d.pack();
                d.setModal(false);
                d.setVisible(true);
            }
        });
    }

    private JPanel createPanel() {
        TreeSet<AccountType> set = new TreeSet<AccountType>();
        set.add(AccountType.INCOME);
        set.add(AccountType.EXPENSE);
        JButton refreshButton = new JButton(this.rb.getString("Button.Refresh"));
        this.startField = new DatePanel();
        this.endField = new DatePanel();
        this.showEmptyCheck = new JCheckBox(this.rb.getString("Label.ShowEmptyAccounts"));
        this.showPercentCheck = new JCheckBox(this.rb.getString("Label.ShowPercentValues"));
        this.combo = AccountListComboBox.getParentTypeInstance(EngineFactory.getEngine("default").getRootAccount(), set);
        Date dStart = DateUtils.previousYear(DateUtils.firstDayOfMonth(new Date()));
        long start = this.pref.getLong(STARTDATE, dStart.getTime());
        this.startField.setDate(new Date(start));
        this.currentAccount = this.combo.getSelectedAccount();
        JFreeChart chart = this.createPieChart(this.currentAccount);
        this.chartPanel = new ChartPanel(chart, true, true, true, false, true);
        FormLayout layout = new FormLayout("p, 4dlu, 70dlu, 8dlu, p, 4dlu, 70dlu, 8dlu, p, 4dlu:g, left:p", "f:d, 3dlu, f:d, 6dlu, f:p:g");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        layout.setRowGroups((int[][])new int[][]{{1, 3}});
        builder.append((Component)this.combo, 9);
        builder.append((Component)this.showEmptyCheck);
        builder.nextLine();
        builder.nextLine();
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endField);
        builder.append((Component)refreshButton);
        builder.append((Component)this.showPercentCheck);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)this.chartPanel, 11);
        JPanel panel = builder.getPanel();
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IncomeExpensePieChart.this.setCurrentAccount(IncomeExpensePieChart.this.combo.getSelectedAccount());
                IncomeExpensePieChart.this.pref.putLong(IncomeExpensePieChart.STARTDATE, IncomeExpensePieChart.this.startField.getDate().getTime());
            }
        });
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IncomeExpensePieChart.this.setCurrentAccount(IncomeExpensePieChart.this.currentAccount);
                IncomeExpensePieChart.this.pref.putLong(IncomeExpensePieChart.STARTDATE, IncomeExpensePieChart.this.startField.getDate().getTime());
            }
        });
        this.showEmptyCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IncomeExpensePieChart.this.setCurrentAccount(IncomeExpensePieChart.this.currentAccount);
            }
        });
        this.showPercentCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((PiePlot)IncomeExpensePieChart.this.chartPanel.getChart().getPlot()).setLabelGenerator(IncomeExpensePieChart.this.showPercentCheck.isSelected() ? IncomeExpensePieChart.this.percentLabels : IncomeExpensePieChart.this.defaultLabels);
            }
        });
        ChartMouseListener mouseListener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                MouseEvent me = event.getTrigger();
                if (me.getID() == 500 && me.getClickCount() == 1) {
                    try {
                        ChartEntity entity = event.getEntity();
                        if (entity instanceof PieSectionEntity) {
                            Account a = (Account)((PieSectionEntity)entity).getSectionKey();
                            if (a.getChildCount() > 0) {
                                IncomeExpensePieChart.this.setCurrentAccount(a);
                            }
                        } else if (entity == null) {
                            Account parent = IncomeExpensePieChart.this.currentAccount;
                            if (parent == null) {
                                return;
                            }
                            if ((parent = parent.getParent()) == null || parent instanceof RootAccount) {
                                return;
                            }
                            IncomeExpensePieChart.this.setCurrentAccount(parent);
                        }
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
                IncomeExpensePieChart.this.setChartCursor(IncomeExpensePieChart.this.chartPanel, event.getEntity(), event.getTrigger().getPoint());
            }
        };
        this.chartPanel.addChartMouseListener(mouseListener);
        return panel;
    }

    private void setCurrentAccount(Account a) {
        try {
            if (a == null) {
                return;
            }
            this.currentAccount = a;
            this.chartPanel.setChart(this.createPieChart(a));
            this.chartPanel.validate();
            if (this.lastPoint != null) {
                this.setChartCursor(this.chartPanel, null, this.lastPoint);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setChartCursor(final ChartPanel chartPanel, final ChartEntity e, final Point point) {
        this.lastPoint = point;
        EventQueue.invokeLater(new Runnable(){
            ChartEntity entity;
            {
                this.entity = e;
            }

            @Override
            public void run() {
                if (this.entity == null && point != null) {
                    this.entity = chartPanel.getEntityForPoint(((IncomeExpensePieChart)IncomeExpensePieChart.this).lastPoint.x, ((IncomeExpensePieChart)IncomeExpensePieChart.this).lastPoint.y);
                }
                Account parent = IncomeExpensePieChart.this.currentAccount;
                if (this.entity instanceof PieSectionEntity) {
                    Account a = (Account)((PieSectionEntity)this.entity).getSectionKey();
                    if (a.getChildCount() > 0 && a != parent) {
                        chartPanel.setCursor(IncomeExpensePieChart.this.ZOOM_IN);
                    } else {
                        chartPanel.setCursor(Cursor.getDefaultCursor());
                    }
                    return;
                }
                if (this.entity == null && parent != null && (parent = parent.getParent()) != null && !(parent instanceof RootAccount)) {
                    chartPanel.setCursor(IncomeExpensePieChart.this.ZOOM_OUT);
                    return;
                }
                chartPanel.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    private JFreeChart createPieChart(Account a) {
        PieDataset data = this.createPieDataset(a);
        PiePlot plot = new PiePlot(data);
        NumberFormat valueFormat = CommodityFormat.getFullNumberFormat(a.getCurrencyNode());
        DecimalFormat percentFormat = new DecimalFormat("0.0#%");
        this.defaultLabels = new StandardPieSectionLabelGenerator("{0} = {1}", valueFormat, (NumberFormat)percentFormat);
        this.percentLabels = new StandardPieSectionLabelGenerator("{0} = {1}\n{2}", valueFormat, (NumberFormat)percentFormat);
        plot.setLabelGenerator(this.showPercentCheck.isSelected() ? this.percentLabels : this.defaultLabels);
        plot.setLabelGap(0.02);
        plot.setInteriorGap(0.1);
        if (data.getIndex((Comparable)a) != -1) {
            plot.setExplodePercent((Comparable)a, 0.1);
        }
        String title = a.getAccountType() == AccountType.EXPENSE ? this.rb.getString("Title.PercentExpense") : (a.getAccountType() == AccountType.INCOME ? this.rb.getString("Title.PercentIncome") : this.rb.getString("Title.PercentDist"));
        title = title + " - " + a.getPathName();
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        BigDecimal total = a.getTreeBalance(this.startField.getDate(), this.endField.getDate()).abs();
        chart.addSubtitle((Title)new TextTitle(valueFormat.format(total)));
        chart.setBackgroundPaint(null);
        return chart;
    }

    private PieDataset createPieDataset(Account a) {
        DefaultPieDataset returnValue = new DefaultPieDataset();
        if (a != null) {
            BigDecimal total = a.getTreeBalance(this.startField.getDate(), this.endField.getDate(), a.getCurrencyNode());
            boolean negate = total != null && total.floatValue() < 0.0f;
            BigDecimal value = a.getBalance(this.startField.getDate(), this.endField.getDate());
            if (value.compareTo(BigDecimal.ZERO) != 0) {
                returnValue.setValue((Comparable)a, (Number)(negate ? value.negate() : value));
            }
            for (Account child : a.getChildren()) {
                value = child.getTreeBalance(this.startField.getDate(), this.endField.getDate(), a.getCurrencyNode());
                if (!this.showEmptyCheck.isSelected() && value.compareTo(BigDecimal.ZERO) == 0) continue;
                returnValue.setValue((Comparable)child, (Number)(negate ? value.negate() : value));
            }
        }
        return returnValue;
    }
}

