/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.util.ClassPathUtils;

public class TextResource {
    private static final String ROOTPATH = "/jgnash/resource/text";

    private TextResource() {
    }

    private static InputStream getInputStream(String fileName) {
        String root = ClassPathUtils.getLocalizedPath(ROOTPATH);
        return Object.class.getResourceAsStream(root + "/" + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String fileName) {
        InputStream s = TextResource.getInputStream(fileName);
        StringBuilder sb = new StringBuilder();
        if (s != null) {
            BufferedReader b = null;
            try {
                b = new BufferedReader(new InputStreamReader(s, "8859_1"));
                String t = TextResource.loadConvert(b.readLine());
                while (t != null) {
                    sb.append(t);
                    t = TextResource.loadConvert(b.readLine());
                    if (t == null) continue;
                    sb.append("\n");
                }
            }
            catch (IOException e) {
                Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, e);
            }
            finally {
                if (b != null) {
                    try {
                        b.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(TextResource.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        return sb.toString();
    }

    private static String loadConvert(String theString) {
        if (theString == null) {
            return null;
        }
        int len = theString.length();
        StringBuilder outBuffer = new StringBuilder(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }
}

