/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class DateUtils {
    private static WeakReference<Calendar> wGc;
    private static WeakReference<Calendar> wC;

    private DateUtils() {
    }

    public static DateFormat getShortDateFormat() {
        DateFormat df = DateFormat.getDateInstance(3);
        if (df instanceof SimpleDateFormat) {
            String pattern = ((SimpleDateFormat)df).toPattern();
            pattern = pattern.replaceAll("M{1,2}", "MM").replaceAll("d{1,2}", "dd");
            ((SimpleDateFormat)df).applyPattern(pattern);
        }
        return df;
    }

    public static synchronized Date levelDate(Date date) {
        Calendar c = DateUtils.getCal();
        c.setTime(date);
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        return c.getTime();
    }

    public static synchronized boolean before(Date d1, Date d2, boolean inclusive) {
        if (inclusive) {
            return DateUtils.levelDate(d1).getTime() <= DateUtils.levelDate(d2).getTime();
        }
        return DateUtils.levelDate(d1).getTime() < DateUtils.levelDate(d2).getTime();
    }

    public static synchronized boolean before(Date d1, Date d2) {
        return DateUtils.before(d1, d2, true);
    }

    public static synchronized boolean after(Date d1, Date d2, boolean inclusive) {
        return DateUtils.before(d2, d1, inclusive);
    }

    public static synchronized boolean after(Date d1, Date d2) {
        return DateUtils.before(d2, d1, true);
    }

    public static synchronized Date lastDayOfMonth(int month, int year) {
        assert (month >= 0 && month <= 11);
        GregorianCalendar c = DateUtils.getGCal();
        c.set(year, month, 15);
        c.set(c.get(1), c.get(2), ((Calendar)c).getActualMaximum(5));
        return DateUtils.levelDate(c.getTime());
    }

    public static synchronized Date lastDayOfMonth(Date date) {
        assert (date != null);
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        c.set(c.get(1), c.get(2), ((Calendar)c).getActualMaximum(5));
        return DateUtils.levelDate(c.getTime());
    }

    public static synchronized Date firstDayOfMonth(Date date) {
        assert (date != null);
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        c.set(c.get(1), c.get(2), ((Calendar)c).getActualMinimum(5));
        return DateUtils.levelDate(c.getTime());
    }

    public static synchronized Date[] lastDaysOfMonth(int year) {
        Date[] list = new Date[12];
        for (int i = 0; i < 12; ++i) {
            list[i] = DateUtils.lastDayOfMonth(i, year);
        }
        return list;
    }

    public static synchronized List<Date> lastDaysOfMonth(Date startDate, Date endDate) {
        ArrayList<Date> list = new ArrayList<Date>();
        Date end = DateUtils.lastDayOfMonth(endDate);
        Date t = DateUtils.lastDayOfMonth(startDate);
        while (DateUtils.before(t, end)) {
            list.add(t);
            t = DateUtils.lastDayOfMonth(DateUtils.nextMonth(t));
        }
        return list;
    }

    public static synchronized Date lastDayOfQuarter(Date bdate) {
        Date[] bounds;
        assert (bdate != null);
        Date date = DateUtils.levelDate(bdate);
        Date result = date.compareTo((bounds = DateUtils.getQuarterBounds(date))[2]) < 0 ? bounds[1] : (date.compareTo(bounds[4]) < 0 ? bounds[3] : (date.compareTo(bounds[6]) < 0 ? bounds[5] : bounds[7]));
        return DateUtils.levelDate(result);
    }

    public static synchronized Date lastDayOfYear(Date date) {
        assert (date != null);
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        c.set(c.get(1), ((Calendar)c).getActualMaximum(2), ((Calendar)c).getMaximum(5));
        return DateUtils.levelDate(c.getTime());
    }

    private static synchronized Date[] getQuarterBounds(Date date) {
        assert (date != null);
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        Date[] bounds = new Date[8];
        c.set(c.get(1), 0, 1, 0, 0, 0);
        bounds[0] = c.getTime();
        c.set(c.get(1), 2, 31, 0, 0, 0);
        bounds[1] = c.getTime();
        c.set(c.get(1), 3, 1, 0, 0, 0);
        bounds[2] = c.getTime();
        c.set(c.get(1), 5, 30, 0, 0, 0);
        bounds[3] = c.getTime();
        c.set(c.get(1), 6, 1, 0, 0, 0);
        bounds[4] = c.getTime();
        c.set(c.get(1), 8, 30, 0, 0, 0);
        bounds[5] = c.getTime();
        c.set(c.get(1), 9, 1, 0, 0, 0);
        bounds[6] = c.getTime();
        c.set(c.get(1), 11, 31, 0, 0, 0);
        bounds[7] = c.getTime();
        return bounds;
    }

    public static synchronized int getQuarterNumber(Date date) {
        assert (date != null);
        Date[] bounds = DateUtils.getQuarterBounds(date);
        int result = date.compareTo(bounds[2]) < 0 ? 1 : (date.compareTo(bounds[4]) < 0 ? 2 : (date.compareTo(bounds[6]) < 0 ? 3 : 4));
        return result;
    }

    private static synchronized GregorianCalendar getGCal() {
        Object o;
        if (wGc != null && (o = wGc.get()) != null) {
            return (GregorianCalendar)o;
        }
        GregorianCalendar c = (GregorianCalendar)Calendar.getInstance();
        wGc = new WeakReference<GregorianCalendar>(c);
        return c;
    }

    private static synchronized Calendar getCal() {
        Object o;
        if (wC != null && (o = wC.get()) != null) {
            return (Calendar)o;
        }
        Calendar c = Calendar.getInstance();
        wC = new WeakReference<Calendar>(c);
        return c;
    }

    public static synchronized Date nextDay(Date date) {
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        ((Calendar)c).add(5, 1);
        return c.getTime();
    }

    public static synchronized Date nextMonth(Date date) {
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        ((Calendar)c).add(2, 1);
        return c.getTime();
    }

    public static synchronized Date previousMonth(Date date) {
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        ((Calendar)c).add(2, -1);
        return c.getTime();
    }

    public static synchronized Date previousDay(Date date) {
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        ((Calendar)c).add(5, -1);
        return c.getTime();
    }

    public static synchronized Date nextWeek(Date date) {
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        ((Calendar)c).add(5, 7);
        return c.getTime();
    }

    public static synchronized Date nextYear(Date date) {
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        ((Calendar)c).add(1, 1);
        return c.getTime();
    }

    public static synchronized Date previousYear(Date date) {
        GregorianCalendar c = DateUtils.getGCal();
        c.setTime(date);
        ((Calendar)c).add(1, -1);
        return c.getTime();
    }
}

