/*
 * Decompiled with CFR 0.152.
 */
package jgnash.util;

import java.util.regex.Pattern;

public class SearchUtils {
    private SearchUtils() {
    }

    public static Pattern createSearchPattern(String pattern, boolean caseSensitive) {
        Pattern p = caseSensitive ? Pattern.compile(SearchUtils.wildcardSearchToRegex(pattern)) : Pattern.compile(SearchUtils.wildcardSearchToRegex(pattern), 66);
        return p;
    }

    private static String wildcardSearchToRegex(String wildcard) {
        StringBuilder buffer = new StringBuilder(wildcard.length() + 2);
        buffer.append('^');
        for (char c : wildcard.toCharArray()) {
            if (c == '*') {
                buffer.append(".*");
                continue;
            }
            if (c == '?') {
                buffer.append(".");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(c) != -1) {
                buffer.append('\\').append(c);
                continue;
            }
            buffer.append(c);
        }
        buffer.append('$');
        return buffer.toString();
    }
}

