/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fonts;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.SimpleFontFamily;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class SimpleFontExtensionHelper
implements ErrorHandler {
    private static final Log log = LogFactory.getLog(SimpleFontExtensionHelper.class);
    private static final String NODE_fontFamily = "fontFamily";
    private static final String NODE_normal = "normal";
    private static final String NODE_bold = "bold";
    private static final String NODE_italic = "italic";
    private static final String NODE_boldItalic = "boldItalic";
    private static final String NODE_pdfEncoding = "pdfEncoding";
    private static final String NODE_pdfEmbedded = "pdfEmbedded";
    private static final String NODE_exportFonts = "exportFonts";
    private static final String NODE_export = "export";
    private static final String NODE_locales = "locales";
    private static final String NODE_locale = "locale";
    private static final String ATTRIBUTE_name = "name";
    private static final String ATTRIBUTE_key = "key";
    private static final ThreadLocal threadInstances = new ThreadLocal();
    private DocumentBuilder documentBuilder = null;

    public static SimpleFontExtensionHelper getInstance() {
        SimpleFontExtensionHelper instance = null;
        SoftReference instanceRef = (SoftReference)threadInstances.get();
        if (instanceRef != null) {
            instance = (SimpleFontExtensionHelper)instanceRef.get();
        }
        if (instance == null) {
            instance = new SimpleFontExtensionHelper();
            threadInstances.set(new SoftReference<SimpleFontExtensionHelper>(instance));
        }
        return instance;
    }

    private SimpleFontExtensionHelper() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = factory.newDocumentBuilder();
            this.documentBuilder.setErrorHandler(this);
        }
        catch (ParserConfigurationException e) {
            throw new JRRuntimeException(e);
        }
    }

    public List loadFontFamilies(String file) {
        InputStream is = null;
        try {
            is = JRLoader.getLocationInputStream(file);
            List list = this.loadFontFamilies(is);
            return list;
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public List loadFontFamilies(InputStream is) {
        List fontFamilies = null;
        try {
            Document document = this.documentBuilder.parse(new InputSource(new InputStreamReader(is, "UTF-8")));
            fontFamilies = this.parseFontFamilies(document.getDocumentElement());
        }
        catch (SAXException e) {
            throw new JRRuntimeException(e);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
        return fontFamilies;
    }

    private List parseFontFamilies(Node fontFamiliesNode) throws SAXException {
        ArrayList<FontFamily> fontFamilies = new ArrayList<FontFamily>();
        NodeList nodeList = fontFamiliesNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !NODE_fontFamily.equals(node.getNodeName())) continue;
            fontFamilies.add(this.parseFontFamily(node));
        }
        return fontFamilies;
    }

    private FontFamily parseFontFamily(Node fontFamilyNode) throws SAXException {
        SimpleFontFamily fontFamily = new SimpleFontFamily();
        NamedNodeMap nodeAttrs = fontFamilyNode.getAttributes();
        if (nodeAttrs.getNamedItem(ATTRIBUTE_name) != null) {
            fontFamily.setName(nodeAttrs.getNamedItem(ATTRIBUTE_name).getNodeValue());
        }
        NodeList nodeList = fontFamilyNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if (NODE_normal.equals(node.getNodeName())) {
                fontFamily.setNormal(node.getTextContent());
                continue;
            }
            if (NODE_bold.equals(node.getNodeName())) {
                fontFamily.setBold(node.getTextContent());
                continue;
            }
            if (NODE_italic.equals(node.getNodeName())) {
                fontFamily.setItalic(node.getTextContent());
                continue;
            }
            if (NODE_boldItalic.equals(node.getNodeName())) {
                fontFamily.setBoldItalic(node.getTextContent());
                continue;
            }
            if (NODE_pdfEncoding.equals(node.getNodeName())) {
                fontFamily.setPdfEncoding(node.getTextContent());
                continue;
            }
            if (NODE_pdfEmbedded.equals(node.getNodeName())) {
                fontFamily.setPdfEmbedded(Boolean.valueOf(node.getTextContent()));
                continue;
            }
            if (NODE_exportFonts.equals(node.getNodeName())) {
                fontFamily.setExportFonts(this.parseExportFonts(node));
                continue;
            }
            if (!NODE_locales.equals(node.getNodeName())) continue;
            fontFamily.setLocales(this.parseLocales(node));
        }
        return fontFamily;
    }

    private Map parseExportFonts(Node exportFontsNode) throws SAXException {
        HashMap<String, String> exportFonts = new HashMap<String, String>();
        NodeList nodeList = exportFontsNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap nodeAttrs;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !NODE_export.equals(node.getNodeName()) || (nodeAttrs = node.getAttributes()).getNamedItem(ATTRIBUTE_key) == null) continue;
            exportFonts.put(nodeAttrs.getNamedItem(ATTRIBUTE_key).getNodeValue(), node.getTextContent());
        }
        return exportFonts;
    }

    private Set parseLocales(Node localesNode) throws SAXException {
        HashSet<String> locales = new HashSet<String>();
        NodeList nodeList = localesNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !NODE_locale.equals(node.getNodeName())) continue;
            locales.add(node.getTextContent());
        }
        return locales;
    }

    public void error(SAXParseException e) {
        if (log.isErrorEnabled()) {
            log.error((Object)"Error parsing styled text.", (Throwable)e);
        }
    }

    public void fatalError(SAXParseException e) {
        if (log.isFatalEnabled()) {
            log.fatal((Object)"Error parsing styled text.", (Throwable)e);
        }
    }

    public void warning(SAXParseException e) {
        if (log.isWarnEnabled()) {
            log.warn((Object)"Error parsing styled text.", (Throwable)e);
        }
    }
}

