/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.swt;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.RunOnUIThread;
import org.pushingpixels.trident.callback.TimelineCallback;

@RunOnUIThread
public class SWTRepaintCallback
implements TimelineCallback {
    private Control control;
    private Rectangle rect;

    public SWTRepaintCallback(Control control) {
        this(control, null);
    }

    public SWTRepaintCallback(Control control, Rectangle rect) {
        if (control == null) {
            throw new NullPointerException("Control must be non-null");
        }
        this.control = control;
        this.rect = rect;
    }

    @Override
    public void onTimelinePulse(float durationFraction, float timelinePosition) {
        if (this.control.isDisposed()) {
            return;
        }
        if (this.rect == null) {
            this.control.redraw();
        } else {
            this.control.redraw(this.rect.x, this.rect.y, this.rect.width, this.rect.height, true);
        }
    }

    @Override
    public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float durationFraction, float timelinePosition) {
        if (this.control.isDisposed()) {
            return;
        }
        if (this.rect == null) {
            this.control.redraw();
        } else {
            this.control.redraw(this.rect.x, this.rect.y, this.rect.width, this.rect.height, true);
        }
    }
}

