/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.charts.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.design.JRDesignPieSeries;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.base.JRBaseChartDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRBasePieDataset
extends JRBaseChartDataset
implements JRPieDataset,
JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_MIN_PERCENTAGE = "minPercentage";
    public static final String PROPERTY_MAX_COUNT = "maxCount";
    private Float minPercentage = null;
    private Integer maxCount = null;
    protected JRPieSeries[] pieSeries = null;
    protected JRExpression otherKeyExpression = null;
    protected JRExpression otherLabelExpression = null;
    private JRHyperlink otherSectionHyperlink = null;
    private transient JRPropertyChangeSupport eventSupport;
    private JRExpression keyExpression = null;
    private JRExpression valueExpression = null;
    private JRExpression labelExpression = null;
    private JRHyperlink sectionHyperlink = null;

    public JRBasePieDataset(JRChartDataset dataset) {
        super(dataset);
    }

    public JRBasePieDataset(JRPieDataset dataset, JRBaseObjectFactory factory) {
        super(dataset, factory);
        this.minPercentage = dataset.getMinPercentage();
        this.maxCount = dataset.getMaxCount();
        JRPieSeries[] srcPieSeries = dataset.getSeries();
        if (srcPieSeries != null && srcPieSeries.length > 0) {
            this.pieSeries = new JRPieSeries[srcPieSeries.length];
            for (int i = 0; i < this.pieSeries.length; ++i) {
                this.pieSeries[i] = factory.getPieSeries(srcPieSeries[i]);
            }
        }
        this.otherKeyExpression = factory.getExpression(dataset.getOtherKeyExpression());
        this.otherLabelExpression = factory.getExpression(dataset.getOtherLabelExpression());
        this.otherSectionHyperlink = factory.getHyperlink(dataset.getOtherSectionHyperlink());
    }

    public Float getMinPercentage() {
        return this.minPercentage;
    }

    public void setMinPercentage(Float minPercentage) {
        Float old = this.minPercentage;
        this.minPercentage = minPercentage;
        this.getEventSupport().firePropertyChange(PROPERTY_MIN_PERCENTAGE, old, this.minPercentage);
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(Integer maxCount) {
        Integer old = this.maxCount;
        this.maxCount = maxCount;
        this.getEventSupport().firePropertyChange(PROPERTY_MAX_COUNT, old, this.maxCount);
    }

    public JRPieSeries[] getSeries() {
        return this.pieSeries;
    }

    public JRExpression getKeyExpression() {
        return this.pieSeries != null && this.pieSeries.length > 0 ? this.pieSeries[0].getKeyExpression() : null;
    }

    public JRExpression getValueExpression() {
        return this.pieSeries != null && this.pieSeries.length > 0 ? this.pieSeries[0].getValueExpression() : null;
    }

    public JRExpression getLabelExpression() {
        return this.pieSeries != null && this.pieSeries.length > 0 ? this.pieSeries[0].getLabelExpression() : null;
    }

    public JRHyperlink getSectionHyperlink() {
        return this.pieSeries != null && this.pieSeries.length > 0 ? this.pieSeries[0].getSectionHyperlink() : null;
    }

    public JRExpression getOtherKeyExpression() {
        return this.otherKeyExpression;
    }

    public JRExpression getOtherLabelExpression() {
        return this.otherLabelExpression;
    }

    public JRHyperlink getOtherSectionHyperlink() {
        return this.otherSectionHyperlink;
    }

    public byte getDatasetType() {
        return 1;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void validate(JRVerifier verifier) {
        verifier.verify(this);
    }

    public Object clone() {
        JRBasePieDataset clone = (JRBasePieDataset)super.clone();
        if (this.pieSeries != null) {
            clone.pieSeries = new JRPieSeries[this.pieSeries.length];
            for (int i = 0; i < this.pieSeries.length; ++i) {
                clone.pieSeries[i] = (JRPieSeries)this.pieSeries[i].clone();
            }
        }
        if (this.otherKeyExpression != null) {
            clone.otherKeyExpression = (JRExpression)this.otherKeyExpression.clone();
        }
        if (this.otherLabelExpression != null) {
            clone.otherLabelExpression = (JRExpression)this.otherLabelExpression.clone();
        }
        if (this.otherSectionHyperlink != null) {
            clone.otherSectionHyperlink = (JRHyperlink)this.otherSectionHyperlink.clone();
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRBasePieDataset jRBasePieDataset = this;
        synchronized (jRBasePieDataset) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.pieSeries == null) {
            this.pieSeries = new JRPieSeries[1];
            JRDesignPieSeries ps = new JRDesignPieSeries();
            ps.setKeyExpression(this.keyExpression);
            ps.setValueExpression(this.valueExpression);
            ps.setLabelExpression(this.labelExpression);
            ps.setSectionHyperlink(this.sectionHyperlink);
            this.pieSeries[0] = ps;
            this.keyExpression = null;
            this.valueExpression = null;
            this.labelExpression = null;
            this.sectionHyperlink = null;
        }
    }
}

