/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

import com.db4o.foundation.DeepClone;
import com.db4o.foundation.NotImplementedException;
import com.db4o.foundation.Predicate4;
import com.db4o.foundation.ShallowClone;
import com.db4o.foundation.Visitor4;

public abstract class Tree
implements ShallowClone,
DeepClone {
    public Tree _preceding;
    public int _size = 1;
    public Tree _subsequent;

    public static final Tree add(Tree tree, Tree tree2) {
        if (tree == null) {
            return tree2;
        }
        return tree.add(tree2);
    }

    public Tree add(Tree tree) {
        return this.add(tree, this.compare(tree));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Tree add(Tree tree, int n) {
        if (n < 0) {
            if (this._subsequent == null) {
                this._subsequent = tree;
                ++this._size;
                return this;
            }
            this._subsequent = this._subsequent.add(tree);
            if (this._preceding != null) return this.balance();
            return this.rotateLeft();
        }
        if (n <= 0 && !tree.duplicates()) {
            tree.onAttemptToAddDuplicate(this);
            return this;
        }
        if (this._preceding == null) {
            this._preceding = tree;
            ++this._size;
            return this;
        }
        this._preceding = this._preceding.add(tree);
        if (this._subsequent != null) return this.balance();
        return this.rotateRight();
    }

    public Tree addedOrExisting() {
        if (this.wasAddedToTree()) {
            return this;
        }
        return this._preceding;
    }

    public boolean wasAddedToTree() {
        return this._size != 0;
    }

    public final Tree balance() {
        int n = this._subsequent.nodes() - this._preceding.nodes();
        if (n < -2) {
            return this.rotateRight();
        }
        if (n > 2) {
            return this.rotateLeft();
        }
        this.setSizeOwnPrecedingSubsequent();
        return this;
    }

    public Tree balanceCheckNulls() {
        if (this._subsequent == null) {
            if (this._preceding == null) {
                this.setSizeOwn();
                return this;
            }
            return this.rotateRight();
        }
        if (this._preceding == null) {
            return this.rotateLeft();
        }
        return this.balance();
    }

    public void calculateSize() {
        if (this._preceding == null) {
            if (this._subsequent == null) {
                this.setSizeOwn();
            } else {
                this.setSizeOwnSubsequent();
            }
        } else if (this._subsequent == null) {
            this.setSizeOwnPreceding();
        } else {
            this.setSizeOwnPrecedingSubsequent();
        }
    }

    public abstract int compare(Tree var1);

    public static Tree deepClone(Tree tree, Object object) {
        if (tree == null) {
            return null;
        }
        Tree tree2 = (Tree)tree.deepClone(object);
        tree2._size = tree._size;
        tree2._preceding = Tree.deepClone(tree._preceding, object);
        tree2._subsequent = Tree.deepClone(tree._subsequent, object);
        return tree2;
    }

    public Object deepClone(Object object) {
        return this.shallowClone();
    }

    public boolean duplicates() {
        return true;
    }

    public final Tree filter(Predicate4 predicate4) {
        if (this._preceding != null) {
            this._preceding = this._preceding.filter(predicate4);
        }
        if (this._subsequent != null) {
            this._subsequent = this._subsequent.filter(predicate4);
        }
        if (!predicate4.match(this)) {
            return this.remove();
        }
        return this;
    }

    public static final Tree find(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        return tree.find(tree2);
    }

    public final Tree find(Tree tree) {
        int n = this.compare(tree);
        if (n < 0) {
            if (this._subsequent != null) {
                return this._subsequent.find(tree);
            }
        } else if (n > 0) {
            if (this._preceding != null) {
                return this._preceding.find(tree);
            }
        } else {
            return this;
        }
        return null;
    }

    public static final Tree findGreaterOrEqual(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        int n = tree.compare(tree2);
        if (n == 0) {
            return tree;
        }
        if (n > 0) {
            Tree tree3 = Tree.findGreaterOrEqual(tree._preceding, tree2);
            if (tree3 != null) {
                return tree3;
            }
            return tree;
        }
        return Tree.findGreaterOrEqual(tree._subsequent, tree2);
    }

    public static final Tree findSmaller(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        int n = tree.compare(tree2);
        if (n < 0) {
            Tree tree3 = Tree.findSmaller(tree._subsequent, tree2);
            if (tree3 != null) {
                return tree3;
            }
            return tree;
        }
        return Tree.findSmaller(tree._preceding, tree2);
    }

    public final Tree first() {
        if (this._preceding == null) {
            return this;
        }
        return this._preceding.first();
    }

    public static Tree last(Tree tree) {
        if (tree == null) {
            return null;
        }
        return tree.last();
    }

    public final Tree last() {
        if (this._subsequent == null) {
            return this;
        }
        return this._subsequent.last();
    }

    public void onAttemptToAddDuplicate(Tree tree) {
        this._size = 0;
        this._preceding = tree;
    }

    public int nodes() {
        return this._size;
    }

    public int ownSize() {
        return 1;
    }

    public Tree remove() {
        if (this._subsequent != null && this._preceding != null) {
            this._subsequent = this._subsequent.rotateSmallestUp();
            this._subsequent._preceding = this._preceding;
            this._subsequent.calculateSize();
            return this._subsequent;
        }
        if (this._subsequent != null) {
            return this._subsequent;
        }
        return this._preceding;
    }

    public void removeChildren() {
        this._preceding = null;
        this._subsequent = null;
        this.setSizeOwn();
    }

    public Tree removeFirst() {
        if (this._preceding == null) {
            return this._subsequent;
        }
        this._preceding = this._preceding.removeFirst();
        this.calculateSize();
        return this;
    }

    public static Tree removeLike(Tree tree, Tree tree2) {
        if (tree == null) {
            return null;
        }
        return tree.removeLike(tree2);
    }

    public final Tree removeLike(Tree tree) {
        int n = this.compare(tree);
        if (n == 0) {
            return this.remove();
        }
        if (n > 0) {
            if (this._preceding != null) {
                this._preceding = this._preceding.removeLike(tree);
            }
        } else if (this._subsequent != null) {
            this._subsequent = this._subsequent.removeLike(tree);
        }
        this.calculateSize();
        return this;
    }

    public final Tree removeNode(Tree tree) {
        if (this == tree) {
            return this.remove();
        }
        int n = this.compare(tree);
        if (n >= 0 && this._preceding != null) {
            this._preceding = this._preceding.removeNode(tree);
        }
        if (n <= 0 && this._subsequent != null) {
            this._subsequent = this._subsequent.removeNode(tree);
        }
        this.calculateSize();
        return this;
    }

    public final Tree rotateLeft() {
        Tree tree = this._subsequent;
        this._subsequent = tree._preceding;
        this.calculateSize();
        tree._preceding = this;
        if (tree._subsequent == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._subsequent);
        }
        return tree;
    }

    public final Tree rotateRight() {
        Tree tree = this._preceding;
        this._preceding = tree._subsequent;
        this.calculateSize();
        tree._subsequent = this;
        if (tree._preceding == null) {
            tree.setSizeOwnPlus(this);
        } else {
            tree.setSizeOwnPlus(this, tree._preceding);
        }
        return tree;
    }

    private final Tree rotateSmallestUp() {
        if (this._preceding != null) {
            this._preceding = this._preceding.rotateSmallestUp();
            return this.rotateRight();
        }
        return this;
    }

    public void setSizeOwn() {
        this._size = this.ownSize();
    }

    public void setSizeOwnPrecedingSubsequent() {
        this._size = this.ownSize() + this._preceding._size + this._subsequent._size;
    }

    public void setSizeOwnPreceding() {
        this._size = this.ownSize() + this._preceding._size;
    }

    public void setSizeOwnSubsequent() {
        this._size = this.ownSize() + this._subsequent._size;
    }

    public void setSizeOwnPlus(Tree tree) {
        this._size = this.ownSize() + tree._size;
    }

    public void setSizeOwnPlus(Tree tree, Tree tree2) {
        this._size = this.ownSize() + tree._size + tree2._size;
    }

    public static int size(Tree tree) {
        if (tree == null) {
            return 0;
        }
        return tree.size();
    }

    public int size() {
        return this._size;
    }

    public static final void traverse(Tree tree, Visitor4 visitor4) {
        if (tree == null) {
            return;
        }
        tree.traverse(visitor4);
    }

    public final void traverse(Visitor4 visitor4) {
        if (this._preceding != null) {
            this._preceding.traverse(visitor4);
        }
        visitor4.visit(this);
        if (this._subsequent != null) {
            this._subsequent.traverse(visitor4);
        }
    }

    public final void traverseFromLeaves(Visitor4 visitor4) {
        if (this._preceding != null) {
            this._preceding.traverseFromLeaves(visitor4);
        }
        if (this._subsequent != null) {
            this._subsequent.traverseFromLeaves(visitor4);
        }
        visitor4.visit(this);
    }

    protected Tree shallowCloneInternal(Tree tree) {
        tree._preceding = this._preceding;
        tree._size = this._size;
        tree._subsequent = this._subsequent;
        return tree;
    }

    public Object shallowClone() {
        throw new NotImplementedException();
    }

    public abstract Object key();

    public Object root() {
        return this;
    }

    public static final class ByRef {
        public Tree value;

        public ByRef() {
        }

        public ByRef(Tree tree) {
            this.value = tree;
        }
    }
}

