/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.chart.builder;

import ar.com.fdvs.dj.domain.DJHyperLink;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.builders.ChartBuilderException;
import ar.com.fdvs.dj.domain.chart.DJChart;
import ar.com.fdvs.dj.domain.chart.DJChartOptions;
import ar.com.fdvs.dj.domain.chart.dataset.AbstractDataset;
import ar.com.fdvs.dj.domain.chart.plot.AbstractPlot;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import ar.com.fdvs.dj.domain.entities.columns.PropertyColumn;
import java.awt.Color;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChartBuilder<T extends AbstractChartBuilder> {
    protected DJChart chart = new DJChart(this.getChartType());

    protected abstract byte getChartType();

    public DJChart build() throws ChartBuilderException {
        if (this.chart.getDataset().getColumnsGroup() == null) {
            throw new ChartBuilderException("The group to which the chart is related must be specified");
        }
        if (this.chart.getDataset().getColumns().isEmpty()) {
            throw new ChartBuilderException("At least one column to which the chart is related must be specified");
        }
        return this.chart;
    }

    public T setChartOptions(DJChartOptions chartOptions) {
        this.chart.setOptions(chartOptions);
        return (T)this;
    }

    public T setColumnGroup(PropertyColumn column) {
        this.setCategory(column);
        return (T)this;
    }

    public abstract T setOperation(byte var1);

    public abstract T setLink(DJHyperLink var1);

    public abstract T setBackColor(Color var1);

    public abstract T setHeight(int var1);

    public abstract T setWidth(int var1);

    public abstract T setCentered(boolean var1);

    public abstract T setPosition(byte var1);

    public abstract T setY(int var1);

    public abstract T setX(int var1);

    public abstract T setShowLegend(boolean var1);

    public abstract T setTitleColor(Color var1);

    public abstract T setSubtitleColor(Color var1);

    public abstract T setLegendColor(Color var1);

    public abstract T setLegendBackgroundColor(Color var1);

    public abstract T setTheme(String var1);

    public abstract T setTitleFont(Font var1);

    public abstract T setSubtitleFont(Font var1);

    public abstract T setLegendFont(Font var1);

    public abstract T setLegendPosition(byte var1);

    public abstract T setTitlePosition(byte var1);

    public abstract T setTitle(String var1);

    public abstract T setTitle(StringExpression var1);

    public abstract T setSubtitle(String var1);

    public abstract T setSubtitle(StringExpression var1);

    public abstract T setLineStyle(byte var1);

    public abstract T setLineWidth(float var1);

    public abstract T setLineColor(Color var1);

    public abstract T setPadding(int var1);

    public abstract T setCustomizerClass(String var1);

    protected abstract T setCategory(PropertyColumn var1);

    public abstract T addSerie(AbstractColumn var1);

    public abstract T addSeriesColor(Color var1);

    public abstract T setSeriesColors(List var1);

    protected abstract AbstractDataset getDataset();

    protected abstract AbstractPlot getPlot();
}

