/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.util;

import ar.com.fdvs.dj.core.DJException;
import ar.com.fdvs.dj.domain.Style;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;

public class Utils {
    private Utils() {
    }

    public static boolean isEmpty(Collection col) {
        if (col == null) {
            return true;
        }
        return col.isEmpty();
    }

    public static void addNotNull(Collection col, Object obj) {
        if (col == null || obj == null) {
            return;
        }
        col.add(obj);
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            if (orig != null && dest != null) {
                BeanUtils.copyProperties((Object)dest, (Object)orig);
                PropertyUtils putils = new PropertyUtils();
                PropertyDescriptor[] origDescriptors = PropertyUtils.getPropertyDescriptors((Object)orig);
                for (int i = 0; i < origDescriptors.length; ++i) {
                    Class<?> propertyType;
                    String name = origDescriptors[i].getName();
                    if ("class".equals(name) || !Boolean.class.equals(propertyType = origDescriptors[i].getPropertyType()) && !Boolean.TYPE.equals(propertyType)) continue;
                    if (PropertyUtils.isReadable((Object)orig, (String)name)) continue;
                    Method m = orig.getClass().getMethod("is" + name.substring(0, 1).toUpperCase() + name.substring(1), null);
                    Object value = m.invoke(orig, null);
                    if (m == null) continue;
                    if (!PropertyUtils.isWriteable((Object)dest, (String)name)) continue;
                    BeanUtilsBean.getInstance().copyProperty(dest, name, value);
                }
            }
        }
        catch (Exception e) {
            throw new DJException("Could not copy properties for shared object: " + orig + ", message: " + e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        JRDesignStyle s1 = new Style().transform();
        JRDesignStyle s2 = new Style().transform();
        s1.setBold(Boolean.TRUE);
        s1.setItalic(Boolean.TRUE);
        s1.setUnderline(Boolean.TRUE);
        Utils.copyProperties(s2, s1);
        System.out.println(s2.isBold() + " - " + s2.isItalic() + " - " + s2.isUnderline());
    }

    public static String escapeTextForExpression(String text) {
        if (text == null) {
            return null;
        }
        text = text.replaceAll("\"", "\\\\\"");
        return text;
    }

    public static JRDesignStyle cloneStyle(JRDesignStyle style) {
        return (JRDesignStyle)style.clone();
    }
}

