/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.trans;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.trans.SideEffectChecker;
import EDU.purdue.cs.bloat.trans.ValueFolding;
import EDU.purdue.cs.bloat.tree.ArithExpr;
import EDU.purdue.cs.bloat.tree.CastExpr;
import EDU.purdue.cs.bloat.tree.CheckExpr;
import EDU.purdue.cs.bloat.tree.ConstantExpr;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.IfZeroStmt;
import EDU.purdue.cs.bloat.tree.InitStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.NegExpr;
import EDU.purdue.cs.bloat.tree.NewArrayExpr;
import EDU.purdue.cs.bloat.tree.NewExpr;
import EDU.purdue.cs.bloat.tree.NewMultiArrayExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.RCExpr;
import EDU.purdue.cs.bloat.tree.ReplaceVisitor;
import EDU.purdue.cs.bloat.tree.ShiftExpr;
import EDU.purdue.cs.bloat.tree.StoreExpr;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import EDU.purdue.cs.bloat.tree.UCExpr;
import EDU.purdue.cs.bloat.tree.ZeroCheckExpr;
import EDU.purdue.cs.bloat.util.Assert;
import EDU.purdue.cs.bloat.util.ResizeableArrayList;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;

class ValueFolder
extends TreeVisitor {
    Node node = null;
    ResizeableArrayList values;
    BitSet news;
    LocalExpr thisPtr;
    SideEffectChecker sideEffects;
    boolean replace;
    ArrayList clean;

    public ValueFolder(boolean replace, EditorContext context) {
        this.replace = replace;
        this.clean = new ArrayList();
        this.sideEffects = new SideEffectChecker(context);
        this.values = new ResizeableArrayList();
        this.news = new BitSet();
        this.thisPtr = null;
    }

    public void cleanup() {
        Iterator iter = ((AbstractList)this.clean).iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            node.cleanup();
        }
    }

    public Node replacement() {
        return this.node;
    }

    public void visitNode(Node node) {
    }

    public void visitLocalExpr(LocalExpr expr) {
        InitStmt stmt;
        MethodEditor method;
        if (this.thisPtr != null) {
            return;
        }
        if (expr.parent() instanceof InitStmt && !(method = (stmt = (InitStmt)expr.parent()).block().graph().method()).isStatic()) {
            Assert.isTrue(stmt.targets().length > 0);
            if (expr == stmt.targets()[0]) {
                this.thisPtr = expr;
                if (ValueFolding.DEBUG) {
                    System.out.println("this = " + this.thisPtr);
                }
            }
        }
    }

    public void visitPhiJoinStmt(PhiJoinStmt stmt) {
        if (!(stmt.target() instanceof LocalExpr)) {
            return;
        }
        int v = stmt.valueNumber();
        int ov = -1;
        Iterator iter = stmt.operands().iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            if (this.replace) {
                this.sideEffects.reset();
                expr.visit(this.sideEffects);
                if (this.sideEffects.hasSideEffects()) {
                    return;
                }
            }
            if (expr.valueNumber() == -1) continue;
            if (ov != -1 && expr.valueNumber() != ov) {
                return;
            }
            ov = expr.valueNumber();
        }
        if (ov == -1) {
            Assert.isFalse(this.replace && stmt.operands().size() == 0);
            ov = v;
        }
        this.values.ensureSize(Math.max(v, ov) + 1);
        ConstantExpr value = (ConstantExpr)this.values.get(ov);
        if (value != null) {
            this.node = value;
            this.values.set(v, value);
            if (this.replace) {
                stmt.block().tree().removeStmt(stmt);
            }
        }
    }

    public void visitStoreExpr(StoreExpr expr) {
        if (expr.expr() instanceof CheckExpr) {
            CheckExpr rc = (CheckExpr)expr.expr();
            if (this.replace) {
                Node parent = expr.parent();
                expr.visit(new ReplaceVisitor(rc, rc.expr()));
                rc.visit(new ReplaceVisitor(rc.expr(), expr));
                parent.visit(new ReplaceVisitor(expr, rc));
                this.node = rc;
            } else {
                this.node = null;
            }
            return;
        }
        if (expr.target() instanceof LocalExpr) {
            ConstantExpr rexpr;
            int v = expr.valueNumber();
            int lv = expr.target().valueNumber();
            int rv = expr.expr().valueNumber();
            int max = v;
            max = Math.max(max, lv);
            max = Math.max(max, rv);
            this.values.ensureSize(max + 1);
            boolean reffects = false;
            if (this.replace) {
                this.sideEffects.reset();
                expr.expr().visit(this.sideEffects);
                reffects = this.sideEffects.hasSideEffects();
            }
            if ((rexpr = (ConstantExpr)this.values.get(rv)) != null) {
                if (!this.replace) {
                    this.node = rexpr;
                    this.values.set(v, this.node);
                } else if (!reffects && expr.target().uses().size() == 0) {
                    this.node = new ConstantExpr(rexpr.value(), expr.type());
                    this.node.setValueNumber(v);
                    this.values.set(v, this.node);
                    expr.replaceWith(this.node);
                }
            }
        }
    }

    public void visitNewMultiArrayExpr(NewMultiArrayExpr expr) {
        if (expr.valueNumber() != -1) {
            if (ValueFolding.DEBUG) {
                System.out.println("New " + expr);
            }
            this.news.set(expr.valueNumber());
        }
    }

    public void visitNewArrayExpr(NewArrayExpr expr) {
        if (expr.valueNumber() != -1) {
            if (ValueFolding.DEBUG) {
                System.out.println("New " + expr);
            }
            this.news.set(expr.valueNumber());
        }
    }

    public void visitNewExpr(NewExpr expr) {
        if (expr.valueNumber() != -1) {
            if (ValueFolding.DEBUG) {
                System.out.println("New " + expr);
            }
            this.news.set(expr.valueNumber());
        }
    }

    public void visitRCExpr(RCExpr expr) {
        boolean move = false;
        int v = expr.expr().valueNumber();
        if (expr.expr() instanceof RCExpr) {
            move = true;
            if (ValueFolding.DEBUG) {
                System.out.println("folding redundant rc in " + expr);
            }
        } else if (v != -1) {
            if (this.thisPtr != null && this.thisPtr.valueNumber() == v) {
                move = true;
                if (ValueFolding.DEBUG) {
                    System.out.println("folding rc(this) = " + expr);
                }
            } else if (this.news.get(v)) {
                move = true;
                if (ValueFolding.DEBUG) {
                    System.out.println("folding rc(new) = " + expr);
                }
            }
        }
        if (move) {
            this.node = expr.expr();
            if (this.replace) {
                this.node.setParent(null);
                expr.replaceWith(this.node, false);
                expr.cleanupOnly();
            }
        }
    }

    public void visitZeroCheckExpr(ZeroCheckExpr expr) {
        boolean move = false;
        int v = expr.expr().valueNumber();
        if (expr.expr() instanceof ZeroCheckExpr) {
            move = true;
            if (ValueFolding.DEBUG) {
                System.out.println("folding redundant ZeroCheck in " + expr);
            }
        } else if (v != -1) {
            if (this.thisPtr != null && this.thisPtr.valueNumber() == v) {
                move = true;
                if (ValueFolding.DEBUG) {
                    System.out.println("folding ZeroCheck(this) = " + expr);
                }
            } else if (this.news.get(v)) {
                move = true;
                if (ValueFolding.DEBUG) {
                    System.out.println("folding ZeroCheck(new) = " + expr);
                }
            } else {
                ConstantExpr eexpr = null;
                if (v < this.values.size()) {
                    eexpr = (ConstantExpr)this.values.get(v);
                }
                if (eexpr != null) {
                    Object value = eexpr.value();
                    if (value instanceof Long) {
                        if ((Long)value != 0L) {
                            move = true;
                        }
                    } else if (value instanceof Byte || value instanceof Short || value instanceof Integer) {
                        if (((Number)value).intValue() != 0) {
                            move = true;
                        }
                    } else if (value instanceof Character && ((Character)value).charValue() != '\u0000') {
                        move = true;
                    }
                }
            }
        }
        if (move) {
            this.node = expr.expr();
            if (this.replace) {
                this.node.setParent(null);
                expr.replaceWith(this.node, false);
                expr.cleanupOnly();
            }
        }
    }

    public void visitUCExpr(UCExpr expr) {
        UCExpr uc;
        if (expr.expr() instanceof UCExpr && (uc = (UCExpr)expr.expr()).kind() == expr.kind()) {
            this.node = uc;
            if (this.replace) {
                expr.visit(new ReplaceVisitor(uc, uc.expr()));
                uc.cleanupOnly();
            }
        }
    }

    public void visitArithExpr(ArithExpr expr) {
        if (expr.left().type().isIntegral()) {
            this.foldArithInteger(expr);
        } else if (expr.left().type().equals(Type.LONG)) {
            this.foldArithLong(expr);
        } else if (expr.left().type().equals(Type.FLOAT)) {
            this.foldArithFloat(expr);
        } else if (expr.left().type().equals(Type.DOUBLE)) {
            this.foldArithDouble(expr);
        }
    }

    private void foldArithInteger(ArithExpr expr) {
        block60: {
            boolean leffects;
            ConstantExpr rexpr;
            ConstantExpr lexpr;
            int v;
            block61: {
                boolean reffects;
                block59: {
                    v = expr.valueNumber();
                    int lv = expr.left().valueNumber();
                    int rv = expr.right().valueNumber();
                    int max = v;
                    max = Math.max(max, lv);
                    max = Math.max(max, rv);
                    this.values.ensureSize(max + 1);
                    lexpr = null;
                    rexpr = null;
                    if (lv >= 0 && lv >= 0 && lv < this.values.size()) {
                        lexpr = (ConstantExpr)this.values.get(lv);
                    }
                    if (rv >= 0 && rv >= 0 && rv < this.values.size()) {
                        rexpr = (ConstantExpr)this.values.get(rv);
                    }
                    leffects = false;
                    reffects = false;
                    if (this.replace) {
                        this.sideEffects.reset();
                        expr.left().visit(this.sideEffects);
                        leffects = this.sideEffects.hasSideEffects();
                        this.sideEffects.reset();
                        expr.right().visit(this.sideEffects);
                        reffects = this.sideEffects.hasSideEffects();
                    }
                    if (lexpr == null || rexpr == null || leffects || reffects) break block59;
                    Integer value = null;
                    int lval = ((Number)lexpr.value()).intValue();
                    int rval = ((Number)rexpr.value()).intValue();
                    switch (expr.operation()) {
                        case 43: {
                            value = new Integer(lval + rval);
                            break;
                        }
                        case 38: {
                            value = new Integer(lval & rval);
                            break;
                        }
                        case 47: {
                            if (rval == 0) break;
                            value = new Integer(lval / rval);
                            break;
                        }
                        case 42: {
                            value = new Integer(lval * rval);
                            break;
                        }
                        case 124: {
                            value = new Integer(lval | rval);
                            break;
                        }
                        case 37: {
                            if (rval == 0) break;
                            value = new Integer(lval % rval);
                            break;
                        }
                        case 45: {
                            value = new Integer(lval - rval);
                            break;
                        }
                        case 94: {
                            value = new Integer(lval ^ rval);
                            break;
                        }
                    }
                    if (value != null) {
                        this.node = new ConstantExpr(value, expr.type());
                        this.node.setValueNumber(v);
                        this.values.set(v, this.node);
                        if (this.replace) {
                            expr.replaceWith(this.node);
                        }
                    }
                    break block60;
                }
                if (lexpr != null || rexpr == null || reffects) break block61;
                int rval = ((Number)rexpr.value()).intValue();
                block10 : switch (rval) {
                    case 0: {
                        switch (expr.operation()) {
                            case 43: 
                            case 45: 
                            case 124: {
                                this.node = expr.left();
                                if (this.replace) {
                                    this.node.setParent(null);
                                    expr.replaceWith(this.node, false);
                                    expr.right().cleanup();
                                    expr.cleanupOnly();
                                    break;
                                }
                                break block60;
                            }
                            case 38: 
                            case 42: {
                                this.node = new ConstantExpr(new Integer(0), expr.type());
                                this.node.setValueNumber(v);
                                this.values.set(v, this.node);
                                if (!this.replace) break block60;
                                expr.replaceWith(this.node);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block60;
                    }
                    case 1: {
                        switch (expr.operation()) {
                            case 42: 
                            case 47: {
                                this.node = expr.left();
                                if (this.replace) {
                                    this.node.setParent(null);
                                    expr.replaceWith(this.node, false);
                                    expr.right().cleanup();
                                    expr.cleanupOnly();
                                    break;
                                }
                                break block60;
                            }
                            case 37: {
                                this.node = new ConstantExpr(new Integer(0), expr.type());
                                this.node.setValueNumber(v);
                                this.values.set(v, this.node);
                                if (!this.replace) break block60;
                                expr.replaceWith(this.node);
                            }
                            default: {
                                break;
                            }
                            {
                            }
                        }
                        break block60;
                    }
                    case -1: {
                        switch (expr.operation()) {
                            case 42: 
                            case 47: {
                                if (this.replace) {
                                    expr.left().setParent(null);
                                    this.node = new NegExpr(expr.left(), expr.type());
                                    this.node.setValueNumber(v);
                                    expr.replaceWith(this.node, false);
                                    expr.right().cleanup();
                                    expr.cleanupOnly();
                                    break block10;
                                }
                                this.node = new NegExpr((Expr)expr.left().clone(), expr.type());
                                this.node.setValueNumber(v);
                                this.clean.add(this.node);
                            }
                        }
                    }
                }
                break block60;
            }
            if (lexpr != null && rexpr == null && !leffects) {
                int lval = ((Number)lexpr.value()).intValue();
                block26 : switch (lval) {
                    case 0: {
                        switch (expr.operation()) {
                            case 43: 
                            case 124: {
                                this.node = expr.right();
                                if (!this.replace) break;
                                this.node.setParent(null);
                                expr.replaceWith(this.node, false);
                                expr.left().cleanup();
                                expr.cleanupOnly();
                                break;
                            }
                            case 45: {
                                if (this.replace) {
                                    expr.right().setParent(null);
                                    this.node = new NegExpr(expr.right(), expr.type());
                                    this.node.setValueNumber(v);
                                    expr.replaceWith(this.node, false);
                                    expr.left().cleanup();
                                    expr.cleanupOnly();
                                    break;
                                }
                                this.node = new NegExpr((Expr)expr.right().clone(), expr.type());
                                this.node.setValueNumber(v);
                                this.clean.add(this.node);
                                break;
                            }
                            case 38: 
                            case 42: {
                                this.node = new ConstantExpr(new Integer(0), expr.type());
                                this.node.setValueNumber(v);
                                this.values.set(v, this.node);
                                if (!this.replace) break;
                                expr.replaceWith(this.node);
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (expr.operation()) {
                            case 42: {
                                this.node = expr.right();
                                if (!this.replace) break;
                                this.node.setParent(null);
                                expr.replaceWith(this.node, false);
                                expr.left().cleanup();
                                expr.cleanupOnly();
                            }
                        }
                        break;
                    }
                    case -1: {
                        switch (expr.operation()) {
                            case 42: {
                                if (this.replace) {
                                    expr.right().setParent(null);
                                    this.node = new NegExpr(expr.right(), expr.type());
                                    this.node.setValueNumber(v);
                                    expr.replaceWith(this.node, false);
                                    expr.left().cleanup();
                                    expr.cleanupOnly();
                                    break block26;
                                }
                                this.node = new NegExpr((Expr)expr.right().clone(), expr.type());
                                this.node.setValueNumber(v);
                                this.clean.add(this.node);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void foldArithLong(ArithExpr expr) {
        int v = expr.valueNumber();
        int lv = expr.left().valueNumber();
        int rv = expr.right().valueNumber();
        int max = v;
        max = Math.max(max, lv);
        max = Math.max(max, rv);
        this.values.ensureSize(max + 1);
        ConstantExpr lexpr = null;
        ConstantExpr rexpr = null;
        if (lv >= 0 && lv < this.values.size()) {
            lexpr = (ConstantExpr)this.values.get(lv);
        }
        if (rv >= 0 && rv < this.values.size()) {
            rexpr = (ConstantExpr)this.values.get(rv);
        }
        boolean leffects = false;
        boolean reffects = false;
        if (this.replace) {
            this.sideEffects.reset();
            expr.left().visit(this.sideEffects);
            leffects = this.sideEffects.hasSideEffects();
            this.sideEffects.reset();
            expr.right().visit(this.sideEffects);
            reffects = this.sideEffects.hasSideEffects();
        }
        if (lexpr != null && rexpr != null && !leffects && !reffects) {
            void var10_22;
            Object var10_10 = null;
            long lval = (Long)lexpr.value();
            long rval = (Long)rexpr.value();
            switch (expr.operation()) {
                case 43: {
                    Long l = new Long(lval + rval);
                    break;
                }
                case 38: {
                    Long l = new Long(lval & rval);
                    break;
                }
                case 47: {
                    if (rval == 0L) break;
                    Long l = new Long(lval / rval);
                    break;
                }
                case 42: {
                    Long l = new Long(lval * rval);
                    break;
                }
                case 124: {
                    Long l = new Long(lval | rval);
                    break;
                }
                case 37: {
                    if (rval == 0L) break;
                    Long l = new Long(lval % rval);
                    break;
                }
                case 45: {
                    Long l = new Long(lval - rval);
                    break;
                }
                case 94: {
                    Long l = new Long(lval ^ rval);
                    break;
                }
                case 63: {
                    if (lval > rval) {
                        Integer n = new Integer(1);
                        break;
                    }
                    if (lval < rval) {
                        Integer n = new Integer(-1);
                        break;
                    }
                    Integer n = new Integer(0);
                    break;
                }
            }
            if (var10_22 == null) return;
            this.node = new ConstantExpr(var10_22, expr.type());
            this.node.setValueNumber(v);
            this.values.set(v, this.node);
            if (!this.replace) return;
            expr.replaceWith(this.node);
            return;
        } else if (lexpr == null && rexpr != null) {
            long l = (Long)rexpr.value();
            if (reffects) {
                return;
            }
            if (l == 0L) {
                switch (expr.operation()) {
                    case 43: 
                    case 45: 
                    case 124: {
                        this.node = expr.left();
                        if (!this.replace) return;
                        this.node.setParent(null);
                        expr.replaceWith(this.node, false);
                        expr.right().cleanup();
                        expr.cleanupOnly();
                        return;
                    }
                    case 38: 
                    case 42: {
                        this.node = new ConstantExpr(new Long(0L), expr.type());
                        this.node.setValueNumber(v);
                        this.values.set(v, this.node);
                        if (!this.replace) return;
                        expr.replaceWith(this.node);
                    }
                    default: {
                        return;
                    }
                }
            } else if (l == 1L) {
                switch (expr.operation()) {
                    case 42: 
                    case 47: {
                        this.node = expr.left();
                        if (!this.replace) return;
                        this.node.setParent(null);
                        expr.replaceWith(this.node, false);
                        expr.right().cleanup();
                        expr.cleanupOnly();
                        return;
                    }
                    case 37: {
                        this.node = new ConstantExpr(new Long(0L), expr.type());
                        this.node.setValueNumber(v);
                        this.values.set(v, this.node);
                        if (!this.replace) return;
                        expr.replaceWith(this.node);
                    }
                    default: {
                        return;
                    }
                }
            } else {
                if (l != -1L) return;
                switch (expr.operation()) {
                    case 42: 
                    case 47: {
                        if (this.replace) {
                            expr.left().setParent(null);
                            this.node = new NegExpr(expr.left(), Type.LONG);
                            this.node.setValueNumber(v);
                            expr.replaceWith(this.node, false);
                            expr.right().cleanup();
                            expr.cleanupOnly();
                            return;
                        }
                        this.node = new NegExpr((Expr)expr.left().clone(), Type.LONG);
                        this.node.setValueNumber(v);
                        this.clean.add(this.node);
                    }
                    default: {
                        return;
                    }
                }
            }
        } else {
            if (lexpr == null || rexpr != null) return;
            long l = (Long)lexpr.value();
            if (l == 0L) {
                switch (expr.operation()) {
                    case 43: 
                    case 124: {
                        this.node = expr.right();
                        if (!this.replace) return;
                        this.node.setParent(null);
                        expr.replaceWith(this.node, false);
                        expr.left().cleanup();
                        expr.cleanupOnly();
                        return;
                    }
                    case 45: {
                        if (this.replace) {
                            expr.right().setParent(null);
                            this.node = new NegExpr(expr.right(), Type.LONG);
                            this.node.setValueNumber(v);
                            expr.replaceWith(this.node, false);
                            expr.left().cleanup();
                            expr.cleanupOnly();
                            return;
                        }
                        this.node = new NegExpr((Expr)expr.right().clone(), Type.LONG);
                        this.node.setValueNumber(v);
                        this.clean.add(this.node);
                        return;
                    }
                    case 38: 
                    case 42: {
                        this.node = new ConstantExpr(new Long(0L), expr.type());
                        this.node.setValueNumber(v);
                        this.values.set(v, this.node);
                        if (!this.replace) return;
                        expr.replaceWith(this.node);
                    }
                    default: {
                        return;
                    }
                }
            } else if (l == 1L) {
                switch (expr.operation()) {
                    case 42: {
                        this.node = expr.right();
                        if (!this.replace) return;
                        this.node.setParent(null);
                        expr.replaceWith(this.node, false);
                        expr.left().cleanup();
                        expr.cleanupOnly();
                    }
                    default: {
                        return;
                    }
                }
            } else {
                if (l != -1L) return;
                switch (expr.operation()) {
                    case 42: {
                        if (this.replace) {
                            expr.right().setParent(null);
                            this.node = new NegExpr(expr.right(), Type.LONG);
                            this.node.setValueNumber(v);
                            expr.replaceWith(this.node, false);
                            expr.left().cleanup();
                            expr.cleanupOnly();
                            return;
                        }
                        this.node = new NegExpr((Expr)expr.right().clone(), Type.LONG);
                        this.node.setValueNumber(v);
                        this.clean.add(this.node);
                    }
                }
            }
        }
    }

    private void foldArithFloat(ArithExpr expr) {
        int v = expr.valueNumber();
        int lv = expr.left().valueNumber();
        int rv = expr.right().valueNumber();
        int max = v;
        max = Math.max(max, lv);
        max = Math.max(max, rv);
        this.values.ensureSize(max + 1);
        ConstantExpr lexpr = null;
        ConstantExpr rexpr = null;
        if (lv >= 0 && lv < this.values.size()) {
            lexpr = (ConstantExpr)this.values.get(lv);
        }
        if (rv >= 0 && rv < this.values.size()) {
            rexpr = (ConstantExpr)this.values.get(rv);
        }
        if (lexpr == null || rexpr == null) {
            return;
        }
        Float rvalue = (Float)rexpr.value();
        Float lvalue = (Float)lexpr.value();
        if (lvalue.isNaN() || lvalue.isInfinite()) {
            return;
        }
        if (rvalue.isNaN() || rvalue.isInfinite()) {
            return;
        }
        boolean leffects = false;
        boolean reffects = false;
        if (this.replace) {
            this.sideEffects.reset();
            expr.left().visit(this.sideEffects);
            leffects = this.sideEffects.hasSideEffects();
            this.sideEffects.reset();
            expr.right().visit(this.sideEffects);
            reffects = this.sideEffects.hasSideEffects();
            if (leffects || reffects) {
                return;
            }
        }
        Number value = null;
        float lval = lvalue.floatValue();
        float rval = rvalue.floatValue();
        switch (expr.operation()) {
            case 43: {
                value = new Float(lval + rval);
                break;
            }
            case 47: {
                value = new Float(lval / rval);
                break;
            }
            case 42: {
                value = new Float(lval * rval);
                break;
            }
            case 37: {
                value = new Float(lval % rval);
                break;
            }
            case 45: {
                value = new Float(lval - rval);
                break;
            }
            case 63: {
                if (lval > rval) {
                    value = new Integer(1);
                    break;
                }
                if (lval < rval) {
                    value = new Integer(-1);
                    break;
                }
                value = new Integer(0);
                break;
            }
        }
        if (value != null) {
            this.node = new ConstantExpr(value, expr.type());
            this.node.setValueNumber(v);
            this.values.set(v, this.node);
            if (this.replace) {
                expr.replaceWith(this.node);
            }
        }
    }

    private void foldArithDouble(ArithExpr expr) {
        int v = expr.valueNumber();
        int lv = expr.left().valueNumber();
        int rv = expr.right().valueNumber();
        int max = v;
        max = Math.max(max, lv);
        max = Math.max(max, rv);
        this.values.ensureSize(max + 1);
        ConstantExpr lexpr = null;
        ConstantExpr rexpr = null;
        if (lv >= 0 && lv < this.values.size()) {
            lexpr = (ConstantExpr)this.values.get(lv);
        }
        if (rv >= 0 && rv < this.values.size()) {
            rexpr = (ConstantExpr)this.values.get(rv);
        }
        if (lexpr == null || rexpr == null) {
            return;
        }
        Double rvalue = (Double)rexpr.value();
        Double lvalue = (Double)lexpr.value();
        if (lvalue.isNaN() || lvalue.isInfinite()) {
            return;
        }
        if (rvalue.isNaN() || rvalue.isInfinite()) {
            return;
        }
        boolean leffects = false;
        boolean reffects = false;
        if (this.replace) {
            this.sideEffects.reset();
            expr.left().visit(this.sideEffects);
            leffects = this.sideEffects.hasSideEffects();
            this.sideEffects.reset();
            expr.right().visit(this.sideEffects);
            reffects = this.sideEffects.hasSideEffects();
            if (leffects || reffects) {
                return;
            }
        }
        Number value = null;
        double lval = lvalue;
        double rval = rvalue;
        switch (expr.operation()) {
            case 43: {
                value = new Double(lval + rval);
                break;
            }
            case 47: {
                value = new Double(lval / rval);
                break;
            }
            case 42: {
                value = new Double(lval * rval);
                break;
            }
            case 37: {
                value = new Double(lval % rval);
                break;
            }
            case 45: {
                value = new Double(lval - rval);
                break;
            }
            case 63: {
                if (lval > rval) {
                    value = new Integer(1);
                    break;
                }
                if (lval < rval) {
                    value = new Integer(-1);
                    break;
                }
                value = new Integer(0);
                break;
            }
        }
        if (value != null) {
            this.node = new ConstantExpr(value, expr.type());
            this.node.setValueNumber(v);
            this.values.set(v, this.node);
            if (this.replace) {
                expr.replaceWith(this.node);
            }
        }
    }

    public void visitCastExpr(CastExpr expr) {
        Object evalue;
        int v = expr.valueNumber();
        int ev = expr.expr().valueNumber();
        this.values.ensureSize(Math.max(v, ev) + 1);
        ConstantExpr eexpr = null;
        if (ev >= 0 && ev < this.values.size()) {
            eexpr = (ConstantExpr)this.values.get(ev);
        }
        if (eexpr == null) {
            return;
        }
        if (this.replace) {
            this.sideEffects.reset();
            expr.expr().visit(this.sideEffects);
            boolean effects = this.sideEffects.hasSideEffects();
            if (effects) {
                return;
            }
        }
        if ((evalue = eexpr.value()) instanceof String && expr.castType().equals(Type.STRING)) {
            this.node = new ConstantExpr(evalue, expr.castType());
            this.node.setValueNumber(v);
            this.values.set(v, this.node);
            if (this.replace) {
                expr.replaceWith(this.node);
            }
            return;
        }
        if (expr.castType().isReference()) {
            if (evalue == null && expr.castType().isReference()) {
                this.node = new ConstantExpr(null, expr.castType());
                this.node.setValueNumber(v);
                this.values.set(v, this.node);
                if (this.replace) {
                    expr.replaceWith(this.node);
                }
            }
            return;
        }
    }

    public void visitNegExpr(NegExpr expr) {
        int v = expr.valueNumber();
        int ev = expr.expr().valueNumber();
        this.values.ensureSize(Math.max(v, ev) + 1);
        ConstantExpr eexpr = null;
        if (ev >= 0 && ev < this.values.size()) {
            eexpr = (ConstantExpr)this.values.get(ev);
        }
        if (eexpr != null) {
            Number evalue = (Number)eexpr.value();
            boolean eeffects = false;
            if (this.replace) {
                this.sideEffects.reset();
                expr.expr().visit(this.sideEffects);
                eeffects = this.sideEffects.hasSideEffects();
            }
            if (!eeffects) {
                Number value = null;
                if (evalue instanceof Integer) {
                    value = new Integer(-evalue.intValue());
                } else if (value instanceof Long) {
                    value = new Long(-evalue.longValue());
                } else if (value instanceof Float) {
                    value = new Float(-evalue.floatValue());
                } else if (value instanceof Double) {
                    value = new Double(-evalue.doubleValue());
                }
                if (value != null) {
                    this.node = new ConstantExpr(value, expr.type());
                    this.node.setValueNumber(v);
                    this.values.set(v, this.node);
                    if (this.replace) {
                        expr.replaceWith(this.node);
                    }
                    return;
                }
            }
        }
        if (expr.expr() instanceof NegExpr) {
            NegExpr neg = (NegExpr)expr.expr();
            this.node = neg.expr();
            if (this.replace) {
                expr.parent().visit(new ReplaceVisitor(expr, this.node));
                expr.cleanupOnly();
                neg.cleanupOnly();
            }
        }
    }

    public void visitShiftExpr(ShiftExpr expr) {
        int v = expr.valueNumber();
        int ev = expr.expr().valueNumber();
        int bv = expr.bits().valueNumber();
        int max = v;
        max = Math.max(max, ev);
        max = Math.max(max, bv);
        this.values.ensureSize(max + 1);
        ConstantExpr eexpr = null;
        ConstantExpr bexpr = null;
        if (ev >= 0 && ev < this.values.size()) {
            eexpr = (ConstantExpr)this.values.get(ev);
        }
        if (bv >= 0 && bv < this.values.size()) {
            bexpr = (ConstantExpr)this.values.get(bv);
        }
        Object evalue = null;
        Object bvalue = null;
        boolean eeffects = false;
        boolean beffects = false;
        if (eexpr != null) {
            evalue = eexpr.value();
        }
        if (bexpr != null) {
            bvalue = bexpr.value();
        }
        if (this.replace) {
            this.sideEffects.reset();
            expr.expr().visit(this.sideEffects);
            eeffects = this.sideEffects.hasSideEffects();
            this.sideEffects.reset();
            expr.bits().visit(this.sideEffects);
            beffects = this.sideEffects.hasSideEffects();
        }
        if (eexpr == null && bexpr != null) {
            if ((bvalue.equals(new Integer(0)) || bvalue.equals(new Long(0L))) && !beffects) {
                this.node = expr.expr();
                if (this.replace) {
                    this.node.setParent(null);
                    expr.replaceWith(this.node, false);
                    expr.bits().cleanup();
                    expr.cleanupOnly();
                }
            }
            return;
        }
        if (beffects) {
            return;
        }
        Object value = null;
        if (evalue instanceof Integer) {
            int eval = (Integer)evalue;
            if (eval == 0) {
                value = evalue;
            } else if (bvalue instanceof Integer) {
                if (this.replace && eeffects) {
                    return;
                }
                int bval = (Integer)bvalue;
                switch (expr.dir()) {
                    case 0: {
                        value = new Integer(eval << bval);
                        break;
                    }
                    case 1: {
                        value = new Integer(eval >> bval);
                        break;
                    }
                    case 2: {
                        value = new Integer(eval >>> bval);
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (evalue instanceof Long) {
            long eval = (Long)evalue;
            if (eval == 0L) {
                value = evalue;
            } else if (bvalue instanceof Integer) {
                if (this.replace && eeffects) {
                    return;
                }
                int bval = (Integer)bvalue;
                switch (expr.dir()) {
                    case 0: {
                        value = new Long(eval << bval);
                        break;
                    }
                    case 1: {
                        value = new Long(eval >> bval);
                        break;
                    }
                    case 2: {
                        value = new Long(eval >>> bval);
                    }
                }
            }
        }
        if (value != null) {
            this.node = new ConstantExpr(value, expr.type());
            this.node.setValueNumber(v);
            this.values.set(v, this.node);
            if (this.replace) {
                expr.replaceWith(this.node);
            }
        }
    }

    public void visitIfZeroStmt(IfZeroStmt stmt) {
        Block block = stmt.block();
        FlowGraph cfg = block.graph();
        int v = stmt.valueNumber();
        int ev = stmt.expr().valueNumber();
        this.values.ensureSize(Math.max(ev, v) + 1);
        ConstantExpr eexpr = null;
        if (ev >= 0 && ev < this.values.size()) {
            eexpr = (ConstantExpr)this.values.get(ev);
        }
        if (eexpr == null) {
            return;
        }
        Object evalue = eexpr.value();
        boolean eeffects = false;
        if (this.replace) {
            this.sideEffects.reset();
            stmt.expr().visit(this.sideEffects);
            eeffects = this.sideEffects.hasSideEffects();
            if (eeffects) {
                return;
            }
        }
        if (evalue instanceof Integer) {
            boolean result;
            int eval = (Integer)evalue;
            switch (stmt.comparison()) {
                case 0: {
                    result = eval == 0;
                    break;
                }
                case 1: {
                    result = eval != 0;
                    break;
                }
                case 2: {
                    result = eval > 0;
                    break;
                }
                case 3: {
                    result = eval >= 0;
                    break;
                }
                case 4: {
                    result = eval < 0;
                    break;
                }
                case 5: {
                    result = eval <= 0;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (result) {
                GotoStmt jump = new GotoStmt(stmt.trueTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                if (this.replace) {
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.falseTarget());
                }
            } else {
                GotoStmt jump = new GotoStmt(stmt.falseTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                if (this.replace) {
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.trueTarget());
                }
            }
        } else if (evalue == null) {
            switch (stmt.comparison()) {
                case 0: {
                    GotoStmt jump = new GotoStmt(stmt.trueTarget());
                    jump.catchTargets().addAll(stmt.catchTargets());
                    this.node = jump;
                    this.node.setValueNumber(v);
                    if (!this.replace) break;
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.falseTarget());
                    break;
                }
                case 1: {
                    GotoStmt jump = new GotoStmt(stmt.falseTarget());
                    jump.catchTargets().addAll(stmt.catchTargets());
                    this.node = jump;
                    this.node.setValueNumber(v);
                    if (!this.replace) break;
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.trueTarget());
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    public void visitIfCmpStmt(IfCmpStmt stmt) {
        int cmp;
        int rval;
        int lval;
        Block block = stmt.block();
        FlowGraph cfg = block.graph();
        int v = stmt.valueNumber();
        int lv = stmt.left().valueNumber();
        int rv = stmt.right().valueNumber();
        int max = v;
        max = Math.max(max, lv);
        max = Math.max(max, rv);
        this.values.ensureSize(max + 1);
        ConstantExpr lexpr = null;
        ConstantExpr rexpr = null;
        if (lv >= 0 && lv < this.values.size()) {
            lexpr = (ConstantExpr)this.values.get(lv);
        }
        if (rv >= 0 && rv < this.values.size()) {
            rexpr = (ConstantExpr)this.values.get(rv);
        }
        Object lvalue = null;
        Object rvalue = null;
        if (lexpr != null) {
            lvalue = lexpr.value();
        }
        if (rexpr != null) {
            rvalue = rexpr.value();
        }
        boolean leffects = false;
        boolean reffects = false;
        if (this.replace) {
            this.sideEffects.reset();
            stmt.left().visit(this.sideEffects);
            leffects = this.sideEffects.hasSideEffects();
            this.sideEffects.reset();
            stmt.right().visit(this.sideEffects);
            reffects = this.sideEffects.hasSideEffects();
        }
        if (lvalue instanceof Integer && !leffects && (lval = ((Integer)lvalue).intValue()) == 0 && !(rvalue instanceof Integer) && !reffects) {
            int cmp2;
            switch (stmt.comparison()) {
                case 0: {
                    cmp2 = 0;
                    break;
                }
                case 1: {
                    cmp2 = 1;
                    break;
                }
                case 4: {
                    cmp2 = 2;
                    break;
                }
                case 5: {
                    cmp2 = 3;
                    break;
                }
                case 2: {
                    cmp2 = 4;
                    break;
                }
                case 3: {
                    cmp2 = 5;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (this.replace) {
                IfZeroStmt jump = new IfZeroStmt(cmp2, (Expr)stmt.right().clone(), stmt.trueTarget(), stmt.falseTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                stmt.replaceWith(this.node);
            } else {
                this.node = null;
            }
            return;
        }
        if (rvalue instanceof Integer && !reffects && (rval = ((Integer)rvalue).intValue()) == 0 && !(lvalue instanceof Integer) && !leffects) {
            int cmp3 = stmt.comparison();
            if (this.replace) {
                IfZeroStmt jump = new IfZeroStmt(cmp3, (Expr)stmt.left().clone(), stmt.trueTarget(), stmt.falseTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                stmt.replaceWith(this.node);
            } else {
                this.node = null;
            }
            return;
        }
        if (lexpr != null && lvalue == null && !leffects && (rexpr == null || rvalue != null || reffects)) {
            cmp = stmt.comparison();
            if (this.replace) {
                IfZeroStmt jump = new IfZeroStmt(cmp, (Expr)stmt.right().clone(), stmt.trueTarget(), stmt.falseTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                stmt.replaceWith(this.node);
            } else {
                this.node = null;
            }
            return;
        }
        if (rexpr != null && rvalue == null && !reffects && (lexpr == null || lvalue != null || leffects)) {
            cmp = stmt.comparison();
            if (this.replace) {
                IfZeroStmt jump = new IfZeroStmt(cmp, (Expr)stmt.left().clone(), stmt.trueTarget(), stmt.falseTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                stmt.replaceWith(this.node);
            } else {
                this.node = null;
            }
            return;
        }
        if (leffects || reffects) {
            return;
        }
        if (lexpr == null || rexpr == null) {
            return;
        }
        if (lvalue instanceof Integer && rvalue instanceof Integer) {
            boolean result;
            int lval2 = (Integer)lvalue;
            int rval2 = (Integer)rvalue;
            switch (stmt.comparison()) {
                case 0: {
                    result = lval2 == rval2;
                    break;
                }
                case 1: {
                    result = lval2 != rval2;
                    break;
                }
                case 2: {
                    result = lval2 > rval2;
                    break;
                }
                case 3: {
                    result = lval2 >= rval2;
                    break;
                }
                case 4: {
                    result = lval2 < rval2;
                    break;
                }
                case 5: {
                    result = lval2 <= rval2;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            if (result) {
                GotoStmt jump = new GotoStmt(stmt.trueTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                if (this.replace) {
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.falseTarget());
                }
            } else {
                GotoStmt jump = new GotoStmt(stmt.falseTarget());
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                if (this.replace) {
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.trueTarget());
                }
            }
        } else if (lvalue == null && rvalue == null) {
            switch (stmt.comparison()) {
                case 0: {
                    GotoStmt jump = new GotoStmt(stmt.trueTarget());
                    jump.catchTargets().addAll(stmt.catchTargets());
                    this.node = jump;
                    this.node.setValueNumber(v);
                    if (!this.replace) break;
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.falseTarget());
                    break;
                }
                case 1: {
                    GotoStmt jump = new GotoStmt(stmt.falseTarget());
                    jump.catchTargets().addAll(stmt.catchTargets());
                    this.node = jump;
                    this.node.setValueNumber(v);
                    if (!this.replace) break;
                    stmt.replaceWith(this.node);
                    cfg.removeEdge(block, stmt.trueTarget());
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        GotoStmt jump;
        Block block = stmt.block();
        FlowGraph cfg = block.graph();
        int v = stmt.valueNumber();
        int iv = stmt.index().valueNumber();
        this.values.ensureSize(Math.max(v, iv) + 1);
        ConstantExpr iexpr = null;
        if (iv >= 0 && iv < this.values.size()) {
            iexpr = (ConstantExpr)this.values.get(iv);
        }
        boolean ieffects = false;
        if (this.replace) {
            this.sideEffects.reset();
            stmt.index().visit(this.sideEffects);
            ieffects = this.sideEffects.hasSideEffects();
            if (ieffects) {
                return;
            }
        }
        if (iexpr == null) {
            return;
        }
        if (!(iexpr.value() instanceof Integer)) {
            return;
        }
        Integer ivalue = (Integer)iexpr.value();
        int ival = ivalue;
        boolean useDefault = true;
        int i = 0;
        while (i < stmt.values().length) {
            if (stmt.values()[i] == ival) {
                jump = new GotoStmt(stmt.targets()[i]);
                jump.catchTargets().addAll(stmt.catchTargets());
                this.node = jump;
                this.node.setValueNumber(v);
                if (this.replace) {
                    stmt.replaceWith(this.node);
                }
                useDefault = false;
            } else if (this.replace) {
                cfg.removeEdge(block, stmt.targets()[i]);
            }
            ++i;
        }
        if (useDefault) {
            jump = new GotoStmt(stmt.defaultTarget());
            jump.catchTargets().addAll(stmt.catchTargets());
            this.node = jump;
            this.node.setValueNumber(v);
            if (this.replace) {
                stmt.replaceWith(this.node);
            }
        } else if (this.replace) {
            cfg.removeEdge(block, stmt.defaultTarget());
        }
    }

    void printValueNumbers(PrintWriter pw) {
        if (pw == null) {
            return;
        }
        Iterator iter = ((AbstractList)this.values).iterator();
        pw.println("Value Numbers mapped to constants\n");
        int i = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o != null) {
                pw.println(String.valueOf(i) + " -> " + o);
            }
            ++i;
        }
    }
}

