/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.tree.Assign;
import EDU.purdue.cs.bloat.tree.DefExpr;
import EDU.purdue.cs.bloat.tree.StackExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.TreeVisitor;

public class StackManipStmt
extends Stmt
implements Assign {
    StackExpr[] target;
    StackExpr[] source;
    int kind;
    public static final int SWAP = 0;
    public static final int DUP = 1;
    public static final int DUP_X1 = 2;
    public static final int DUP_X2 = 3;
    public static final int DUP2 = 4;
    public static final int DUP2_X1 = 5;
    public static final int DUP2_X2 = 6;

    public StackManipStmt(StackExpr[] target, StackExpr[] source, int kind) {
        this.kind = kind;
        this.target = target;
        int i = 0;
        while (i < target.length) {
            this.target[i].setParent(this);
            ++i;
        }
        this.source = source;
        i = 0;
        while (i < source.length) {
            this.source[i].setParent(this);
            ++i;
        }
    }

    public DefExpr[] defs() {
        return this.target;
    }

    public StackExpr[] target() {
        return this.target;
    }

    public StackExpr[] source() {
        return this.source;
    }

    public int kind() {
        return this.kind;
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitStackManipStmt(this);
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            int i = this.target.length - 1;
            while (i >= 0) {
                this.target[i].visit(visitor);
                --i;
            }
            i = this.source.length - 1;
            while (i >= 0) {
                this.source[i].visit(visitor);
                --i;
            }
        } else {
            int i = 0;
            while (i < this.source.length) {
                this.source[i].visit(visitor);
                ++i;
            }
            i = 0;
            while (i < this.target.length) {
                this.target[i].visit(visitor);
                ++i;
            }
        }
    }

    public Object clone() {
        StackExpr[] t = new StackExpr[this.target.length];
        int i = 0;
        while (i < this.target.length) {
            t[i] = (StackExpr)this.target[i].clone();
            ++i;
        }
        StackExpr[] s = new StackExpr[this.source.length];
        int i2 = 0;
        while (i2 < this.source.length) {
            s[i2] = (StackExpr)this.source[i2].clone();
            ++i2;
        }
        return this.copyInto(new StackManipStmt(t, s, this.kind));
    }
}

