/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import jgnash.engine.Account;

public class AmortizeObject {
    private Account interestAccount;
    private Account bankAccount;
    private Account feesAccount;
    private int numPayments;
    private int length;
    private int numCompPeriods;
    private BigDecimal interestRate;
    private BigDecimal originalBalance;
    private BigDecimal fees = BigDecimal.ZERO;
    private String payee;
    private String memo;
    private Date date = new Date();
    private boolean useDailyRate;
    private BigDecimal daysPerYear;

    public void setDate(Date date) {
        this.date = (Date)date.clone();
    }

    public Date getDate() {
        return this.date;
    }

    public void setPaymentPeriods(int periods) {
        this.numPayments = periods;
    }

    public int getPaymentPeriods() {
        return this.numPayments;
    }

    public void setLength(int months) {
        this.length = months;
    }

    public int getLength() {
        return this.length;
    }

    public void setUseDailyRate(boolean daily) {
        this.useDailyRate = daily;
    }

    public boolean getUseDailyRate() {
        return this.useDailyRate;
    }

    public void setDaysPerYear(BigDecimal days) {
        this.daysPerYear = days;
    }

    public BigDecimal getDaysPerYear() {
        return this.daysPerYear;
    }

    public void setRate(BigDecimal rate) {
        this.interestRate = rate;
    }

    public BigDecimal getRate() {
        return this.interestRate;
    }

    public void setPrincipal(BigDecimal principal) {
        this.originalBalance = principal;
    }

    public BigDecimal getPrincipal() {
        return this.originalBalance;
    }

    public void setInterestPeriods(int periods) {
        this.numCompPeriods = periods;
    }

    public int getInterestPeriods() {
        return this.numCompPeriods;
    }

    public void setFees(BigDecimal fees) {
        this.fees = fees != null ? fees : BigDecimal.ZERO;
    }

    public BigDecimal getFees() {
        return this.fees;
    }

    public void setInterestAccount(Account id) {
        this.interestAccount = id;
    }

    public Account getInterestAccount() {
        return this.interestAccount;
    }

    public void setBankAccount(Account id) {
        this.bankAccount = id;
    }

    public Account getBankAccount() {
        return this.bankAccount;
    }

    public void setFeesAccount(Account id) {
        this.feesAccount = id;
    }

    public Account getFeesAccount() {
        return this.feesAccount;
    }

    public void setPayee(String payee) {
        this.payee = payee;
    }

    public String getPayee() {
        return this.payee;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getMemo() {
        return this.memo;
    }

    double getEffectiveInterestRate() {
        if (this.interestRate != null && this.numPayments > 0 && this.numCompPeriods > 0) {
            double i = this.interestRate.doubleValue() / 100.0;
            return StrictMath.pow(1.0 + i / (double)this.numCompPeriods, (double)this.numCompPeriods / (double)this.numPayments) - 1.0;
        }
        return 0.0;
    }

    double getDailyPeriodicInterestRate() {
        if (this.interestRate != null && this.numPayments > 0 && this.numCompPeriods > 0 && this.daysPerYear != null) {
            double rate = this.getEffectiveInterestRate();
            rate *= (double)this.numPayments;
            return rate /= this.daysPerYear.doubleValue();
        }
        return 0.0;
    }

    double getSumWithInterest() {
        return this.getPIPayment() * (double)this.length;
    }

    public double getTotalInterestPaid() {
        return this.getSumWithInterest() - this.originalBalance.doubleValue();
    }

    double getPIPayment() {
        if (this.length > 0 && this.numPayments > 0 && this.numCompPeriods > 0 && this.originalBalance != null && this.interestRate != null) {
            double i = this.getEffectiveInterestRate();
            double p = this.originalBalance.doubleValue();
            return p * (i / (1.0 - StrictMath.pow(1.0 + i, (double)this.length * -1.0)));
        }
        return 0.0;
    }

    public double getPayment() {
        return this.getPIPayment() + this.fees.doubleValue();
    }

    public double getIPayment(BigDecimal balance) {
        if (balance != null) {
            double i = this.getEffectiveInterestRate();
            return i * balance.doubleValue();
        }
        return 0.0;
    }

    public double getIPayment(BigDecimal balance, Date start, Date end) {
        if (balance != null) {
            Calendar c = Calendar.getInstance();
            c.setTime(end);
            int dayEnd = c.get(6);
            c.setTime(start);
            int dayStart = c.get(6);
            int days = Math.abs(dayEnd - dayStart);
            double i = this.getDailyPeriodicInterestRate();
            return i * (double)days * balance.doubleValue();
        }
        return 0.0;
    }

    public double getPPayment(BigDecimal balance) {
        return this.getPIPayment() - this.getIPayment(balance);
    }
}

