/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xml;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jgnash.engine.Account;
import jgnash.engine.CommodityNode;
import jgnash.engine.CurrencyNode;
import jgnash.engine.ExchangeRate;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.dao.CommodityDAO;
import jgnash.engine.xml.AbstractXMLDAO;
import jgnash.engine.xml.XMLContainer;

public class XMLCommodityDAO
extends AbstractXMLDAO
implements CommodityDAO {
    XMLCommodityDAO(XMLContainer container) {
        super(container);
    }

    @Override
    public boolean addCommodity(CommodityNode node) {
        boolean result = this.container.set(node);
        this.commit();
        return result;
    }

    @Override
    public boolean addExchangeRateHistory(ExchangeRate rate, ExchangeRateHistoryNode hNode) {
        this.commit();
        return true;
    }

    @Override
    public boolean addSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        this.commit();
        return true;
    }

    @Override
    public Set<CurrencyNode> getActiveCurrencies() {
        HashSet<CurrencyNode> set = new HashSet<CurrencyNode>();
        for (Account a : XMLCommodityDAO.stripMarkedForRemoval(this.container.query(Account.class))) {
            set.add(a.getCurrencyNode());
        }
        for (SecurityNode node : XMLCommodityDAO.stripMarkedForRemoval(this.container.query(SecurityNode.class))) {
            set.add(node.getReportedCurrencyNode());
        }
        return set;
    }

    @Override
    public List<CurrencyNode> getCurrencies() {
        return XMLCommodityDAO.stripMarkedForRemoval(this.container.query(CurrencyNode.class));
    }

    @Override
    public ExchangeRate getExchangeNode(String rateId) {
        ExchangeRate rate = null;
        for (ExchangeRate r : XMLCommodityDAO.stripMarkedForRemoval(this.container.query(ExchangeRate.class))) {
            if (!r.getRateId().equals(rateId)) continue;
            rate = r;
            break;
        }
        return rate;
    }

    @Override
    public List<SecurityNode> getSecurities() {
        return XMLCommodityDAO.stripMarkedForRemoval(this.container.query(SecurityNode.class));
    }

    @Override
    public List<ExchangeRate> getExchangeRates() {
        return XMLCommodityDAO.stripMarkedForRemoval(this.container.query(ExchangeRate.class));
    }

    @Override
    public void refreshCommodityNode(CommodityNode node) {
    }

    @Override
    public void refreshExchangeRate(ExchangeRate rate) {
    }

    @Override
    public boolean removeExchangeRateHistory(ExchangeRate rate, ExchangeRateHistoryNode hNode) {
        this.commit();
        return true;
    }

    @Override
    public boolean removeSecurityHistory(SecurityNode node, SecurityHistoryNode hNode) {
        this.commit();
        return true;
    }

    @Override
    public void addExchangeRate(ExchangeRate eRate) {
        this.container.set(eRate);
        this.commit();
    }

    @Override
    public boolean updateCommodityNode(CommodityNode node) {
        this.commit();
        return true;
    }
}

