/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.ofx;

import java.util.List;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionFactory;
import jgnash.imports.GenericImport;
import jgnash.imports.ImportTransaction;
import jgnash.imports.ofx.OfxBank;
import jgnash.imports.ofx.OfxTransaction;

public class OfxImport {
    private static final boolean DEBUG = false;

    public static void importTransactions(List<OfxTransaction> transactions, Account baseAccount) {
        assert (transactions != null && baseAccount != null);
        Engine engine = EngineFactory.getEngine("default");
        for (OfxTransaction tran : transactions) {
            Transaction t;
            assert (tran.account != null);
            if (!tran.getState().equals((Object)ImportTransaction.ImportState.NEW) && !tran.getState().equals((Object)ImportTransaction.ImportState.NOTEQUAL) || (t = baseAccount.equals(tran.account) ? TransactionFactory.generateSingleEntryTransaction(baseAccount, tran.amount, tran.datePosted, false, tran.memo, tran.getName(), tran.checkNumber) : (tran.amount.signum() >= 0 ? TransactionFactory.generateDoubleEntryTransaction(baseAccount, tran.account, tran.amount.abs(), tran.datePosted, tran.memo, tran.getName(), tran.checkNumber) : TransactionFactory.generateDoubleEntryTransaction(tran.account, baseAccount, tran.amount.abs(), tran.datePosted, tran.memo, tran.getName(), tran.checkNumber))) == null) continue;
            t.setFitid(tran.transactionID);
            engine.addTransaction(t);
        }
    }

    public static Account matchAccount(OfxBank bank) {
        Account account;
        block2: {
            String number;
            Engine engine;
            block3: {
                engine = EngineFactory.getEngine("default");
                account = null;
                number = bank.accountId;
                String symbol = bank.currency;
                CurrencyNode node = engine.getCurrency(symbol);
                if (node == null) break block3;
                for (Account a : engine.getAccountList()) {
                    if (a.getAccountNumber() == null || !a.getAccountNumber().equals(number) || !a.getCurrencyNode().equals(node)) continue;
                    account = a;
                    break block2;
                }
                break block2;
            }
            if (number == null) break block2;
            for (Account a : engine.getAccountList()) {
                if (!a.getAccountNumber().equals(number)) continue;
                account = a;
                break;
            }
        }
        return account;
    }

    public static void matchTransactions(List<OfxTransaction> list, Account baseAccount) {
        GenericImport.matchTransactions(list, baseAccount);
    }

    private OfxImport() {
    }
}

