/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui;

import com.jhlabs.image.BlurFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImageOp;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RepaintManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultEditorKit;
import jgnash.Main;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.net.currency.CurrencyUpdateFactory;
import jgnash.net.security.AbstractYahooParser;
import jgnash.net.security.SecurityUpdateFactory;
import jgnash.plugin.Plugin;
import jgnash.plugin.PluginFactory;
import jgnash.ui.ConsoleDialog;
import jgnash.ui.EDTCheckingRepaintManager;
import jgnash.ui.MainViewPanel;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.ThemeManager;
import jgnash.ui.UIApplication;
import jgnash.ui.account.ExpandingAccountTablePanel;
import jgnash.ui.actions.CloseEngineAction;
import jgnash.ui.actions.ExportAccountsAction;
import jgnash.ui.actions.HelpAction;
import jgnash.ui.actions.ImportAccountsAction;
import jgnash.ui.actions.ImportJgnashAction;
import jgnash.ui.actions.ImportOfxAction;
import jgnash.ui.actions.ImportQifAction;
import jgnash.ui.actions.OpenAction;
import jgnash.ui.actions.PortfolioReportAction;
import jgnash.ui.actions.SaveFileAsAction;
import jgnash.ui.checks.CheckDesignDialog;
import jgnash.ui.checks.PrintCheckFactory;
import jgnash.ui.commodity.CurrenciesPanel;
import jgnash.ui.commodity.CurrencyExchangeDialog;
import jgnash.ui.commodity.CurrencyModifyDialog;
import jgnash.ui.commodity.SecuritiesHistoryDialog;
import jgnash.ui.commodity.SecurityModifyPanel;
import jgnash.ui.commodity.YahooSecurityHistoryImportDialog;
import jgnash.ui.components.MemoryMonitor;
import jgnash.ui.components.SubstanceFontSlider;
import jgnash.ui.components.WaitMessagePanel;
import jgnash.ui.option.OptionDialog;
import jgnash.ui.recurring.RecurringPanel;
import jgnash.ui.register.MainRegisterPanel;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterFrame;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.report.compiled.AccountRegisterReport;
import jgnash.ui.report.compiled.BalanceSheetReport;
import jgnash.ui.report.compiled.IncomeExpensePieChart;
import jgnash.ui.report.compiled.MonthBalanceCSV;
import jgnash.ui.report.compiled.MonthlyAccountBalanceChart;
import jgnash.ui.report.compiled.NetWorthReport;
import jgnash.ui.report.compiled.PayeePieChart;
import jgnash.ui.report.compiled.ProfitLossReport;
import jgnash.ui.report.compiled.ProfitLossTXT;
import jgnash.ui.report.compiled.RunningAccountBalanceChart;
import jgnash.ui.report.compiled.SecurityHighLowChart;
import jgnash.ui.splash.AboutDialog;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.builder.ActionParser;
import jgnash.ui.wizards.file.NewFileDialog;
import jgnash.util.DefaultDaemonThreadFactory;
import jgnash.util.Resource;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.jxlayer.plaf.effect.BufferedImageOpEffect;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXStatusBar;

public class MainFrame
extends JFrame
implements MessageListener,
ActionListener {
    private static final String REGISTER_KEY = "register";
    private static final String JAVASCRIPT_DIR = "javascriptdir";
    private static final String REGSITER_FOLLOWS_LIST = "RegisterFollowsList";
    private JMenuBar menuBar;
    private JMenu windowMenu;
    private JMenu viewMenu;
    private JMenu reportMenu;
    private MainViewPanel mainView;
    private final Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
    private final Resource rb = Resource.get();
    private WaitMessagePanel waitPanel;
    private static boolean registerFollowsTree = MainFrame.doesRegisterFollowTree();
    private MainRegisterPanel registerTreePanel;
    private Action editAction;
    private Action filterAction;
    private Action toolAction;
    private ExpandingAccountTablePanel expandingAccountPanel;
    private JTextField statusField;
    private final Logger log = Logger.getLogger(MainFrame.class.getName());
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new DefaultDaemonThreadFactory());
    private static final int SCHEDULED_DELAY = 10;
    private JXBusyLabel backgroundOperationLabel;
    private LogHandler logHandler = new LogHandler();
    private Color infoColor = null;
    private LockableUI primaryWaitBlurUI = new LockableUI(new LayerEffect[]{new BufferedImageOpEffect(new BufferedImageOp[]{new BlurFilter()})});

    public MainFrame() {
        ThemeManager themeManager = new ThemeManager(this);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Resource.getLocale()));
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.buildUI();
        this.setDefaultCloseOperation(2);
        if (Main.checkEDT()) {
            this.log.info("Installing Event Dispatch Thread Checker into RepaintManager");
            RepaintManager.setCurrentManager(new EDTCheckingRepaintManager());
        }
        this.viewMenu.insertSeparator(this.viewMenu.getComponentCount() + 1);
        this.viewMenu.add(themeManager.buildLookAndFeelMenu());
        this.viewMenu.add(themeManager.buildThemeMenu());
        this.addWindowListener(new ShutdownAdapter());
        RegisterFrame.addRegisterListener(new RegisterListener(){

            @Override
            public void registerEvent(RegisterEvent e) {
                if (e.getAction() == RegisterEvent.Action.OPEN) {
                    MainFrame.this.addWindowItem(e);
                } else if (e.getAction() == RegisterEvent.Action.CLOSE) {
                    MainFrame.this.removeWindowItem(e);
                }
            }
        });
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT);
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
        this.registerLogHandler(Engine.class);
        this.registerLogHandler(EngineFactory.class);
        this.registerLogHandler(AbstractYahooParser.class);
        this.registerLogHandler(UIApplication.class);
        SecurityUpdateFactory.getUpdateOnStartup();
        this.registerLogHandler(SecurityUpdateFactory.class);
        this.loadPlugins();
        this.pack();
        DialogUtils.addBoundsListener(this);
        this.log.fine("UI Construction is complete");
        if (EngineFactory.getEngine("default") != null) {
            this.setOpenState(true);
            this.addViews();
            this.updateTitle();
        }
    }

    private void loadPlugins() {
        PluginFactory.get().loadPlugins();
        PluginFactory.get().startPlugins();
        for (Plugin plugin : PluginFactory.getPlugins()) {
            JMenuItem[] menuItems = plugin.getMenuItems();
            if (menuItems == null) continue;
            for (JMenuItem menuItem : menuItems) {
                Object precedingIdref = menuItem.getClientProperty("PrecedingMenuIdref");
                if (precedingIdref == null || !(precedingIdref instanceof String)) continue;
                this.addMenuItem((String)precedingIdref, menuItem);
            }
        }
    }

    public static boolean doesRegisterFollowTree() {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        return pref.getBoolean(REGSITER_FOLLOWS_LIST, true);
    }

    public static void setRegisterFollowsTree(boolean follow) {
        Preferences pref = Preferences.userNodeForPackage(MainFrame.class);
        registerFollowsTree = follow;
        pref.putBoolean(REGSITER_FOLLOWS_LIST, follow);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.mainView) {
            this.mainViewAction();
        }
    }

    public void addRemoveCurrencies() {
        CurrenciesPanel.showDialog(this);
    }

    private void addViews() {
        this.registerTreePanel = new MainRegisterPanel();
        this.expandingAccountPanel = new ExpandingAccountTablePanel();
        this.mainView.addView(this.expandingAccountPanel, this.rb.getString("Button.Accounts"), this.rb.getString("ToolTip.AccountList"));
        this.mainView.addView(this.registerTreePanel, this.rb.getString("Button.Register"), this.rb.getString("ToolTip.AccountRegister"));
        this.mainView.addView(new RecurringPanel(), this.rb.getString("Button.Reminders"), this.rb.getString("ToolTip.Reminders"));
    }

    private void addWindowItem(final RegisterEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterFrame d = (RegisterFrame)e.getSource();
                JMenuItem mi = new JMenuItem(new WindowAction(d));
                int size = MainFrame.this.windowMenu.getMenuComponentCount();
                MainFrame.this.windowMenu.insert(mi, size - 2);
                MainFrame.this.windowMenu.setEnabled(true);
            }
        });
    }

    private void addMenuItem(String precedingMenuIdref, JMenuItem newMenuItem) {
        for (Component component : this.menuBar.getComponents()) {
            if (!(component instanceof JMenu)) continue;
            this.addJMenuItem((JMenu)component, precedingMenuIdref, newMenuItem);
        }
    }

    private void addJMenuItem(JMenu menu, String precedingMenuIdref, JMenuItem newMenuItem) {
        Component[] components = menu.getMenuComponents();
        for (int i = 0; i < components.length; ++i) {
            JMenuItem item;
            if (components[i] instanceof JMenu) {
                this.addJMenuItem((JMenu)components[i], precedingMenuIdref, newMenuItem);
                continue;
            }
            if (!(components[i] instanceof JMenuItem) || !precedingMenuIdref.equals((item = (JMenuItem)components[i]).getClientProperty("idref"))) continue;
            menu.add((Component)newMenuItem, i + 1);
            return;
        }
    }

    private MainViewPanel buildMainView() {
        MainViewPanel mainView = new MainViewPanel();
        mainView.setBorder(new EmptyBorder(new Insets(2, 6, 0, 2)));
        mainView.addActionListener(this);
        return mainView;
    }

    private void buildUI() {
        ActionParser actionParser = new ActionParser(this, Resource.get());
        actionParser.preLoadAction("copy-command", new DefaultEditorKit.CopyAction());
        actionParser.preLoadAction("cut-command", new DefaultEditorKit.CutAction());
        actionParser.preLoadAction("paste-command", new DefaultEditorKit.PasteAction());
        actionParser.preLoadAction("qifimport-command", new ImportQifAction());
        actionParser.preLoadAction("ofximport-command", new ImportOfxAction());
        actionParser.preLoadAction("accountsimport-command", new ImportAccountsAction());
        actionParser.preLoadAction("exportAccounts-command", new ExportAccountsAction());
        actionParser.preLoadAction("report-portfolio-command", new PortfolioReportAction());
        actionParser.preLoadAction("close-command", new CloseEngineAction());
        actionParser.preLoadAction("saveas-command", new SaveFileAsAction());
        actionParser.preLoadAction("help-command", new HelpAction());
        actionParser.loadFile("/jgnash/resource/main-frame-actions.xml");
        this.menuBar = actionParser.createMenuBar("main-menu");
        JToolBar toolBar = actionParser.createToolBar("main-toolbar");
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        this.viewMenu = (JMenu)actionParser.getJMenuItem("view-menu-command");
        this.reportMenu = (JMenu)actionParser.getJMenuItem("report-menu-command");
        this.windowMenu = (JMenu)actionParser.getJMenuItem("window-menu-command");
        this.windowMenu.setEnabled(false);
        this.editAction = actionParser.getAction("edit-menu-command");
        this.filterAction = actionParser.getAction("filter-menu-command");
        this.toolAction = actionParser.getAction("tools-menu-command");
        if (EngineFactory.getEngine("default") == null) {
            this.setOpenState(false);
        }
        this.setTitle(Main.VERSION);
        this.mainView = this.buildMainView();
        this.backgroundOperationLabel = new JXBusyLabel(new Dimension(18, 18));
        this.statusField = new JTextField();
        this.statusField.setEditable(false);
        this.statusField.setFont(this.statusField.getFont().deriveFont(this.statusField.getFont().getSize2D() - 1.0f));
        this.infoColor = this.statusField.getForeground();
        JXStatusBar statusBar = new JXStatusBar();
        statusBar.setResizeHandleEnabled(true);
        statusBar.add((Component)this.statusField, (Object)new JXStatusBar.Constraint(JXStatusBar.Constraint.ResizeBehavior.FILL));
        if (ThemeManager.isLookAndFeelSubstance()) {
            statusBar.add((Component)new SubstanceFontSlider());
        }
        statusBar.add((Component)this.backgroundOperationLabel);
        statusBar.add((Component)new MemoryMonitor(), (Object)new JXStatusBar.Constraint(120));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)toolBar, "North");
        contentPanel.add((Component)this.mainView, "Center");
        contentPanel.add((Component)statusBar, "South");
        JPanel rootPanel = new JPanel(new BorderLayout());
        rootPanel.add((Component)this.menuBar, "North");
        rootPanel.add((Component)contentPanel, "Center");
        this.waitPanel = new WaitMessagePanel();
        JXLayer rootLayer = new JXLayer((Component)rootPanel);
        rootLayer.setUI((LayerUI)this.primaryWaitBlurUI);
        this.getContentPane().add((Component)rootLayer, "Center");
        this.setGlassPane((Component)((Object)this.waitPanel));
    }

    public void closeAllWindows() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Component c : MainFrame.this.windowMenu.getMenuComponents()) {
                    JMenuItem m;
                    if (!(c instanceof JMenuItem) || !((m = (JMenuItem)c).getAction() instanceof WindowAction)) continue;
                    RegisterFrame d = (RegisterFrame)m.getAction().getValue(MainFrame.REGISTER_KEY);
                    d.dispatchEvent(new WindowEvent(d, 201));
                }
            }
        });
    }

    final void displayStatus(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.statusField.setForeground(MainFrame.this.infoColor);
                MainFrame.this.statusField.setText(message);
            }
        });
    }

    public void displayWaitMessage(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.primaryWaitBlurUI.setLocked(true);
                MainFrame.this.waitPanel.setMessage(message);
                MainFrame.this.waitPanel.setWaiting(true);
            }
        });
    }

    private void displayWarning(final String message) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.statusField.setForeground(Color.RED);
                MainFrame.this.statusField.setText(message);
            }
        });
    }

    void dispose(boolean shutDown) {
        PluginFactory.get().stopPlugins();
        if (!shutDown) {
            for (WindowListener listener : this.getWindowListeners()) {
                if (!(listener instanceof ShutdownAdapter)) continue;
                this.removeWindowListener(listener);
            }
        }
        super.dispose();
    }

    public void importOldJgnash() {
        ImportJgnashAction.importAction(this);
    }

    void loadFile(File file) {
        OpenAction.openAction(file);
        this.startBackgroundUpdates();
    }

    void loadLast() {
        OpenAction.openLastAction();
        this.startBackgroundUpdates();
    }

    private void mainViewAction() {
        if (this.mainView.getVisibleComponent() == this.registerTreePanel && registerFollowsTree) {
            this.registerTreePanel.setAccount(this.expandingAccountPanel.getSelectedAccount());
        }
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case FILE_CLOSING: {
                        MainFrame.this.setOpenState(false);
                        MainFrame.this.updateTitle();
                        MainFrame.this.removeViews();
                        break;
                    }
                    case FILE_NOT_FOUND: {
                        break;
                    }
                    case FILE_IO_ERROR: {
                        break;
                    }
                    case FILE_LOAD_FAILED: {
                        break;
                    }
                    case ACCOUNT_REMOVE_FAILED: {
                        StaticUIMethods.displayError(MainFrame.this.rb.getString("Message.ErrorAccoutRemove"));
                        break;
                    }
                    case FILE_LOAD_SUCCESS: 
                    case FILE_NEW_SUCCESS: {
                        MainFrame.this.setOpenState(true);
                        MainFrame.this.addViews();
                        MainFrame.this.updateTitle();
                        break;
                    }
                }
            }
        });
    }

    public void modifyCurrencies() {
        CurrencyModifyDialog.showDialog(this);
    }

    public void newFile() {
        NewFileDialog.showDialog(this);
    }

    public void openFile() {
        OpenAction.openAction();
        this.startBackgroundUpdates();
    }

    void openRemote(String host, int port, String user, String password) {
        OpenAction.openRemote(host, port, user, password);
        this.startBackgroundUpdates();
    }

    private void registerLogHandler(Class<?> clazz) {
        Logger.getLogger(clazz.getName()).addHandler(this.logHandler);
    }

    private void removeViews() {
        this.mainView.removeAll();
        this.expandingAccountPanel = null;
        this.registerTreePanel = null;
    }

    private void removeWindowItem(final RegisterEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RegisterFrame d = (RegisterFrame)e.getSource();
                for (Component c : MainFrame.this.windowMenu.getMenuComponents()) {
                    JMenuItem m;
                    if (!(c instanceof JMenuItem) || !((m = (JMenuItem)c).getAction() instanceof WindowAction) || d != m.getAction().getValue(MainFrame.REGISTER_KEY)) continue;
                    MainFrame.this.windowMenu.remove(c);
                    if (MainFrame.this.windowMenu.getItemCount() < 3) {
                        MainFrame.this.windowMenu.setEnabled(false);
                    }
                    return;
                }
            }
        });
    }

    public void runJavaScript() {
        JFileChooser chooser = new JFileChooser(this.pref.get(JAVASCRIPT_DIR, null));
        if (chooser.showOpenDialog(this) == 0) {
            this.pref.put(JAVASCRIPT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            final String file = chooser.getSelectedFile().getAbsolutePath();
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FileReader reader = null;
                    try {
                        reader = new FileReader(file);
                        new ScriptEngineManager().getEngineByName("JavaScript").eval(reader);
                    }
                    catch (Exception e) {
                        MainFrame.this.log.log(Level.SEVERE, e.toString(), e);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
    }

    public void setNetworkBusy(boolean busy) {
        this.backgroundOperationLabel.setBusy(busy);
    }

    private void setOpenState(boolean state) {
        this.editAction.setEnabled(state);
        this.filterAction.setEnabled(state);
        this.toolAction.setEnabled(state);
        this.reportMenu.setEnabled(state);
    }

    public void showAboutDialog() {
        AboutDialog.showDialog(this);
    }

    public void showAccountListFilter() {
        this.expandingAccountPanel.showAccountFilterDialog();
    }

    public void showAccountRegisterReport() {
        new AccountRegisterReport(null).showReport();
    }

    public void showBalanceSheetReport() {
        new BalanceSheetReport().showReport();
    }

    public void showCommodityHistoryDialog() {
        SecuritiesHistoryDialog.showDialog(this);
    }

    public void showCommodityHistoryImportDialog() {
        new YahooSecurityHistoryImportDialog().setVisible(true);
    }

    public void showCommodityModifyDialog() {
        SecurityModifyPanel.showDialog(this);
    }

    public void showConsoleWindow() {
        ConsoleDialog.show();
    }

    public void showCurrencyExchangeDialog() {
        CurrencyExchangeDialog.showDialog(this);
    }

    public void showDefaultCurrencyDialog() {
        StaticUIMethods.setDefaultCurrency(this);
    }

    public void showDefaultLocaleDialog() {
        StaticUIMethods.setDefaultLocale(this);
    }

    public void showDesignChecksDialog() {
        new CheckDesignDialog((Frame)this, true).setVisible(true);
    }

    public void showIncomeExpenseChart() {
        IncomeExpensePieChart.show();
    }

    public void showMonthBalanceCSV() {
        MonthBalanceCSV.run();
    }

    public void showMonthlyAccountBalanceChart() {
        MonthlyAccountBalanceChart.show();
    }

    public void showNetWorthReport() {
        new NetWorthReport().showReport();
    }

    public void showOptionsDialog() {
        OptionDialog.showDialog();
    }

    public void showPayeePieChart() {
        PayeePieChart.show();
    }

    public void showPrintChecksDialog() {
        PrintCheckFactory.showDialog();
    }

    public void showProfitLossReport() {
        new ProfitLossReport().showReport();
    }

    public void showProfitLossTXTReport() {
        new ProfitLossTXT();
    }

    public void showRecurringDialog() {
        RecurringPanel.showDialog(this);
    }

    public void showRegisterFilter() {
        this.registerTreePanel.showAccountFilterDialog();
    }

    public void showRunningAccountBalanceChart() {
        RunningAccountBalanceChart.show();
    }

    public void showSecurityHighLowChart() {
        SecurityHighLowChart.show();
    }

    public void shutDown() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.dispatchEvent(new WindowEvent(MainFrame.this, 201));
            }
        });
    }

    public void startBackgroundCurrencyUpdate() {
        this.executor.schedule(CurrencyUpdateFactory.getUpdateWorker(), 1L, TimeUnit.SECONDS);
    }

    public void startBackgroundSecurityUpdate() {
        this.executor.schedule(SecurityUpdateFactory.getUpdateWorker(), 1L, TimeUnit.SECONDS);
    }

    private void startBackgroundUpdates() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SecurityUpdateFactory.getUpdateOnStartup()) {
                    MainFrame.this.executor.schedule(SecurityUpdateFactory.getUpdateWorker(), 10L, TimeUnit.SECONDS);
                }
                if (CurrencyUpdateFactory.getUpdateOnStartup()) {
                    MainFrame.this.executor.schedule(CurrencyUpdateFactory.getUpdateWorker(), 10L, TimeUnit.SECONDS);
                }
            }
        });
    }

    public void stopWaitMessage() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.waitPanel.setWaiting(false);
                MainFrame.this.primaryWaitBlurUI.setLocked(false);
            }
        });
    }

    private void updateTitle() {
        Engine e = EngineFactory.getEngine("default");
        if (e != null) {
            this.setTitle(Main.VERSION + "  [" + EngineFactory.getActiveDatabase() + ']');
        } else {
            this.setTitle(Main.VERSION);
        }
    }

    private static class WindowAction
    extends AbstractAction {
        private static final long serialVersionUID = -598477156303870342L;

        protected WindowAction(RegisterFrame d) {
            super(d.toString());
            this.putValue(MainFrame.REGISTER_KEY, d);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final RegisterFrame d = (RegisterFrame)this.getValue(MainFrame.REGISTER_KEY);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (d.getExtendedState() == 1) {
                        d.setExtendedState(0);
                    }
                    d.toFront();
                }
            });
        }
    }

    private class ShutdownAdapter
    extends WindowAdapter {
        private ShutdownAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.closeAllWindows();
                    MainFrame.this.removeViews();
                    EngineFactory.closeEngine("default");
                    System.exit(0);
                }
            });
        }
    }

    private class LogHandler
    extends Handler {
        private LogHandler() {
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public synchronized void publish(final LogRecord record) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (record.getLevel() == Level.WARNING || record.getLevel() == Level.SEVERE) {
                        MainFrame.this.displayWarning(record.getMessage());
                    } else {
                        MainFrame.this.displayStatus(record.getMessage());
                    }
                }
            });
        }
    }
}

