/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.util.Set;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.SecurityNode;
import jgnash.ui.account.AccountDialog;
import jgnash.util.Resource;

class AccountTools {
    private AccountTools() {
    }

    protected static void createAccount(Account _account) {
        Account parentAccount = _account;
        Resource rb = Resource.get();
        Engine engine = EngineFactory.getEngine("default");
        if (parentAccount == null) {
            if (engine.getRootAccount() == null) {
                return;
            }
            parentAccount = engine.getRootAccount();
        }
        AccountDialog dlg = new AccountDialog();
        dlg.setParentAccount(parentAccount);
        dlg.setAccountType(parentAccount.getAccountType());
        dlg.setTitle(rb.getString("Title.NewAccount"));
        dlg.setVisible(true);
        if (dlg.returnStatus()) {
            CurrencyNode commodity = dlg.getAccountCommodity();
            AccountType accType = dlg.getAccountType();
            Account account = new Account(accType, commodity);
            if (accType.getAccountGroup().equals((Object)AccountGroup.INVEST)) {
                Set<SecurityNode> collection = dlg.getAccountSecurities();
                for (SecurityNode node : collection) {
                    account.addSecurity(node);
                }
            }
            account.setName(dlg.getAccountName());
            account.setAccountNumber(dlg.getAccountCode());
            account.setDescription(dlg.getAccountDescription());
            account.setNotes(dlg.getAccountNotes());
            account.setLocked(dlg.isAccountLocked());
            account.setPlaceHolder(dlg.isAccountPlaceholder());
            account.setVisible(dlg.isAccountVisible());
            engine.addAccount(dlg.getParentAccount(), account);
        }
    }

    protected static void modifyAccount(Account account) {
        if (account == null) {
            return;
        }
        Engine engine = EngineFactory.getEngine("default");
        Resource rb = Resource.get();
        Account parentAccount = account.getParent();
        if (parentAccount == null) {
            if (engine.getRootAccount() == null) {
                return;
            }
            account.setParent(engine.getRootAccount());
        }
        AccountDialog dlg = new AccountDialog();
        dlg.setParentAccount(account.getParent());
        dlg.setAccountName(account.getName());
        dlg.setAccountDescription(account.getDescription());
        dlg.setAccountCode(account.getAccountNumber());
        dlg.setAccountCommodity(account.getCurrencyNode());
        dlg.setAccountNotes(account.getNotes());
        dlg.setAccountLocked(account.isLocked());
        dlg.setTitle(rb.getString("Title.ModifyAccount"));
        dlg.setAccountVisible(account.isVisible());
        if (account.getAccountType().getAccountGroup().equals((Object)AccountGroup.INVEST)) {
            dlg.setAccountSecurities(account.getSecurities());
        }
        dlg.setAccountType(account.getAccountType());
        dlg.disableAccountType(account.getAccountType());
        if (account.getTransactionCount() > 0) {
            dlg.disableAccountCurrency();
        }
        if (account.getTransactionCount() > 0) {
            dlg.setPlaceholderEnabled(false);
        } else {
            dlg.setAccountPlaceholder(account.isPlaceHolder());
        }
        dlg.setVisible(true);
        if (dlg.returnStatus()) {
            Account tAccount = new Account(dlg.getAccountType(), dlg.getAccountCommodity());
            tAccount.setAccountNumber(dlg.getAccountCode());
            tAccount.setName(dlg.getAccountName());
            tAccount.setDescription(dlg.getAccountDescription());
            tAccount.setNotes(dlg.getAccountNotes());
            tAccount.setLocked(dlg.isAccountLocked());
            tAccount.setPlaceHolder(dlg.isAccountPlaceholder());
            if (dlg.getParentAccount() == account) {
                tAccount.setParent(account.getParent());
                System.out.println("Prevented an attempt to assign accounts parent to itself");
            } else {
                tAccount.setParent(dlg.getParentAccount());
            }
            tAccount.setVisible(dlg.isAccountVisible());
            engine.modifyAccount(tAccount, account);
            if (account.getAccountType().getAccountGroup().equals((Object)AccountGroup.INVEST)) {
                engine.updateAccountSecurities(account, dlg.getAccountSecurities());
            }
        }
    }
}

